/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.AbstractReportFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.internal.bugzilla.core.SaxMultiBugReportContentHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBugReportFactory
extends AbstractReportFactory {
    private final BugzillaRepositoryConnector connector;

    public MultiBugReportFactory(InputStream inStream, String encoding, BugzillaRepositoryConnector connector) {
        super(inStream, encoding);
        this.connector = connector;
    }

    public void populateReport(Map<String, TaskData> bugMap, TaskDataCollector collector, TaskAttributeMapper mapper, List<BugzillaCustomField> customFields) throws IOException, CoreException {
        SaxMultiBugReportContentHandler contentHandler = new SaxMultiBugReportContentHandler(mapper, collector, bugMap, customFields, this.connector);
        this.collectResults(contentHandler, false);
        for (TaskData data : bugMap.values()) {
            TaskAttribute attrCreation = data.getRoot().getAttribute(BugzillaAttribute.CREATION_TS.getKey());
            if (attrCreation != null && attrCreation.getValue() != null && attrCreation.getValue().length() != 0) continue;
            collector.failed(data.getTaskId(), (IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", IBugzillaConstants.ERROR_MSG_NO_DATA_RETRIEVED));
        }
        if (bugMap.size() == 1 && contentHandler.errorOccurred()) {
            String errorResponse = contentHandler.getErrorMessage().toLowerCase(Locale.ENGLISH);
            if (errorResponse.equals("notfound") || errorResponse.equals("invalidbugid")) {
                throw new CoreException((IStatus)new BugzillaStatus(2, "org.eclipse.mylyn.bugzilla", 1, "", IBugzillaConstants.ERROR_MSG_INVALID_BUG_ID));
            }
            if (errorResponse.equals("notpermitted")) {
                throw new CoreException((IStatus)new BugzillaStatus(1, "org.eclipse.mylyn.bugzilla", 3, mapper.getTaskRepository().getRepositoryUrl(), IBugzillaConstants.ERROR_MSG_OP_NOT_PERMITTED));
            }
            throw new CoreException((IStatus)new BugzillaStatus(2, "org.eclipse.mylyn.bugzilla", 1, "", "Unexpected error occurred: " + errorResponse));
        }
    }
}

