/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

public class ComponentNode
extends AbstractNode {
    private ComponentInfo ci;

    public ComponentNode(ComponentInfo ci) {
        super((Children)(ci.getSubComponents().length > 0 ? new ComponentChildren(ci) : Children.LEAF), Lookups.singleton((Object)ci));
        this.ci = ci;
        ci.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComponentNode.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public String getDisplayName() {
        return this.ci.getDisplayName();
    }

    public String getHtmlDisplayName() {
        return this.ci.getHtmlDisplayName();
    }

    public Action[] getActions(boolean context) {
        return this.ci.getActions(context);
    }

    public Node.PropertySet[] getPropertySets() {
        return this.ci.getPropertySets();
    }

    ComponentNode findNodeFor(ComponentInfo ci) {
        Node[] subNodes;
        if (ci.equals(this.ci)) {
            return this;
        }
        Children ch = this.getChildren();
        for (Node n : subNodes = ch.getNodes()) {
            ComponentNode cn = (ComponentNode)n;
            ComponentNode node = cn.findNodeFor(ci);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public String toString() {
        return super.toString() + ", node's ci = " + this.ci;
    }

    private static class ComponentChildren
    extends Children.Keys<ComponentInfo> {
        private ComponentInfo ci;

        public ComponentChildren(ComponentInfo ci) {
            this.ci = ci;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.ci.getSubComponents());
        }

        protected Node[] createNodes(ComponentInfo key) {
            return new Node[]{new ComponentNode(key)};
        }
    }
}

