/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.RemoteScreenshot;
import org.netbeans.modules.debugger.jpda.visual.spi.ScreenshotUIManager;
import org.netbeans.modules.debugger.jpda.visual.ui.ComponentHierarchy;
import org.netbeans.modules.debugger.jpda.visual.ui.ComponentHierarchyNavigatorHint;
import org.netbeans.modules.debugger.jpda.visual.ui.ComponentNode;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ScreenshotComponent
extends TopComponent {
    private static final Logger logger = Logger.getLogger(ScreenshotComponent.class.getName());
    private static final Map<DebuggerEngine, Set<ScreenshotComponent>> openedScreenshots = new HashMap<DebuggerEngine, Set<ScreenshotComponent>>();
    private static volatile ScreenshotComponent activeScreenshotComponent;
    private RemoteScreenshot screenshot;
    private ScreenshotUIManager manager;
    private NavigatorLookupHint componentHierarchyNavigatorHint = new ComponentHierarchyNavigatorHint();
    private ComponentNode componentNodes;
    private ScreenshotCanvas canvas;
    private JScrollPane scrollPane;
    private boolean propertiesOpened;

    public ScreenshotComponent(RemoteScreenshot screenshot, ScreenshotUIManager manager) {
        this.screenshot = screenshot;
        this.manager = manager;
        screenshot.getImage();
        ScreenshotCanvas c = new ScreenshotCanvas(screenshot.getImage());
        this.scrollPane = new JScrollPane(c);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane, "Center");
        this.canvas = c;
        String title = screenshot.getTitle();
        title = title == null ? NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_DebuggerSnapshot") : NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_DebuggerSnapshotOf", (Object)title);
        this.setDisplayName(title);
        this.componentNodes = new ComponentNode(screenshot.getComponentInfo());
        ComponentHierarchy.getInstance().getExplorerManager().setRootContext((Node)this.componentNodes);
        ComponentInfo firstCi = ScreenshotComponent.getFirstCustomComponent((Node)this.componentNodes);
        if (firstCi != null) {
            c.listener.selectComponent(firstCi, false);
        } else {
            this.setActivatedNodes(new Node[]{this.componentNodes});
        }
    }

    private static ComponentInfo getFirstCustomComponent(Node node) {
        Node[] nodes;
        ComponentInfo ci = (ComponentInfo)node.getLookup().lookup(ComponentInfo.class);
        if (ci != null && ci instanceof JavaComponentInfo && ((JavaComponentInfo)ci).isCustomType()) {
            return ci;
        }
        for (Node n : nodes = node.getChildren().getNodes()) {
            ComponentInfo fci = ScreenshotComponent.getFirstCustomComponent(n);
            if (fci == null) continue;
            return fci;
        }
        return null;
    }

    public static ScreenshotComponent getActive() {
        return activeScreenshotComponent;
    }

    public ScreenshotUIManager getManager() {
        return this.manager;
    }

    public ComponentInfo getSelectedComponent() {
        Node[] nodes = this.getActivatedNodes();
        if (nodes.length > 0) {
            return (ComponentInfo)nodes[0].getLookup().lookup(ComponentInfo.class);
        }
        return null;
    }

    public Lookup getLookup() {
        Lookup lookup = super.getLookup();
        return new ProxyLookup(new Lookup[]{lookup, Lookups.singleton((Object)this.componentHierarchyNavigatorHint)});
    }

    protected void componentActivated() {
        logger.fine("componentActivated() root = " + (Object)((Object)this.componentNodes) + ", ci = " + this.componentNodes.getLookup().lookup(ComponentInfo.class));
        activeScreenshotComponent = this;
        ComponentHierarchy.getInstance().getExplorerManager().setRootContext((Node)this.componentNodes);
        ComponentHierarchy.getInstance().getExplorerManager().setExploredContext((Node)this.componentNodes);
        this.canvas.activated();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
    }

    protected void componentShowing() {
        super.componentShowing();
        TopComponent properties = WindowManager.getDefault().findTopComponent("properties");
        if (properties != null && !properties.isOpened()) {
            this.propertiesOpened = true;
            properties.open();
        }
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.propertiesOpened) {
            this.propertiesOpened = false;
            TopComponent properties = WindowManager.getDefault().findTopComponent("properties");
            if (properties != null) {
                properties.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentOpened() {
        Map<DebuggerEngine, Set<ScreenshotComponent>> map = openedScreenshots;
        synchronized (map) {
            Set<ScreenshotComponent> components = openedScreenshots.get(this.screenshot.getDebuggerEngine());
            if (components == null) {
                components = new HashSet<ScreenshotComponent>();
                openedScreenshots.put(this.screenshot.getDebuggerEngine(), components);
            }
            components.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        if (activeScreenshotComponent == this) {
            activeScreenshotComponent = null;
        }
        Map<DebuggerEngine, Set<ScreenshotComponent>> map = openedScreenshots;
        synchronized (map) {
            Set<ScreenshotComponent> components = openedScreenshots.get(this.screenshot.getDebuggerEngine());
            if (components != null) {
                components.remove((Object)this);
                if (components.isEmpty()) {
                    openedScreenshots.remove(this.screenshot.getDebuggerEngine());
                }
            }
        }
        this.canvas.deactivated();
    }

    public int getPersistenceType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeScreenshots(DebuggerEngine engine) {
        Map<DebuggerEngine, Set<ScreenshotComponent>> map = openedScreenshots;
        synchronized (map) {
            Set<ScreenshotComponent> components = openedScreenshots.get(engine);
            if (components != null) {
                final HashSet<ScreenshotComponent> theComponents = new HashSet<ScreenshotComponent>(components);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (ScreenshotComponent c : theComponents) {
                            c.close();
                        }
                    }
                });
            }
        }
    }

    public void markBreakpoint(ComponentInfo ci) {
        this.canvas.markBreakpoint(ci);
    }

    public void unmarkBreakpoint(ComponentInfo ci) {
        this.canvas.unmarkBreakpoint(ci);
    }

    private class ScreenshotCanvas
    extends JComponent {
        private Image image;
        private Rectangle selection;
        private final Set<Rectangle> breakpoints = new HashSet<Rectangle>();
        private Listener listener;
        private boolean active;

        public ScreenshotCanvas(Image image) {
            this.image = image;
            this.listener = new Listener();
            this.initSize();
        }

        private void initSize() {
            ImageObserver io = new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    boolean hasWidth;
                    boolean hasHeight = (infoflags & 2) > 0;
                    boolean bl = hasWidth = (infoflags & 1) > 0;
                    if (!hasHeight || !hasWidth) {
                        return true;
                    }
                    ScreenshotCanvas.this.setSize(width, height);
                    ScreenshotCanvas.this.setPreferredSize(ScreenshotCanvas.this.getSize());
                    return false;
                }
            };
            int width = this.image.getWidth(io);
            int height = this.image.getHeight(io);
            if (width > 0 && height > 0) {
                this.setSize(width, height);
                this.setPreferredSize(this.getSize());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.image, 1, 1, null);
            g.drawRect(0, 0, this.image.getWidth(null) + 2, this.image.getHeight(null) + 2);
            Set<Rectangle> set = this.breakpoints;
            synchronized (set) {
                Color c = g.getColor();
                g.setColor(Color.RED);
                for (Rectangle r : this.breakpoints) {
                    g.drawRect(r.x, r.y, r.width + 1, r.height + 1);
                }
                g.setColor(c);
            }
            if (this.selection != null) {
                Color c = g.getColor();
                g.setColor(Color.BLUE);
                g.drawRect(this.selection.x, this.selection.y, this.selection.width + 1, this.selection.height + 1);
                g.setColor(c);
            }
        }

        void activated() {
            if (this.selection != null) {
                this.listener.selectComponentAt(this.selection.x + 1, this.selection.y + 1, true);
            }
            if (!this.active) {
                this.addMouseListener(this.listener);
                ComponentHierarchy.getInstance().getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this.listener);
            }
            this.active = true;
        }

        void deactivated() {
            if (!this.active) {
                return;
            }
            this.active = false;
            this.removeMouseListener(this.listener);
            ComponentHierarchy.getInstance().getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this.listener);
        }

        private Rectangle getBreakpointRectangle(ComponentInfo ci) {
            Rectangle r = ci.getWindowBounds();
            return new Rectangle(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markBreakpoint(ComponentInfo ci) {
            Rectangle r;
            Set<Rectangle> set = this.breakpoints;
            synchronized (set) {
                r = this.getBreakpointRectangle(ci);
                this.breakpoints.add(r);
            }
            this.repaint(r.x, r.y, r.width + 3, r.height + 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unmarkBreakpoint(ComponentInfo ci) {
            Rectangle r;
            Set<Rectangle> set = this.breakpoints;
            synchronized (set) {
                r = this.getBreakpointRectangle(ci);
                this.breakpoints.remove(r);
            }
            this.repaint(r.x, r.y, r.width + 3, r.height + 3);
        }

        private class Listener
        implements MouseListener,
        PropertyChangeListener {
            private Listener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.selectComponentAt(e.getX(), e.getY(), false);
                    this.showPopupMenu(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.selectComponentAt(e.getX(), e.getY(), false);
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            private void showPopupMenu(int x, int y) {
                Node[] activatedNodes = ScreenshotComponent.this.getActivatedNodes();
                if (activatedNodes.length == 1) {
                    Action[] actions = activatedNodes[0].getActions(true);
                    JPopupMenu contextMenu = Utilities.actionsToPopup((Action[])actions, (Component)((Object)ScreenshotComponent.this));
                    contextMenu.show(ScreenshotComponent.this.canvas, x, y);
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                logger.fine("propertyChange(" + evt + ") propertyName = " + evt.getPropertyName());
                String propertyName = evt.getPropertyName();
                if ("selectedNodes".equals(propertyName)) {
                    Object[] nodes = ComponentHierarchy.getInstance().getExplorerManager().getSelectedNodes();
                    ComponentInfo ci = null;
                    if (nodes.length > 0) {
                        ci = (ComponentInfo)nodes[0].getLookup().lookup(ComponentInfo.class);
                    }
                    logger.fine("nodes = " + Arrays.toString(nodes) + " => selectComponent(" + ci + ")");
                    this.selectComponent(ci, false);
                } else if ("rootContext".equals(propertyName)) {
                    ScreenshotCanvas.this.deactivated();
                }
            }

            private void selectComponentAt(int x, int y, boolean reActivated) {
                ComponentInfo ci = ScreenshotComponent.this.screenshot.findAt(--x, --y);
                logger.fine("Component Info at " + x + ", " + y + " is: " + (ci != null ? ci.getDisplayName() : null));
                this.selectComponent(ci, reActivated);
            }

            private void selectComponent(ComponentInfo ci, boolean reActivated) {
                ComponentNode node = null;
                if (ci != null) {
                    Rectangle oldSelection = null;
                    if (ScreenshotCanvas.this.selection != null) {
                        oldSelection = ScreenshotCanvas.this.selection;
                    }
                    ScreenshotCanvas.this.selection = ci.getWindowBounds();
                    if (oldSelection != null) {
                        if (oldSelection.equals(ScreenshotCanvas.this.selection) && !reActivated) {
                            return;
                        }
                        ScreenshotCanvas.this.repaint(oldSelection.x, oldSelection.y, oldSelection.width + 3, oldSelection.height + 3);
                    }
                    ScreenshotCanvas.this.repaint(((ScreenshotCanvas)ScreenshotCanvas.this).selection.x, ((ScreenshotCanvas)ScreenshotCanvas.this).selection.y, ((ScreenshotCanvas)ScreenshotCanvas.this).selection.width + 3, ((ScreenshotCanvas)ScreenshotCanvas.this).selection.height + 3);
                    logger.fine("New selection = " + ScreenshotCanvas.this.selection);
                    node = ScreenshotComponent.this.componentNodes.findNodeFor(ci);
                    logger.fine("FindNodeFor(" + ci + ") on '" + (Object)((Object)ScreenshotComponent.this.componentNodes) + "' gives: " + (Object)((Object)node));
                }
                Object[] nodes = node != null ? new Node[]{node} : new Node[]{};
                logger.fine("setActivated/SelectedNodes(" + Arrays.toString(nodes) + ")");
                ScreenshotComponent.this.setActivatedNodes((Node[])nodes);
                try {
                    ComponentHierarchy.getInstance().getExplorerManager().setSelectedNodes((Node[])nodes);
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }
}

