/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.WorkingCopyInfo;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgSearchHistorySupport;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class MercurialInterceptor
extends VCSInterceptor {
    private final FileStatusCache cache;
    private ConcurrentLinkedQueue<File> filesToRefresh = new ConcurrentLinkedQueue();
    private final Map<File, Set<File>> lockedRepositories = new HashMap<File, Set<File>>(5);
    private final RequestProcessor.Task refreshTask;
    private final RequestProcessor.Task lockedRepositoryRefreshTask;
    private static final RequestProcessor rp = new RequestProcessor("MercurialRefresh", 1, true);
    private final HgFolderEventsHandler hgFolderEventsHandler;
    private static final boolean AUTOMATIC_REFRESH_ENABLED = !"true".equals(System.getProperty("versioning.mercurial.autoRefreshDisabled", "false"));
    private final Mercurial hg;

    MercurialInterceptor(Mercurial hg, FileStatusCache cache) {
        this.cache = cache;
        this.hg = hg;
        this.refreshTask = rp.create((Runnable)new RefreshTask());
        this.lockedRepositoryRefreshTask = rp.create((Runnable)new LockedRepositoryRefreshTask());
        this.hgFolderEventsHandler = new HgFolderEventsHandler();
    }

    public boolean beforeDelete(File file) {
        Mercurial.LOG.log(Level.FINE, "beforeDelete {0}", file);
        if (file == null) {
            return false;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        return !HgUtils.isIgnored(file, false);
    }

    public void doDelete(File file) throws IOException {
        Mercurial.LOG.log(Level.FINE, "doDelete {0}", file);
        if (file == null) {
            return;
        }
        File root = this.hg.getRepositoryRoot(file);
        try {
            file.delete();
            HgCommand.doRemove(root, file, null);
        }
        catch (HgException ex) {
            Mercurial.LOG.log(Level.FINE, "doDelete(): File: {0} {1}", new Object[]{file.getAbsolutePath(), ex.toString()});
        }
    }

    public void afterDelete(File file) {
        Mercurial.LOG.log(Level.FINE, "afterDelete {0}", file);
        if (file == null) {
            return;
        }
        if (HgUtils.isIgnored(file, false)) {
            if (Mercurial.LOG.isLoggable(Level.FINER)) {
                Mercurial.LOG.log(Level.FINE, "skipping afterDelete(): File: {0} is ignored", new Object[]{file.getAbsolutePath()});
            }
            return;
        }
        this.reScheduleRefresh(800, file);
    }

    public boolean beforeMove(File from, File to) {
        Mercurial.LOG.log(Level.FINE, "beforeMove {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return true;
        }
        if (this.hg.isManaged(from)) {
            return this.hg.isManaged(to);
        }
        return super.beforeMove(from, to);
    }

    public void doMove(File from, File to) throws IOException {
        Mercurial.LOG.log(Level.FINE, "doMove {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Mercurial.LOG.log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
        }
        this.hgMoveImplementation(from, to);
    }

    public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
        long retval = -1L;
        if (".hg".equals(dir.getName())) {
            Mercurial.STATUS_LOG.log(Level.FINER, "Interceptor.refreshRecursively: {0}", dir.getAbsolutePath());
            children.clear();
            retval = this.hgFolderEventsHandler.handleHgFolderEvent(dir);
        }
        return retval;
    }

    public boolean isMutable(File file) {
        return HgUtils.isPartOfMercurialMetadata(file) || super.isMutable(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hgMoveImplementation(File srcFile, File dstFile) throws IOException {
        File root = this.hg.getRepositoryRoot(srcFile);
        File dstRoot = this.hg.getRepositoryRoot(dstFile);
        Mercurial.LOG.log(Level.FINE, "hgMoveImplementation(): File: {0} {1}", new Object[]{srcFile, dstFile});
        boolean result = srcFile.renameTo(dstFile);
        if (!result) {
            Mercurial.LOG.log(Level.INFO, "Cannot rename file {0} to {1}", new Object[]{srcFile, dstFile});
        }
        if (root == null) {
            return;
        }
        OutputLogger logger = OutputLogger.getLogger(root.getAbsolutePath());
        try {
            if (root.equals(dstRoot) && !HgUtils.isIgnored(dstFile, false)) {
                HgCommand.doRenameAfter(root, srcFile, dstFile, logger);
            } else {
                HgCommand.doRemove(root, srcFile, logger);
            }
        }
        catch (HgException e) {
            Mercurial.LOG.log(Level.FINE, "Mercurial failed to rename: File: {0} {1}", new Object[]{srcFile.getAbsolutePath(), dstFile.getAbsolutePath()});
        }
        finally {
            logger.closeLog();
        }
    }

    public void afterMove(File from, File to) {
        Mercurial.LOG.log(Level.FINE, "afterMove {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || !to.exists()) {
            return;
        }
        File parent = from.getParentFile();
        if (parent != null && !HgUtils.isIgnored(parent, false)) {
            this.reScheduleRefresh(800, from);
        }
        if ((parent = to.getParentFile()) != null && !HgUtils.isIgnored(parent, false)) {
            this.reScheduleRefresh(800, to);
        }
    }

    public boolean beforeCopy(File from, File to) {
        Mercurial.LOG.log(Level.FINE, "beforeCopy {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return true;
        }
        return this.hg.isManaged(from) && this.hg.isManaged(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopy(File from, File to) throws IOException {
        Mercurial.LOG.log(Level.FINE, "doCopy {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return;
        }
        File root = this.hg.getRepositoryRoot(from);
        File dstRoot = this.hg.getRepositoryRoot(to);
        if (from.isDirectory()) {
            FileUtils.copyDirFiles((File)from, (File)to);
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
        if (root == null || HgUtils.isIgnored(to, false)) {
            return;
        }
        OutputLogger logger = OutputLogger.getLogger(root.getAbsolutePath());
        try {
            if (root.equals(dstRoot)) {
                HgCommand.doCopy(root, from, to, true, logger);
            }
        }
        catch (HgException e) {
            Mercurial.LOG.log(Level.FINE, "Mercurial failed to copy: File: {0} {1}", new Object[]{from.getAbsolutePath(), to.getAbsolutePath()});
        }
        finally {
            logger.closeLog();
        }
    }

    public void afterCopy(File from, File to) {
        Mercurial.LOG.log(Level.FINE, "afterCopy {0}->{1}", new Object[]{from, to});
        if (to == null) {
            return;
        }
        File parent = to.getParentFile();
        if (parent != null && !HgUtils.isIgnored(parent, false)) {
            this.reScheduleRefresh(800, to);
        }
    }

    public boolean beforeCreate(File file, boolean isDirectory) {
        Mercurial.LOG.log(Level.FINE, "beforeCreate {0} {1}", new Object[]{file, isDirectory});
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        if (!isDirectory && !file.exists()) {
            File root = this.hg.getRepositoryRoot(file);
            FileInformation info = null;
            try {
                Map<File, FileInformation> statusMap = HgCommand.getStatus(root, Arrays.asList(file));
                info = statusMap != null ? statusMap.get(file) : null;
            }
            catch (HgException ex) {
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): getStatus failed for file: {0} {1}", new Object[]{file.getAbsolutePath(), ex.toString()});
            }
            if (info != null && info.getStatus() == 256) {
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): LocallyDeleted: {0}", file);
                if (root == null) {
                    return false;
                }
                OutputLogger logger = this.hg.getLogger(root.getAbsolutePath());
                try {
                    ArrayList<File> revertFiles = new ArrayList<File>();
                    revertFiles.add(file);
                    HgCommand.doRevert(root, revertFiles, null, false, logger);
                }
                catch (HgException ex) {
                    Mercurial.LOG.log(Level.FINE, "beforeCreate(): File: {0} {1}", new Object[]{file.getAbsolutePath(), ex.toString()});
                }
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): afterWaitFinished: {0}", file);
                logger.closeLog();
                file.delete();
            }
        }
        return false;
    }

    public void doCreate(File file, boolean isDirectory) throws IOException {
        Mercurial.LOG.log(Level.FINE, "doCreate {0} {1}", new Object[]{file, isDirectory});
        super.doCreate(file, isDirectory);
    }

    public void afterCreate(File file) {
        Mercurial.LOG.log(Level.FINE, "afterCreate {0}", file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(800, file);
        }
    }

    public void afterChange(File file) {
        if (file.isDirectory()) {
            return;
        }
        Mercurial.LOG.log(Level.FINE, "afterChange(): {0}", file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(800, file);
        }
    }

    public Object getAttribute(final File file, String attrName) {
        if ("ProvidedExtensions.RemoteLocation".equals(attrName)) {
            return this.getRemoteRepository(file);
        }
        if ("ProvidedExtensions.Refresh".equals(attrName)) {
            return new Runnable(){

                @Override
                public void run() {
                    FileStatusCache cache = MercurialInterceptor.this.hg.getFileStatusCache();
                    cache.refresh(file);
                }
            };
        }
        if ("ProvidedExtensions.SearchHistorySupport".equals(attrName)) {
            return new HgSearchHistorySupport(file);
        }
        return super.getAttribute(file, attrName);
    }

    private String getRemoteRepository(File file) {
        return HgUtils.getRemoteRepository(file);
    }

    private void reScheduleRefresh(int delayMillis, File fileToRefresh) {
        Mercurial.STATUS_LOG.log(Level.FINE, "reScheduleRefresh: adding {0}", fileToRefresh.getAbsolutePath());
        if (!HgUtils.isPartOfMercurialMetadata(fileToRefresh)) {
            this.filesToRefresh.add(fileToRefresh);
        }
        this.refreshTask.schedule(delayMillis);
    }

    private void reScheduleRefresh(int delayMillis, Set<File> filesToRefresh) {
        Mercurial.STATUS_LOG.log(Level.FINE, "reScheduleRefresh: adding {0}", filesToRefresh);
        this.filesToRefresh.addAll(filesToRefresh);
        this.refreshTask.schedule(delayMillis);
    }

    void pingRepositoryRootFor(File file) {
        if (!AUTOMATIC_REFRESH_ENABLED) {
            return;
        }
        this.hgFolderEventsHandler.initializeFor(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T runWithoutExternalEvents(File repository, Callable<T> callable) throws Exception {
        assert (repository != null);
        try {
            if (repository != null) {
                this.hgFolderEventsHandler.enableEvents(repository, false);
            }
            T t = callable.call();
            return t;
        }
        finally {
            if (repository != null) {
                this.hgFolderEventsHandler.refreshRepositoryTimestamps(repository);
                this.hgFolderEventsHandler.enableEvents(repository, true);
            }
        }
    }

    Set<File> getSeenRoots(File repositoryRoot) {
        return this.hgFolderEventsHandler.getSeenRoots(repositoryRoot);
    }

    private Collection<File> checkLockedRepositories(Collection<File> additionalFilesToRefresh, boolean keepCached) {
        LinkedList<File> retval = new LinkedList<File>();
        Map<File, Set<File>> sortedFiles = this.sortByRepository(additionalFilesToRefresh);
        for (Map.Entry<File, Set<File>> e : sortedFiles.entrySet()) {
            Set<File> alreadyPlanned = this.lockedRepositories.get(e.getKey());
            if (alreadyPlanned == null) {
                alreadyPlanned = new HashSet<File>();
                this.lockedRepositories.put(e.getKey(), alreadyPlanned);
            }
            alreadyPlanned.addAll((Collection<File>)e.getValue());
        }
        Iterator<Map.Entry<File, Set<File>>> it = this.lockedRepositories.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<File, Set<File>> entry = it.next();
            File repository = entry.getKey();
            if (!repository.exists()) {
                it.remove();
                continue;
            }
            if (HgUtils.isRepositoryLocked(repository)) {
                Mercurial.STATUS_LOG.log(Level.FINE, "checkLockedRepositories(): Repository {0} locked, status refresh delayed", repository);
                continue;
            }
            retval.addAll((Collection<File>)entry.getValue());
            if (keepCached) continue;
            it.remove();
        }
        return retval;
    }

    private Map<File, Set<File>> sortByRepository(Collection<File> files) {
        HashMap<File, Set<File>> sorted = new HashMap<File, Set<File>>(5);
        for (File f : files) {
            File repository = this.hg.getRepositoryRoot(f);
            if (repository == null) continue;
            HashSet<File> repoFiles = (HashSet<File>)sorted.get(repository);
            if (repoFiles == null) {
                repoFiles = new HashSet<File>();
                sorted.put(repository, repoFiles);
            }
            repoFiles.add(f);
        }
        return sorted;
    }

    private class HgFolderEventsHandler {
        private final HashMap<File, HgFolderTimestamps> hgFolders = new HashMap(5);
        private final HashMap<File, FileChangeListener> hgFolderRLs = new HashMap(5);
        private final HashMap<File, Set<File>> seenRoots = new HashMap(5);
        private final HashSet<File> disabledEvents = new HashSet(5);
        private final HashSet<File> filesToInitialize = new HashSet();
        private RequestProcessor rp = new RequestProcessor("MercurialInterceptorEventsHandlerRP", 1);
        private RequestProcessor.Task initializingTask = this.rp.create(new Runnable(){

            @Override
            public void run() {
                HgFolderEventsHandler.this.initializeFiles();
            }
        });
        private RequestProcessor.Task refreshOpenFilesTask = this.rp.create(new Runnable(){

            @Override
            public void run() {
                Set openFiles = Utils.getOpenFiles();
                for (File file : openFiles) {
                    MercurialInterceptor.this.hg.notifyFileChanged(file);
                }
            }
        });

        private HgFolderEventsHandler() {
        }

        private HgFolderTimestamps scanHgFolderTimestamps(File hgFolder) {
            return new HgFolderTimestamps(hgFolder);
        }

        public void refreshRepositoryTimestamps(File repository) {
            this.refreshHgFolderTimestamp(this.scanHgFolderTimestamps(HgUtils.getHgFolderForRoot(repository)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshHgFolderTimestamp(HgFolderTimestamps newTimestamps) {
            final File hgFolder = newTimestamps.getHgFolder();
            boolean exists = newTimestamps.repositoryExists();
            HashMap<File, HgFolderTimestamps> hashMap = this.hgFolders;
            synchronized (hashMap) {
                if (exists && !newTimestamps.isNewer(this.hgFolders.get(hgFolder))) {
                    return;
                }
            }
            hashMap = this.hgFolders;
            synchronized (hashMap) {
                this.hgFolders.remove(hgFolder);
                FileChangeListener list = this.hgFolderRLs.remove(hgFolder);
                if (exists) {
                    this.hgFolders.put(hgFolder, newTimestamps);
                    if (list == null) {
                        list = new FileChangeAdapter();
                        FileChangeAdapter fList = list;
                        this.rp.post(new Runnable((FileChangeListener)fList, hgFolder){
                            final /* synthetic */ FileChangeListener val$fList;
                            final /* synthetic */ File val$hgFolder;
                            {
                                this.val$fList = fileChangeListener;
                                this.val$hgFolder = file;
                            }

                            @Override
                            public void run() {
                                FileUtil.addRecursiveListener((FileChangeListener)this.val$fList, (File)this.val$hgFolder);
                            }
                        });
                    }
                    this.hgFolderRLs.put(hgFolder, list);
                } else {
                    if (list != null) {
                        final FileChangeListener fList = list;
                        this.rp.post(new Runnable(){

                            @Override
                            public void run() {
                                FileUtil.removeRecursiveListener((FileChangeListener)fList, (File)hgFolder);
                            }
                        });
                    }
                    Mercurial.STATUS_LOG.log(Level.FINE, "refreshHgFolderTimestamp: {0} no longer exists", hgFolder.getAbsolutePath());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long handleHgFolderEvent(File hgFolder) {
            long lastModified = 0L;
            if (AUTOMATIC_REFRESH_ENABLED && !"false".equals(System.getProperty("mercurial.handleDirstateEvents", "true"))) {
                hgFolder = FileUtil.normalizeFile((File)hgFolder);
                Mercurial.STATUS_LOG.log(Level.FINER, "handleHgFolderEvent: special FS event handling for {0}", hgFolder.getAbsolutePath());
                boolean refreshNeeded = false;
                if (this.isEnabled(hgFolder)) {
                    HgFolderTimestamps cached;
                    HashMap<File, HgFolderTimestamps> hashMap = this.hgFolders;
                    synchronized (hashMap) {
                        cached = this.hgFolders.get(hgFolder);
                    }
                    if (cached == null || !cached.repositoryExists() || cached.isOutdated()) {
                        this.refreshHgFolderTimestamp(this.scanHgFolderTimestamps(hgFolder));
                        refreshNeeded = true;
                    }
                    if (refreshNeeded) {
                        File repository = hgFolder.getParentFile();
                        Mercurial.STATUS_LOG.log(Level.FINE, "handleDirstateEvent: planning repository scan for {0}", repository.getAbsolutePath());
                        MercurialInterceptor.this.reScheduleRefresh(3000, this.getSeenRoots(repository));
                        this.refreshOpenFilesTask.schedule(3000);
                        WorkingCopyInfo.refreshAsync(repository);
                    }
                }
            }
            return lastModified;
        }

        public void initializeFor(File file) {
            if (this.addFileToInitialize(file)) {
                this.initializingTask.schedule(500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<File> getSeenRoots(File repositoryRoot) {
            Set<File> seenRootsForRepository;
            HashSet<File> retval = new HashSet<File>();
            Set<File> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                retval.addAll(seenRootsForRepository);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File addSeenRoot(File repositoryRoot, File rootToAdd) {
            Set<File> seenRootsForRepository;
            File addedRoot = null;
            Set<File> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                if (!seenRootsForRepository.contains(repositoryRoot)) {
                    rootToAdd = FileUtil.normalizeFile((File)rootToAdd);
                    addedRoot = HgUtils.prepareRootFiles(repositoryRoot, seenRootsForRepository, rootToAdd);
                }
            }
            return addedRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<File> getSeenRootsForRepository(File repositoryRoot) {
            HashMap<File, Set<File>> hashMap = this.seenRoots;
            synchronized (hashMap) {
                Set<File> seenRootsForRepository = this.seenRoots.get(repositoryRoot);
                if (seenRootsForRepository == null) {
                    seenRootsForRepository = new HashSet<File>();
                    this.seenRoots.put(repositoryRoot, seenRootsForRepository);
                }
                return seenRootsForRepository;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addFileToInitialize(File file) {
            HashSet<File> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                return this.filesToInitialize.add(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File getFileToInitialize() {
            File nextFile = null;
            HashSet<File> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                Iterator<File> iterator = this.filesToInitialize.iterator();
                if (iterator.hasNext()) {
                    nextFile = iterator.next();
                    iterator.remove();
                }
            }
            return nextFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeFiles() {
            File file = null;
            while ((file = this.getFileToInitialize()) != null) {
                File newlyAddedRoot;
                File repositoryRoot = MercurialInterceptor.this.hg.getRepositoryRoot(file);
                if (repositoryRoot == null || (newlyAddedRoot = this.addSeenRoot(repositoryRoot, file)) == null) continue;
                Mercurial.STATUS_LOG.log(Level.FINE, "pingRepositoryRootFor: planning a scan for {0} - {1}", new Object[]{repositoryRoot.getAbsolutePath(), file.getAbsolutePath()});
                MercurialInterceptor.this.reScheduleRefresh(4000, newlyAddedRoot);
                File hgFolder = FileUtil.normalizeFile((File)HgUtils.getHgFolderForRoot(repositoryRoot));
                boolean refreshNeeded = false;
                HashMap<File, HgFolderTimestamps> hashMap = this.hgFolders;
                synchronized (hashMap) {
                    if (!this.hgFolders.containsKey(hgFolder) && hgFolder.isDirectory()) {
                        this.hgFolders.put(hgFolder, null);
                        refreshNeeded = true;
                    }
                }
                if (!refreshNeeded) continue;
                this.refreshHgFolderTimestamp(this.scanHgFolderTimestamps(hgFolder));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enableEvents(File repository, boolean enabled) {
            File hgFolder = FileUtil.normalizeFile((File)HgUtils.getHgFolderForRoot(repository));
            HashSet<File> hashSet = this.disabledEvents;
            synchronized (hashSet) {
                if (enabled) {
                    this.disabledEvents.remove(hgFolder);
                } else {
                    this.disabledEvents.add(hgFolder);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isEnabled(File hgFolder) {
            HashSet<File> hashSet = this.disabledEvents;
            synchronized (hashSet) {
                return !this.disabledEvents.contains(hgFolder);
            }
        }
    }

    private static class HgFolderTimestamps {
        private final File hgFolder;
        private final Map<String, Long> interestingTimestamps;
        private final long dirstateSize;
        private final File dirstateFile;
        private static final String DIRSTATE = "dirstate";
        private static final String[] INTERESTING_FILENAMES = new String[]{"branch", "branchheads.cache", "localtags", "tags.cache", "undo.branch", "undo.dirstate"};

        public HgFolderTimestamps(File hgFolder) {
            this.hgFolder = hgFolder;
            HashMap<String, Long> ts = new HashMap<String, Long>(INTERESTING_FILENAMES.length);
            for (String fn : INTERESTING_FILENAMES) {
                ts.put(fn, new File(hgFolder, fn).lastModified());
            }
            this.dirstateFile = new File(hgFolder, DIRSTATE);
            this.dirstateSize = this.dirstateFile.length();
            this.interestingTimestamps = Collections.unmodifiableMap(ts);
        }

        private boolean isNewer(HgFolderTimestamps other) {
            boolean newer = true;
            if (other != null) {
                newer = this.dirstateSize != other.dirstateSize;
                for (Map.Entry<String, Long> e : this.interestingTimestamps.entrySet()) {
                    if (e.getValue() <= other.interestingTimestamps.get(e.getKey()) && (e.getValue() != -1L || other.interestingTimestamps.get(e.getKey()) == e.getValue())) continue;
                    newer = true;
                    break;
                }
            }
            return newer;
        }

        private File getHgFolder() {
            return this.hgFolder;
        }

        private boolean repositoryExists() {
            return this.dirstateSize > 0L || this.hgFolder.exists();
        }

        private boolean isOutdated() {
            boolean upToDate;
            boolean bl = upToDate = this.dirstateSize == this.dirstateFile.length();
            if (upToDate) {
                for (Map.Entry<String, Long> e : this.interestingTimestamps.entrySet()) {
                    File f = new File(this.hgFolder, e.getKey());
                    long ts = f.lastModified();
                    if (e.getValue() >= ts && (e.getValue() <= ts || ts != -1L)) continue;
                    upToDate = false;
                    break;
                }
            }
            return !upToDate;
        }
    }

    private class LockedRepositoryRefreshTask
    implements Runnable {
        private LockedRepositoryRefreshTask() {
        }

        @Override
        public void run() {
            if (!MercurialInterceptor.this.checkLockedRepositories(Collections.emptySet(), true).isEmpty()) {
                MercurialInterceptor.this.refreshTask.schedule(0);
            } else if (!MercurialInterceptor.this.lockedRepositories.isEmpty()) {
                MercurialInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            File file;
            Thread.interrupted();
            if (DelayScanRegistry.getInstance().isDelayed(MercurialInterceptor.this.refreshTask, Mercurial.STATUS_LOG, "MercurialInterceptor.refreshTask")) {
                return;
            }
            HashSet<File> files = new HashSet<File>(MercurialInterceptor.this.filesToRefresh.size());
            while ((file = (File)MercurialInterceptor.this.filesToRefresh.poll()) != null) {
                files.add(file);
            }
            if (!"false".equals(System.getProperty("versioning.mercurial.delayStatusForLockedRepositories"))) {
                files = MercurialInterceptor.this.checkLockedRepositories(files, false);
            }
            if (!files.isEmpty()) {
                MercurialInterceptor.this.cache.refreshAllRoots(files);
            }
            if (!MercurialInterceptor.this.lockedRepositories.isEmpty()) {
                MercurialInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }
}

