/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.ExportDiff;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPickerPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ExportDiffAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set roots = context.getFiles();
        if (roots == null) {
            return false;
        }
        if (!HgUtils.isFromHgRepository(context)) {
            return false;
        }
        for (File root : roots) {
            FileInformation info = Mercurial.getInstance().getFileStatusCache().getCachedStatus(root);
            if (info == null || info.getStatus() != 4 && info.getStatus() != 4096) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ExportDiff";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        ExportDiffAction.exportDiff(context);
    }

    private static void exportDiff(VCSContext ctx) {
        File[] files = HgUtils.getActionRoots(ctx);
        if (files == null || files.length == 0) {
            return;
        }
        final File repository = Mercurial.getInstance().getRepositoryRoot(files[0]);
        ExportDiff exportDiffSupport = new ExportDiff(repository, files){

            public void writeDiffFile(final File toFile) {
                final String revStr = this.getSelectionRevision();
                ExportDiffAction.saveFolderToPrefs(toFile);
                RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
                HgProgressSupport support = new HgProgressSupport(){

                    @Override
                    public void perform() {
                        OutputLogger logger = this.getLogger();
                        ExportDiffAction.performExport(repository, revStr, toFile.getAbsolutePath(), logger);
                    }
                };
                support.start(rp, repository, NbBundle.getMessage(ExportDiffAction.class, (String)"LBL_ExportDiff_Progress")).waitFinished();
            }
        };
        exportDiffSupport.export();
    }

    public static void exportDiffFileRevision(RepositoryRevision.Event drev) {
        if (drev == null) {
            return;
        }
        final File fileToDiff = drev.getFile();
        RepositoryRevision repoRev = drev.getLogInfoHeader();
        final File root = repoRev.getRepositoryRoot();
        if (root == null || root.getPath().equals("")) {
            return;
        }
        final String revStr = repoRev.getLog().getRevisionNumber();
        ExportDiff exportDiffSupport = new ExportDiff(root, repoRev.getLog(), null, fileToDiff){

            public void writeDiffFile(final File toFile) {
                ExportDiffAction.saveFolderToPrefs(toFile);
                RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                HgProgressSupport support = new HgProgressSupport(){

                    @Override
                    public void perform() {
                        OutputLogger logger = this.getLogger();
                        ExportDiffAction.performExportFile(root, revStr, fileToDiff, toFile.getAbsolutePath(), logger);
                    }
                };
                support.start(rp, root, NbBundle.getMessage(ExportDiffAction.class, (String)"LBL_ExportDiff_Progress")).waitFinished();
            }
        };
        exportDiffSupport.export();
    }

    public static void exportDiffRevision(final RepositoryRevision repoRev, File[] roots) {
        if (repoRev == null) {
            return;
        }
        final File root = repoRev.getRepositoryRoot();
        if (root == null || root.getPath().equals("")) {
            return;
        }
        ExportDiff exportDiffSupport = new ExportDiff(root, repoRev.getLog(), roots){

            public void writeDiffFile(final File toFile) {
                final String revStr = repoRev.getLog().getRevisionNumber();
                ExportDiffAction.saveFolderToPrefs(toFile);
                RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                HgProgressSupport support = new HgProgressSupport(){

                    @Override
                    public void perform() {
                        OutputLogger logger = this.getLogger();
                        ExportDiffAction.performExport(root, revStr, toFile.getAbsolutePath(), logger);
                    }
                };
                support.start(rp, root, NbBundle.getMessage(ExportDiffAction.class, (String)"LBL_ExportDiff_Progress")).waitFinished();
            }
        };
        exportDiffSupport.export();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performExport(File repository, String revStr, String outputFileName, OutputLogger logger) {
        try {
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_TITLE"));
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_TITLE_SEP"));
            if (revStr != null && NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Revision_Default").startsWith(revStr)) {
                logger.output(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_NOTHING"));
            } else {
                File outFile;
                List<String> list = HgCommand.doExport(repository, revStr, outputFileName, logger);
                logger.output(list);
                if (!list.isEmpty() && list.size() > 1 && (outFile = new File(list.get(1))) != null && outFile.canRead()) {
                    ExportDiffAction.openFile(outFile);
                }
            }
        }
        catch (HgException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        finally {
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_DONE"));
            logger.output("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performExportFile(File repository, String revStr, File fileToDiff, String outputFileName, OutputLogger logger) {
        try {
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_TITLE"));
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_TITLE_SEP"));
            if (NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Revision_Default").startsWith(revStr)) {
                logger.output(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_NOTHING"));
            } else {
                File outFile;
                List<String> list = HgCommand.doExportFileDiff(repository, fileToDiff, revStr, outputFileName, logger);
                String repoPath = repository.getAbsolutePath();
                String fileToDiffPath = fileToDiff.getAbsolutePath();
                fileToDiffPath = fileToDiffPath.substring(repoPath.length() + 1);
                logger.output(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE", (Object)fileToDiffPath, (Object)revStr, (Object)outputFileName));
                if (!list.isEmpty() && list.size() > 1 && (outFile = new File(outputFileName)) != null && outFile.canRead()) {
                    ExportDiffAction.openFile(outFile);
                }
            }
        }
        catch (HgException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        finally {
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_DONE"));
            logger.output("");
        }
    }

    static void saveFolderToPrefs(File file) {
        if (file.getParent() != null) {
            HgModuleConfig.getDefault().getPreferences().put("ExportDiff.saveFolder", file.getParent());
        }
    }

    private static void openFile(File outFile) {
        outFile = FileUtil.normalizeFile((File)outFile);
        if (HgCommand.ENCODING != null) {
            Utils.associateEncoding((File)outFile, (Charset)Charset.forName(HgCommand.ENCODING));
        }
        Utils.openFile((File)outFile);
    }
}

