/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.kenai.HgKenaiAccessor;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.ui.rollback.BackoutAction;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener,
DiffSetupSource {
    private static final String SUMMARY_DIFF_PROPERTY = "Summary-Diff-";
    private static final String SUMMARY_REVERT_PROPERTY = "Summary-Revert-";
    private static final String HLINK_ISSUE_PROPERTY = "Hyperlink-Issue-";
    private static final String SUMMARY_EXPORTDIFFS_PROPERTY = "Summary-ExportDiffs-";
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;
    private List<RepositoryRevision> results;
    private Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap = null;
    private VCSHyperlinkSupport linkerSupport = new VCSHyperlinkSupport();

    public SummaryView(SearchHistoryPanel master, List<RepositoryRevision> results) {
        this.master = master;
        this.results = results;
        this.dispResults = this.expandResults(results);
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fcs.getFontColors("highlight-search");
        this.message = master.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        master.addComponentListener(this);
        this.resultsList.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.resultsList.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryView.this.onPopup(Utils.getPositionForPopup((JList)SummaryView.this.resultsList));
            }
        });
        if (results.size() > 0) {
            boolean isKenaiRepository;
            String url = HgUtils.getRemoteRepository(results.get(0).getRepositoryRoot());
            boolean bl = isKenaiRepository = url != null && HgKenaiAccessor.getInstance().isKenai(url);
            if (isKenaiRepository) {
                this.kenaiUsersMap = new HashMap<String, VCSKenaiAccessor.KenaiUser>();
                for (RepositoryRevision repositoryRevision : results) {
                    VCSKenaiAccessor.KenaiUser kenaiUser;
                    String author = repositoryRevision.getLog().getAuthor();
                    String username = repositoryRevision.getLog().getUsername();
                    if (author == null || author.equals("") || username == null || "".equals(username) || this.kenaiUsersMap.keySet().contains(author) || (kenaiUser = HgKenaiAccessor.getInstance().forName(username, url)) == null) continue;
                    this.kenaiUsersMap.put(author, kenaiUser);
                }
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int[] selection = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(selection);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private List expandResults(List<RepositoryRevision> results) {
        ArrayList<Object> newResults = new ArrayList<Object>(results.size());
        for (RepositoryRevision repositoryRevision : results) {
            newResults.add(repositoryRevision);
            List<RepositoryRevision.Event> events = repositoryRevision.getEvents();
            for (RepositoryRevision.Event event : events) {
                newResults.add(event);
            }
        }
        return newResults;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_DIFF_PROPERTY + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.diffPrevious(idx);
        }
        if ((diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + idx)) != null && diffBounds.contains(p)) {
            this.revertModifications(new int[]{idx});
        }
        if ((diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_EXPORTDIFFS_PROPERTY + idx)) != null && diffBounds.contains(p)) {
            this.exportDiffs(idx);
        }
        this.linkerSupport.mouseClicked(p, idx);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.master.isIncomingSearch() && e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.master.isIncomingSearch() && e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
        this.resultsList.setToolTipText("");
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_DIFF_PROPERTY + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_EXPORTDIFFS_PROPERTY + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.linkerSupport.mouseMoved(p, (JComponent)this.resultsList, idx);
    }

    @Override
    public Collection getSetups() {
        int[] sel;
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes.length == 0) {
            return this.master.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (int i : sel = this.resultsList.getSelectedIndices()) {
            Object revCon = this.dispResults.get(i);
            if (revCon instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)revCon);
                continue;
            }
            events.add((RepositoryRevision.Event)revCon);
        }
        return this.master.getSetups(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    private void onPopup(MouseEvent e) {
        this.onPopup(e.getPoint());
    }

    private void onPopup(Point p) {
        boolean diffToPrevEnabled;
        RepositoryRevision.Event[] drev;
        boolean revisionSelected;
        int[] sel = this.resultsList.getSelectedIndices();
        if (sel.length == 0) {
            int idx = this.resultsList.locationToIndex(p);
            if (idx == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(idx);
            sel = new int[]{idx};
        }
        final int[] selection = sel;
        JPopupMenu menu = new JPopupMenu();
        String previousRevision = null;
        RepositoryRevision container = null;
        Object revCon = this.dispResults.get(selection[0]);
        boolean noExDeletedExistingFiles = true;
        boolean missingFile = false;
        boolean oneRevisionMultiselected = true;
        if (revCon instanceof RepositoryRevision) {
            revisionSelected = true;
            container = (RepositoryRevision)this.dispResults.get(selection[0]);
            drev = new RepositoryRevision.Event[]{};
            oneRevisionMultiselected = true;
            noExDeletedExistingFiles = true;
        } else {
            revisionSelected = false;
            drev = new RepositoryRevision.Event[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                drev[i] = (RepositoryRevision.Event)this.dispResults.get(selection[i]);
                if (!missingFile && drev[i].getFile() == null) {
                    missingFile = true;
                }
                if (oneRevisionMultiselected && i > 0 && drev[0].getLogInfoHeader().getLog().getRevisionNumber().equals(drev[i].getLogInfoHeader().getLog().getRevisionNumber())) {
                    oneRevisionMultiselected = false;
                }
                if (drev[i].getFile() == null || !drev[i].getFile().exists() || drev[i].getChangedPath().getAction() != 'D') continue;
                noExDeletedExistingFiles = false;
            }
            container = drev[0].getLogInfoHeader();
        }
        long revision = Long.parseLong(container.getLog().getRevisionNumber());
        final boolean revertToEnabled = !missingFile && !revisionSelected && oneRevisionMultiselected;
        final boolean backoutChangeEnabled = !missingFile && oneRevisionMultiselected && drev.length == 0;
        final boolean viewEnabled = selection.length == 1 && !revisionSelected && drev[0].getFile() != null && !drev[0].getFile().isDirectory();
        final boolean annotationsEnabled = viewEnabled && drev[0].getChangedPath().getAction() != HgLogMessage.HgDelStatus;
        boolean bl = diffToPrevEnabled = selection.length == 1;
        if (revision > 0L) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", (Object)("" + previousRevision))){
                {
                    super(x0);
                    this.setEnabled(diffToPrevEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.diffPrevious(selection[0]);
                }
            }));
        }
        if (revisionSelected) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
                {
                    super(x0);
                    this.setEnabled(backoutChangeEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.backout(selection[0]);
                }
            }));
        } else {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)("" + revision))){
                {
                    super(x0);
                    this.setEnabled(revertToEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.revertModifications(selection);
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.this.view(selection[0], false);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations")){
                {
                    super(x0);
                    this.setEnabled(annotationsEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.this.view(selection[0], true);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ExportFileDiff")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.exportFileDiff(selection[0]);
                }
            }));
        }
        menu.show(this.resultsList, p.x, p.y);
    }

    private void backout(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision) {
            RepositoryRevision repoRev = (RepositoryRevision)o;
            BackoutAction.backout(repoRev);
        }
    }

    static void backout(RepositoryRevision.Event event) {
        RepositoryRevision repoRev = event.getLogInfoHeader();
        BackoutAction.backout(repoRev);
    }

    static void revertModifications(RepositoryRevision.Event event) {
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        events.add(event);
        SummaryView.revert(null, events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    public void revertModifications(int[] selection) {
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (int idx : selection) {
            Object o = this.dispResults.get(idx);
            if (o instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)o);
                continue;
            }
            events.add((RepositoryRevision.Event)o);
        }
        SummaryView.revert(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    static void revert(final RepositoryRevision[] revisions, final RepositoryRevision.Event[] events) {
        File root;
        if (revisions == null || revisions.length == 0) {
            if (events == null || events.length == 0 || events[0].getLogInfoHeader() == null) {
                return;
            }
            root = events[0].getLogInfoHeader().getRepositoryRoot();
        } else {
            root = revisions[0].getRepositoryRoot();
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                SummaryView.revertImpl(revisions, events, this);
            }
        };
        support.start(rp, root, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
    }

    private static void revertImpl(RepositoryRevision[] revisions, RepositoryRevision.Event[] events, HgProgressSupport progress) {
        ArrayList<File> revertFiles = new ArrayList<File>();
        boolean doBackup = HgModuleConfig.getDefault().getBackupOnRevertModifications();
        if (revisions != null) {
            for (RepositoryRevision revision : revisions) {
                File root = revision.getRepositoryRoot();
                for (RepositoryRevision.Event event : revision.getEvents()) {
                    if (event.getFile() == null) continue;
                    revertFiles.add(event.getFile());
                }
                RevertModificationsAction.performRevert(root, revision.getLog().getRevisionNumber(), revertFiles, doBackup, progress.getLogger());
                revertFiles.clear();
            }
        }
        HashMap<File, ArrayList<RepositoryRevision.Event>> revertMap = new HashMap<File, ArrayList<RepositoryRevision.Event>>();
        for (RepositoryRevision.Event event : events) {
            ArrayList<RepositoryRevision.Event> revEvents;
            if (event.getFile() == null) continue;
            File root = Mercurial.getInstance().getRepositoryRoot(event.getFile());
            if (revertMap == null) {
                revertMap = new HashMap();
            }
            if ((revEvents = (ArrayList<RepositoryRevision.Event>)revertMap.get(root)) == null) {
                revEvents = new ArrayList<RepositoryRevision.Event>();
                revertMap.put(root, revEvents);
            }
            revEvents.add(event);
        }
        if (events != null && events.length > 0 && revertMap != null && !revertMap.isEmpty()) {
            Set roots = revertMap.keySet();
            for (File root : roots) {
                List revEvents = (List)revertMap.get(root);
                for (RepositoryRevision.Event event : revEvents) {
                    if (event.getFile() == null) continue;
                    revertFiles.add(event.getFile());
                }
                if (revEvents == null || revEvents.isEmpty()) continue;
                RevertModificationsAction.performRevert(root, ((RepositoryRevision.Event)revEvents.get(0)).getLogInfoHeader().getLog().getRevisionNumber(), revertFiles, doBackup, progress.getLogger());
            }
        }
    }

    private void view(int idx, boolean showAnnotations) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision.Event) {
            try {
                RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
                HgUtils.openInRevision(drev.getFile(), drev.getLogInfoHeader().getLog().getHgRevision(), showAnnotations);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    private void diffPrevious(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            this.master.showDiff(drev);
        } else {
            RepositoryRevision container = (RepositoryRevision)o;
            this.master.showDiff(container);
        }
    }

    private void exportDiffs(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision) {
            RepositoryRevision repoRev = (RepositoryRevision)o;
            ExportDiffAction.exportDiffRevision(repoRev, this.master.getRoots());
        }
    }

    private void exportFileDiff(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            ExportDiffAction.exportDiffFileRevision(drev);
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String text, Color foreground, Color background) {
            StringBuilder sb = new StringBuilder(100);
            if (foreground.equals(UIManager.getColor("List.foreground"))) {
                sb.append("<html><a href=\"\">");
                sb.append(text);
                sb.append("</a>");
            } else {
                sb.append("<html><a href=\"\" style=\"color:");
                sb.append("rgb(");
                sb.append(foreground.getRed());
                sb.append(",");
                sb.append(foreground.getGreen());
                sb.append(",");
                sb.append(foreground.getBlue());
                sb.append(")");
                sb.append("\">");
                sb.append(text);
                sb.append("</a>");
            }
            this.setText(sb.toString());
            this.setBackground(background);
        }
    }

    private class SummaryCellRenderer
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private RevisionRenderer rr = new RevisionRenderer();
        private ChangepathRenderer cpr = new ChangepathRenderer();

        private SummaryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RepositoryRevision) {
                return this.rr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            return this.cpr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        private class ChangepathRenderer
        extends DefaultListCellRenderer {
            private ChangepathRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                RepositoryRevision.Event revisionEvent = (RepositoryRevision.Event)value;
                StringBuilder sb = new StringBuilder();
                sb.append(SummaryCellRenderer.FIELDS_SEPARATOR);
                sb.append(String.valueOf(revisionEvent.getChangedPath().getAction()));
                sb.append(SummaryCellRenderer.FIELDS_SEPARATOR);
                sb.append(revisionEvent.getChangedPath().getPath());
                Component renderer = super.getListCellRendererComponent((JList<?>)list, sb.toString(), index, isSelected, isSelected);
                if (renderer instanceof JLabel) {
                    if (revisionEvent.getChangedPath().getAction() == HgLogMessage.HgCopyStatus) {
                        sb.append(" (").append(revisionEvent.getChangedPath().getCopySrcPath()).append(")");
                    }
                    ((JLabel)renderer).setToolTipText(sb.toString());
                }
                return renderer;
            }
        }

        private class RevisionRenderer
        extends JPanel
        implements ListCellRenderer {
            private static final double DARKEN_FACTOR = 0.95;
            private Style selectedStyle;
            private Style normalStyle;
            private Style filenameStyle;
            private Style indentStyle;
            private Style noindentStyle;
            private Style hiliteStyle;
            private Style issueHyperlinkStyle;
            private final Style authorStyle;
            private Color selectionBackground;
            private Color selectionForeground;
            private JTextPane textPane = new JTextPane();
            private JPanel actionsPane = new JPanel();
            private DateFormat defaultFormat;
            private int index;
            private HyperlinkLabel diffLink;
            private HyperlinkLabel revertLink;
            private HyperlinkLabel exportDiffsLink;

            public RevisionRenderer() {
                this.selectionBackground = new JList().getSelectionBackground();
                this.selectionForeground = new JList().getSelectionForeground();
                this.selectedStyle = this.textPane.addStyle("selected", null);
                StyleConstants.setForeground(this.selectedStyle, this.selectionForeground);
                StyleConstants.setBackground(this.selectedStyle, this.selectionBackground);
                this.normalStyle = this.textPane.addStyle("normal", null);
                StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
                this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
                StyleConstants.setBold(this.filenameStyle, true);
                this.indentStyle = this.textPane.addStyle("indent", null);
                StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
                this.noindentStyle = this.textPane.addStyle("noindent", null);
                StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
                this.defaultFormat = DateFormat.getDateTimeInstance();
                this.issueHyperlinkStyle = this.textPane.addStyle("issuehyperlink", this.normalStyle);
                StyleConstants.setForeground(this.issueHyperlinkStyle, Color.BLUE);
                StyleConstants.setUnderline(this.issueHyperlinkStyle, true);
                this.authorStyle = this.textPane.addStyle("author", this.normalStyle);
                StyleConstants.setForeground(this.authorStyle, Color.BLUE);
                this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
                Color c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
                if (c != null) {
                    StyleConstants.setBackground(this.hiliteStyle, c);
                }
                if ((c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                    StyleConstants.setForeground(this.hiliteStyle, c);
                }
                this.setLayout(new BorderLayout());
                this.add(this.textPane);
                this.add((Component)this.actionsPane, "Last");
                this.actionsPane.setLayout(new FlowLayout(4, 2, 5));
                this.diffLink = new HyperlinkLabel();
                this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
                this.actionsPane.add(this.diffLink);
                this.revertLink = new HyperlinkLabel();
                this.revertLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
                this.actionsPane.add(this.revertLink);
                this.exportDiffsLink = new HyperlinkLabel();
                this.actionsPane.add(this.exportDiffsLink);
                this.textPane.setBorder(null);
            }

            public Color darker(Color c) {
                return new Color(Math.max((int)((double)c.getRed() * 0.95), 0), Math.max((int)((double)c.getGreen() * 0.95), 0), Math.max((int)((double)c.getBlue() * 0.95), 0));
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.renderContainer(list, (RepositoryRevision)value, index, isSelected);
                return this;
            }

            private void renderContainer(JList list, RepositoryRevision container, int index, boolean isSelected) {
                Style style;
                Color backgroundColor;
                Color foregroundColor;
                StyledDocument sd = this.textPane.getStyledDocument();
                if (isSelected) {
                    foregroundColor = this.selectionForeground;
                    backgroundColor = this.selectionBackground;
                    style = this.selectedStyle;
                } else {
                    foregroundColor = UIManager.getColor("List.foreground");
                    backgroundColor = UIManager.getColor("List.background");
                    backgroundColor = this.darker(backgroundColor);
                    style = this.normalStyle;
                }
                this.textPane.setBackground(backgroundColor);
                this.actionsPane.setBackground(backgroundColor);
                this.index = index;
                Lookup.Result hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
                Collection hpInstances = hpResult.allInstances();
                try {
                    int idx;
                    VCSKenaiAccessor.KenaiUser kenaiUser;
                    sd.remove(0, sd.getLength());
                    sd.setParagraphAttributes(0, sd.getLength(), this.noindentStyle, false);
                    StringBuilder labelBuilder = new StringBuilder();
                    for (String s : container.getLog().getBranches()) {
                        labelBuilder.append(s).append(' ');
                    }
                    for (String s : container.getLog().getTags()) {
                        labelBuilder.append(s).append(' ');
                    }
                    sd.insertString(0, container.getLog().getRevisionNumber() + " (" + (labelBuilder.length() == 0 ? container.getLog().getCSetShortID() : labelBuilder.toString() + "- " + container.getLog().getCSetShortID().substring(0, 7)) + ")", null);
                    sd.setCharacterAttributes(0, sd.getLength(), this.filenameStyle, false);
                    sd.insertString(sd.getLength(), SummaryCellRenderer.FIELDS_SEPARATOR, style);
                    String author = container.getLog().getAuthor();
                    VCSHyperlinkSupport.StyledDocumentHyperlink l = (VCSHyperlinkSupport.StyledDocumentHyperlink)SummaryView.this.linkerSupport.getLinker(VCSHyperlinkSupport.AuthorLinker.class, index);
                    if (l == null && SummaryView.this.kenaiUsersMap != null && author != null && !author.equals("") && (kenaiUser = (VCSKenaiAccessor.KenaiUser)SummaryView.this.kenaiUsersMap.get(author)) != null) {
                        l = new VCSHyperlinkSupport.AuthorLinker(kenaiUser, this.authorStyle, sd, author);
                        SummaryView.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, index);
                    }
                    if (l != null) {
                        l.insertString(sd, isSelected ? style : null);
                    } else {
                        sd.insertString(sd.getLength(), author, style);
                    }
                    sd.insertString(sd.getLength(), SummaryCellRenderer.FIELDS_SEPARATOR + this.defaultFormat.format(container.getLog().getDate()), null);
                    String commitMessage = container.getLog().getMessage();
                    if (commitMessage.endsWith("\n")) {
                        commitMessage = commitMessage.substring(0, commitMessage.length() - 1);
                    }
                    sd.insertString(sd.getLength(), "\n", null);
                    l = (VCSHyperlinkSupport.StyledDocumentHyperlink)SummaryView.this.linkerSupport.getLinker(VCSHyperlinkSupport.IssueLinker.class, index);
                    if (l == null) {
                        for (VCSHyperlinkProvider hp : hpInstances) {
                            l = VCSHyperlinkSupport.IssueLinker.create((VCSHyperlinkProvider)hp, (Style)this.issueHyperlinkStyle, (File)SummaryView.this.master.getRoots()[0], (StyledDocument)sd, (String)commitMessage);
                            if (l == null) continue;
                            SummaryView.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, index);
                            break;
                        }
                    }
                    if (l != null) {
                        l.insertString(sd, style);
                    } else {
                        sd.insertString(sd.getLength(), commitMessage, style);
                    }
                    int msglen = commitMessage.length();
                    int doclen = sd.getLength();
                    if (SummaryView.this.message != null && !isSelected && (idx = commitMessage.indexOf(SummaryView.this.message)) != -1) {
                        sd.setCharacterAttributes(doclen - msglen + idx, SummaryView.this.message.length(), this.hiliteStyle, true);
                    }
                    this.resizePane(commitMessage, list.getFontMetrics(list.getFont()));
                    if (isSelected) {
                        sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
                    }
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                this.actionsPane.setVisible(true);
                if (!SummaryView.this.master.isIncomingSearch()) {
                    this.diffLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Diff"), foregroundColor, backgroundColor);
                    this.revertLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Revert"), foregroundColor, backgroundColor);
                    this.exportDiffsLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_ExportDiffs"), foregroundColor, backgroundColor);
                }
            }

            private void resizePane(String text, FontMetrics fm) {
                int width;
                if (text == null) {
                    text = "";
                }
                if ((width = SummaryView.this.master.getWidth()) > 0) {
                    Rectangle2D rect = fm.getStringBounds(text, this.textPane.getGraphics());
                    int nlc = -1;
                    int i = 0;
                    while (i != -1) {
                        i = text.indexOf(10, i + 1);
                        ++nlc;
                    }
                    int lines = (int)(rect.getWidth() / (double)(width - 80) + 1.0);
                    int ph = fm.getHeight() * (lines + ++nlc) + 0;
                    this.textPane.setPreferredSize(new Dimension(width - 50, ph));
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.index == -1) {
                    return;
                }
                Rectangle apb = this.actionsPane.getBounds();
                Rectangle bounds = this.diffLink.getBounds();
                bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_DIFF_PROPERTY + this.index, bounds);
                bounds = this.revertLink.getBounds();
                bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_REVERT_PROPERTY + this.index, bounds);
                Rectangle edBounds = this.exportDiffsLink.getBounds();
                edBounds.setBounds(edBounds.x, edBounds.y + apb.y, edBounds.width, edBounds.height);
                SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_EXPORTDIFFS_PROPERTY + this.index, edBounds);
                SummaryView.this.linkerSupport.computeBounds(this.textPane, this.index);
            }
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        @Override
        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        @Override
        public Object getElementAt(int index) {
            return SummaryView.this.dispResults.get(index);
        }
    }
}

