/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.web.core.QueryStringCookie;
import org.netbeans.modules.web.core.WebExecSupport;
import org.netbeans.modules.web.core.jsploader.BaseJspEditorSupport;
import org.netbeans.modules.web.core.jsploader.CompileData;
import org.netbeans.modules.web.core.jsploader.JspNode;
import org.netbeans.modules.web.core.jsploader.JspServletDataLoader;
import org.netbeans.modules.web.core.jsploader.JspServletDataObject;
import org.netbeans.modules.web.core.jsploader.ServletEditor;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class JspDataObject
extends MultiDataObject
implements QueryStringCookie {
    public static final String EA_JSP_ERRORPAGE = "jsp_errorpage";
    public static final String PROP_SERVLET_DATAOBJECT = "servlet_do";
    public static final String PROP_CONTENT_LANGUAGE = "contentLanguage";
    public static final String PROP_SCRIPTING_LANGUAGE = "scriptingLanguage";
    public static final String PROP_SERVER_CHANGE = "PROP_SERVER_CHANGE";
    public static final String PROP_REQUEST_PARAMS = "PROP_REQUEST_PARAMS";
    static final String ATTR_FILE_ENCODING = "Content-Encoding";
    private static final String DEFAULT_ENCODING = "ISO-8559-1";
    private static final Logger LOGGER = Logger.getLogger(JspDataObject.class.getName());
    private transient EditorCookie servletEdit;
    protected transient JspServletDataObject servletDataObject;
    private transient Date servletDataObjectDate;
    private transient CompileData compileData;
    private transient boolean firstStart;
    private transient Listener listener;
    private transient BaseJspEditorSupport editorSupport;
    private static final transient boolean debug = false;
    private transient AtomicReference<String> encoding = new AtomicReference();

    public static MultiViewEditorElement createMultiViewEditorElement(Lookup context) {
        return new JspMultiViewEditorElement(context);
    }

    public JspDataObject(FileObject pf, UniFileLoader l) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)l);
        CookieSet set = this.getCookieSet();
        set.add(BaseJspEditorSupport.class, new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> klass) {
                return (T)((Node.Cookie)klass.cast((Object)JspDataObject.this.getJspEditorSupport()));
            }
        });
        set.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                JspDataObject.this.getJspEditorSupport().saveAs(folder, fileName);
            }
        }});
        set.assign(FileEncodingQueryImplementation.class, (Object[])new FileEncodingQueryImplementation[]{new FileEncodingQueryImplementation(){

            public Charset getEncoding(FileObject file) {
                assert (file != null);
                assert (file.equals(JspDataObject.this.getPrimaryFile()));
                String charsetName = JspDataObject.this.getFileEncoding();
                try {
                    return Charset.forName(charsetName);
                }
                catch (IllegalCharsetNameException ichse) {
                    Boolean template = (Boolean)file.getAttribute("template");
                    if (template == null || !template.booleanValue()) {
                        Logger.getLogger("global").log(Level.INFO, "Detected illegal charset name in file " + file.getNameExt() + " (" + ichse.getMessage() + ")");
                    }
                }
                catch (UnsupportedCharsetException uchse) {
                    Logger.getLogger("global").log(Level.INFO, "Detected unsupported charset name in file " + file.getNameExt() + " (" + uchse.getMessage() + ")");
                }
                return null;
            }
        }});
        this.firstStart = true;
        this.listener = new Listener();
        this.listener.register(this.getPrimaryFile());
        this.refreshPlugin(false);
    }

    protected int associateLookup() {
        return 1;
    }

    public CookieSet getCookieSet0() {
        return super.getCookieSet();
    }

    protected Node createNodeDelegate() {
        return new JspNode(this);
    }

    private synchronized BaseJspEditorSupport getJspEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new BaseJspEditorSupport(this);
        }
        return this.editorSupport;
    }

    protected EditorCookie createServletEditor() {
        return new ServletEditor(this);
    }

    public synchronized CompileData getPlugin() {
        if (this.compileData == null) {
            if (this.firstStart) {
                this.firstStart = false;
            }
            this.compileData = new CompileData(this);
            this.checkRefreshServlet();
        }
        return this.compileData;
    }

    public synchronized void refreshPlugin(boolean reload) {
        this.compileData = null;
        if (reload) {
            this.getPlugin();
        }
    }

    public void refreshPlugin() {
        this.refreshPlugin(true);
    }

    public JspServletDataObject getServletDataObject() {
        this.getPlugin();
        return this.servletDataObject;
    }

    public String getContentLanguage() {
        return "text/html";
    }

    public String getScriptingLanguage() {
        return "text/x-java";
    }

    void loadFileEncoding() {
        this.getFileEncoding();
    }

    String getFileEncoding() {
        this.encoding.compareAndSet(null, this.findFileEncoding(false));
        return this.encoding.get();
    }

    void updateFileEncoding(boolean fromEditor) {
        this.encoding.set(this.findFileEncoding(fromEditor));
    }

    private String findFileEncoding(boolean fromEditor) {
        TagLibParseSupport tlps = (TagLibParseSupport)this.getCookie(TagLibParseSupport.class);
        if (tlps != null) {
            String found = tlps.getCachedOpenInfo(true, fromEditor).getEncoding();
            if (found != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Encoding updated for file {0} to {1}", new Object[]{this.getPrimaryFile().getNameExt(), this.encoding});
                }
                return found;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Retrieved encoding is null for file {0}, using default encoding {1}", new Object[]{this.getPrimaryFile().getNameExt(), DEFAULT_ENCODING});
            }
            return DEFAULT_ENCODING;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "No TagLibParseSupport found - cannot retrieve encoding file {0}, using default encoding {1}", new Object[]{this.getPrimaryFile().getNameExt(), DEFAULT_ENCODING});
        }
        return DEFAULT_ENCODING;
    }

    private void checkRefreshServlet() {
        JspServletDataObject oldServlet = this.servletDataObject;
        try {
            FileObject servletFileObject = this.updateServletFileObject();
            if (servletFileObject != null) {
                String servletEncoding;
                if (oldServlet != null && oldServlet.getPrimaryFile() == servletFileObject && servletFileObject.lastModified().equals(this.servletDataObjectDate)) {
                    return;
                }
                JspServletDataObject.setSourceJspPage(servletFileObject, (DataObject)this);
                DataLoaderPool.setPreferredLoader((FileObject)servletFileObject, (DataLoader)DataLoader.getLoader(JspServletDataLoader.class));
                DataObject dObj = DataObject.find((FileObject)servletFileObject);
                if (dObj instanceof JspServletDataObject) {
                    this.servletDataObject = (JspServletDataObject)dObj;
                    this.servletDataObjectDate = dObj.getPrimaryFile().lastModified();
                }
                if ((servletEncoding = this.compileData.getServletEncoding()) != null) {
                    if (!"".equals(servletEncoding)) {
                        try {
                            Charset.forName(servletEncoding);
                        }
                        catch (IllegalArgumentException ex) {
                            IOException t = new IOException(NbBundle.getMessage(JspDataObject.class, (String)"FMT_UnsupportedEncoding", (Object)servletEncoding));
                            t.initCause(ex);
                            Logger.getLogger("global").log(Level.INFO, null, t);
                        }
                    } else {
                        servletEncoding = null;
                    }
                }
                try {
                    servletFileObject.setAttribute(ATTR_FILE_ENCODING, (Object)servletEncoding);
                }
                catch (IOException ex) {
                    Logger.getLogger("global").log(Level.INFO, null, ex);
                }
            } else {
                this.servletDataObject = null;
            }
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            this.servletDataObject = null;
        }
        if (oldServlet != null) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                @Override
                public void run() {
                    JspDataObject.this.updateServletEditor();
                    JspDataObject.this.firePropertyChange0(JspDataObject.PROP_SERVLET_DATAOBJECT, null, (Object)JspDataObject.this.getServletDataObject());
                    JspDataObject.this.firePropertyChange0("cookie", null, null);
                }
            });
        }
    }

    public void firePropertyChange0(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public EditorCookie getServletEditor() {
        JspServletDataObject obj = this.getServletDataObject();
        if (obj == null != (this.servletEdit == null)) {
            this.updateServletEditor();
        }
        return this.servletEdit;
    }

    private void updateServletEditor() {
        if (this.servletDataObject == null) {
            if (this.servletEdit != null) {
                this.servletEdit.close();
                this.servletEdit = null;
            }
        } else if (this.servletEdit == null) {
            this.servletEdit = this.createServletEditor();
        }
    }

    private FileObject updateServletFileObject() throws IOException {
        return this.compileData.getServletFileObject();
    }

    @Override
    public void setQueryString(String params) throws IOException {
        WebExecSupport.setQueryString(this.getPrimaryEntry().getFile(), params);
        this.firePropertyChange(PROP_REQUEST_PARAMS, null, null);
    }

    public void addSaveCookie(SaveCookie cookie) {
        this.getCookieSet().add((Node.Cookie)cookie);
    }

    public void removeSaveCookie() {
        Node.Cookie cookie = this.getCookie(SaveCookie.class);
        if (cookie != null) {
            this.getCookieSet().remove(cookie);
        }
    }

    protected FileObject handleMove(DataFolder df) throws IOException {
        FileObject retValue = super.handleMove(df);
        TagLibParseSupport tlps = null;
        tlps = (TagLibParseSupport)this.getCookie(TagLibParseSupport.class);
        if (tlps != null) {
            this.getCookieSet().remove((Node.Cookie)tlps);
            tlps = new TagLibParseSupport(retValue);
            this.getCookieSet().add((Node.Cookie)tlps);
        }
        return retValue;
    }

    private class Listener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        WeakReference weakListener;

        Listener() {
        }

        private void register(FileObject fo) {
            EventListener el = WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)fo);
            fo.addFileChangeListener((FileChangeListener)el);
            this.weakListener = new WeakReference<EventListener>(el);
        }

        private void unregister(FileObject fo) {
            FileChangeListener listener = (FileChangeListener)this.weakListener.get();
            if (listener != null) {
                fo.removeFileChangeListener(listener);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataObject dobj;
            if ("modified".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue())) {
                JspDataObject.this.refreshPlugin(false);
            }
            if ("primaryFile".equals(evt.getPropertyName()) || "files".equals(evt.getPropertyName())) {
                if (evt.getOldValue() instanceof FileObject) {
                    this.unregister((FileObject)evt.getOldValue());
                }
                if (evt.getNewValue() instanceof FileObject) {
                    this.register((FileObject)evt.getNewValue());
                }
                JspDataObject.this.refreshPlugin(true);
            }
            if ("valid".equals(evt.getPropertyName()) && evt.getSource() instanceof DataObject && (dobj = (DataObject)evt.getSource()).getPrimaryFile().getPackageNameExt('/', '.').equals("")) {
                dobj.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            JspDataObject.this.refreshPlugin(true);
        }
    }

    public static class JspMultiViewEditorElement
    extends MultiViewEditorElement {
        private static final long serialVersionUID = 5287628924558107957L;

        public JspMultiViewEditorElement(Lookup lookup) {
            super(lookup);
        }

        private BaseJspEditorSupport getEditorSupport() {
            return (BaseJspEditorSupport)((Object)this.getLookup().lookup(BaseJspEditorSupport.class));
        }

        private TagLibParseSupport getTaglibParseSupport() {
            JspDataObject jspDo = (JspDataObject)this.getLookup().lookup(JspDataObject.class);
            return (TagLibParseSupport)jspDo.getCookie(TagLibParseSupport.class);
        }

        public void componentActivated() {
            super.componentActivated();
            this.getEditorSupport().restartParserTask();
            this.getTaglibParseSupport().setEditorOpened(true);
        }

        public void componentDeactivated() {
            super.componentDeactivated();
            this.getTaglibParseSupport().setEditorOpened(false);
        }
    }
}

