/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglib;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableOpenSupport;

public class TLDEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            TLDEditorSupport.this.saveDocument();
        }
    };

    public void saveDocument() throws IOException {
        final StyledDocument doc = this.getDocument();
        String defaultEncoding = "UTF-8";
        String enc = EncodingUtil.detectEncoding((Document)doc);
        boolean changeEncodingToDefault = false;
        if (enc == null) {
            enc = defaultEncoding;
        }
        if (!this.isSupportedEncoding(enc)) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TLDEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), enc, defaultEncoding}), 0, 2);
            nd.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
            changeEncodingToDefault = true;
        }
        if (!changeEncodingToDefault) {
            try {
                CharsetEncoder coder = Charset.forName(enc).newEncoder();
                if (!coder.canEncode(doc.getText(0, doc.getLength()))) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TLDEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), enc}), 0, 2);
                    nd.setValue(NotifyDescriptor.NO_OPTION);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                }
            }
            catch (BadLocationException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        } else {
            try {
                int MAX_PROLOG = 1000;
                int maxPrologLen = Math.min(1000, doc.getLength());
                final char[] prolog = doc.getText(0, maxPrologLen).toCharArray();
                int prologLen = 0;
                if (prolog[0] == '<' && prolog[1] == '?' && prolog[2] == 'x') {
                    for (int i = 3; i < maxPrologLen; ++i) {
                        if (prolog[i] != '?' || prolog[i + 1] != '>') continue;
                        prologLen = i + 1;
                        break;
                    }
                }
                final int passPrologLen = prologLen;
                Runnable edit = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                doc.remove(0, passPrologLen + 1);
                                doc.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(prolog, 0, passPrologLen + 1) + " -->", null);
                            }
                            catch (BadLocationException e) {
                                if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                e.printStackTrace();
                            }
                        }
                    }
                };
                NbDocument.runAtomic((StyledDocument)doc, (Runnable)edit);
                super.saveDocument();
                this.getDataObject().setModified(false);
            }
            catch (BadLocationException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
    }

    private boolean isSupportedEncoding(String encoding) {
        boolean supported;
        try {
            supported = Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException e) {
            supported = false;
        }
        return supported;
    }

    public TLDEditorSupport(TLDDataObject dobj) {
        super((DataObject)dobj, null, (CloneableEditorSupport.Env)new XmlEnv(dobj));
        this.setMIMEType("text/xml");
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)"text/x-tld", (Serializable)this.getDataObject());
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        TLDDataObject obj = (TLDDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.getCookieSet0().add((Node.Cookie)this.saveCookie);
            obj.setModified(true);
        }
    }

    private void removeSaveCookie() {
        TLDDataObject obj = (TLDDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    private static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public XmlEnv(TLDDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((TLDDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (TLDEditorSupport)this.getDataObject().getCookie(TLDEditorSupport.class);
        }
    }
}

