/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class AssignmentIssues {
    public static List<ErrorDescription> assignmentToForLoopParam(HintContext context) {
        TreePath paramPath;
        Trees trees = context.getInfo().getTrees();
        Element param = trees.getElement(paramPath = context.getVariables().get("$param"));
        if (param == null || param.getKind() != ElementKind.LOCAL_VARIABLE) {
            return null;
        }
        TreePath stat = context.getVariables().get("$statement");
        LinkedList paths = new LinkedList();
        new AssignmentFinder(trees, param).scan(stat, paths);
        ArrayList<ErrorDescription> ret = new ArrayList<ErrorDescription>(paths.size());
        for (TreePath path : paths) {
            ret.add(ErrorDescriptionFactory.forTree(context, path, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_AssignmentToForLoopParam", (Object)param.getSimpleName()), new Fix[0]));
        }
        return ret;
    }

    public static List<ErrorDescription> assignmentToCatchBlockParameter(HintContext context) {
        TreePath catchPath;
        Trees trees = context.getInfo().getTrees();
        Element param = trees.getElement(TreePath.getPath(catchPath = context.getPath(), (Tree)((CatchTree)catchPath.getLeaf()).getParameter()));
        if (param == null || param.getKind() != ElementKind.EXCEPTION_PARAMETER) {
            return null;
        }
        TreePath block = TreePath.getPath(catchPath, (Tree)((CatchTree)catchPath.getLeaf()).getBlock());
        LinkedList paths = new LinkedList();
        new AssignmentFinder(trees, param).scan(block, paths);
        ArrayList<ErrorDescription> ret = new ArrayList<ErrorDescription>(paths.size());
        for (TreePath path : paths) {
            ret.add(ErrorDescriptionFactory.forTree(context, path, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_AssignmentToCatchBlockParameter", (Object)param.getSimpleName()), new Fix[0]));
        }
        return ret;
    }

    public static ErrorDescription assignmentToMethodParam(HintContext context) {
        TreePath path = context.getPath();
        Element element = null;
        switch (path.getLeaf().getKind()) {
            case ASSIGNMENT: {
                element = context.getInfo().getTrees().getElement(TreePath.getPath(path, (Tree)((AssignmentTree)path.getLeaf()).getVariable()));
                break;
            }
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                element = context.getInfo().getTrees().getElement(TreePath.getPath(path, (Tree)((UnaryTree)path.getLeaf()).getExpression()));
                break;
            }
            default: {
                element = context.getInfo().getTrees().getElement(TreePath.getPath(path, (Tree)((CompoundAssignmentTree)path.getLeaf()).getVariable()));
            }
        }
        if (element != null && element.getKind() == ElementKind.PARAMETER) {
            return ErrorDescriptionFactory.forTree(context, path, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_AssignmentToMethodParam", (Object)element.getSimpleName()), new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription nestedAssignment(HintContext context) {
        TreePath path = context.getPath();
        Tree.Kind parentKind = path.getParentPath().getLeaf().getKind();
        if (parentKind != Tree.Kind.EXPRESSION_STATEMENT && parentKind != Tree.Kind.ANNOTATION) {
            return ErrorDescriptionFactory.forTree(context, path, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_NestedAssignment", (Object)path.getLeaf()), new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription incrementDecrementUsed(HintContext context) {
        TreePath path = context.getPath();
        if (path.getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            Tree.Kind kind = path.getLeaf().getKind();
            return ErrorDescriptionFactory.forTree(context, path, NbBundle.getMessage(AssignmentIssues.class, (String)(kind == Tree.Kind.PREFIX_INCREMENT || kind == Tree.Kind.POSTFIX_INCREMENT ? "MSG_IncrementUsedAsExpression" : "MSG_DecrementUsedAsExpression"), (Object)path.getLeaf()), new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription replaceAssignWithOpAssign(HintContext context) {
        TreePath path = context.getPath();
        return ErrorDescriptionFactory.forTree(context, path, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_ReplaceAssignmentWithOperatorAssignment", (Object)path.getLeaf()), JavaFix.toEditorFix(new ReplaceAssignmentFix(NbBundle.getMessage(AssignmentIssues.class, (String)"FIX_ReplaceAssignmentWithOperatorAssignment", (Object)path.getLeaf()), TreePathHandle.create((TreePath)path, (CompilationInfo)context.getInfo()))));
    }

    private static final class ReplaceAssignmentFix
    extends JavaFix {
        private final String text;

        public ReplaceAssignmentFix(String text, TreePathHandle handle) {
            super(handle);
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath path, boolean canShowUI) {
            AssignmentTree at = (AssignmentTree)path.getLeaf();
            Tree.Kind kind = null;
            switch (at.getExpression().getKind()) {
                case AND: {
                    kind = Tree.Kind.AND_ASSIGNMENT;
                    break;
                }
                case DIVIDE: {
                    kind = Tree.Kind.DIVIDE_ASSIGNMENT;
                    break;
                }
                case LEFT_SHIFT: {
                    kind = Tree.Kind.LEFT_SHIFT_ASSIGNMENT;
                    break;
                }
                case MINUS: {
                    kind = Tree.Kind.MINUS_ASSIGNMENT;
                    break;
                }
                case MULTIPLY: {
                    kind = Tree.Kind.MULTIPLY_ASSIGNMENT;
                    break;
                }
                case OR: {
                    kind = Tree.Kind.OR_ASSIGNMENT;
                    break;
                }
                case PLUS: {
                    kind = Tree.Kind.PLUS_ASSIGNMENT;
                    break;
                }
                case REMAINDER: {
                    kind = Tree.Kind.REMAINDER_ASSIGNMENT;
                    break;
                }
                case RIGHT_SHIFT: {
                    kind = Tree.Kind.RIGHT_SHIFT_ASSIGNMENT;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    kind = Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT;
                    break;
                }
                case XOR: {
                    kind = Tree.Kind.XOR_ASSIGNMENT;
                }
            }
            if (kind == null) {
                return;
            }
            CompoundAssignmentTree cat = wc.getTreeMaker().CompoundAssignment(kind, at.getVariable(), ((BinaryTree)at.getExpression()).getRightOperand());
            wc.rewrite((Tree)at, (Tree)cat);
        }
    }

    private static final class AssignmentFinder
    extends TreePathScanner<Void, List<TreePath>> {
        private final Trees trees;
        private final Element param;

        private AssignmentFinder(Trees trees, Element param) {
            this.trees = trees;
            this.param = param;
        }

        @Override
        public Void visitAssignment(AssignmentTree node, List<TreePath> p) {
            if (this.param == this.trees.getElement(TreePath.getPath(this.getCurrentPath(), (Tree)node.getVariable()))) {
                p.add(this.getCurrentPath());
                return null;
            }
            return (Void)super.visitAssignment(node, p);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, List<TreePath> p) {
            if (this.param == this.trees.getElement(TreePath.getPath(this.getCurrentPath(), (Tree)node.getVariable()))) {
                p.add(this.getCurrentPath());
                return null;
            }
            return (Void)super.visitCompoundAssignment(node, p);
        }

        @Override
        public Void visitUnary(UnaryTree node, List<TreePath> p) {
            switch (node.getKind()) {
                case PREFIX_INCREMENT: 
                case PREFIX_DECREMENT: 
                case POSTFIX_INCREMENT: 
                case POSTFIX_DECREMENT: {
                    if (this.param != this.trees.getElement(TreePath.getPath(this.getCurrentPath(), (Tree)node.getExpression()))) break;
                    p.add(this.getCurrentPath());
                    return null;
                }
            }
            return (Void)super.visitUnary(node, p);
        }

        @Override
        public Void visitClass(ClassTree node, List<TreePath> p) {
            return null;
        }
    }
}

