/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Braces
extends AbstractHint {
    static final EnumSet<JavaTokenId> nonRelevant = EnumSet.of(JavaTokenId.LINE_COMMENT, JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.WHITESPACE);
    private static final List<Fix> NO_FIXES = Collections.emptyList();
    private String BRACES_ID = "Braces_";
    private Tree.Kind treeKind;
    private Set<Tree.Kind> treeKinds;

    private Braces(Tree.Kind treeKind) {
        super(false, true, AbstractHint.HintSeverity.WARNING, new String[0]);
        this.treeKind = treeKind;
        this.treeKinds = treeKind == Tree.Kind.FOR_LOOP ? EnumSet.of(treeKind, Tree.Kind.ENHANCED_FOR_LOOP) : Collections.singleton(treeKind);
    }

    public static Braces createFor() {
        return new Braces(Tree.Kind.FOR_LOOP);
    }

    public static Braces createWhile() {
        return new Braces(Tree.Kind.WHILE_LOOP);
    }

    public static Braces createDoWhile() {
        return new Braces(Tree.Kind.DO_WHILE_LOOP);
    }

    public static Braces createIf() {
        return new Braces(Tree.Kind.IF);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.treeKinds;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        Tree tree = treePath.getLeaf();
        ErrorDescription ed = null;
        switch (tree.getKind()) {
            case FOR_LOOP: {
                ForLoopTree flt = (ForLoopTree)tree;
                ed = this.checkStatement(flt.getStatement(), treePath, compilationInfo);
                if (ed == null) break;
                return Collections.singletonList(ed);
            }
            case ENHANCED_FOR_LOOP: {
                EnhancedForLoopTree eflt = (EnhancedForLoopTree)tree;
                ed = this.checkStatement(eflt.getStatement(), treePath, compilationInfo);
                if (ed == null) break;
                return Collections.singletonList(ed);
            }
            case WHILE_LOOP: {
                WhileLoopTree wlt = (WhileLoopTree)tree;
                ed = this.checkStatement(wlt.getStatement(), treePath, compilationInfo);
                if (ed == null) break;
                return Collections.singletonList(ed);
            }
            case DO_WHILE_LOOP: {
                DoWhileLoopTree dwlt = (DoWhileLoopTree)tree;
                ed = this.checkStatement(dwlt.getStatement(), treePath, compilationInfo);
                if (ed == null) break;
                return Collections.singletonList(ed);
            }
            case IF: {
                IfTree it = (IfTree)tree;
                List<ErrorDescription> eds = this.checkifStatements(it.getThenStatement(), it.getElseStatement(), treePath, compilationInfo);
                return eds;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return this.BRACES_ID + (Object)((Object)this.treeKind);
    }

    @Override
    public String getDisplayName() {
        switch (this.treeKind) {
            case FOR_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_For");
            }
            case WHILE_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_While");
            }
            case DO_WHILE_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_DoWhile");
            }
            case IF: {
                return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_If");
            }
        }
        return "No Name";
    }

    @Override
    public String getDescription() {
        switch (this.treeKind) {
            case FOR_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"DSC_Braces_For");
            }
            case WHILE_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"DSC_Braces_While");
            }
            case DO_WHILE_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"DSC_Braces_DoWhile");
            }
            case IF: {
                return NbBundle.getMessage(Braces.class, (String)"DSC_Braces_If");
            }
        }
        return "No Description";
    }

    private ErrorDescription checkStatement(StatementTree statement, TreePath tp, CompilationInfo info) {
        int[] span;
        if (statement != null && statement.getKind() != Tree.Kind.EMPTY_STATEMENT && statement.getKind() != Tree.Kind.BLOCK && statement.getKind() != Tree.Kind.ERRONEOUS && !this.isErroneousExpression(statement) && (span = this.span(info, statement)) != null) {
            return ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), Collections.singletonList(JavaFix.toEditorFix(new BracesFix(info.getFileObject(), TreePathHandle.create((TreePath)tp, (CompilationInfo)info)))), (FileObject)info.getFileObject(), (int)span[0], (int)span[1]);
        }
        return null;
    }

    private List<ErrorDescription> checkifStatements(StatementTree thenSt, StatementTree elseSt, TreePath tp, CompilationInfo info) {
        BracesFix bf;
        int[] span;
        boolean fixThen = false;
        boolean fixElse = false;
        if (thenSt != null && thenSt.getKind() != Tree.Kind.EMPTY_STATEMENT && thenSt.getKind() != Tree.Kind.BLOCK && thenSt.getKind() != Tree.Kind.ERRONEOUS && !this.isErroneousExpression(thenSt)) {
            fixThen = true;
        }
        if (elseSt != null && elseSt.getKind() != Tree.Kind.EMPTY_STATEMENT && elseSt.getKind() != Tree.Kind.BLOCK && elseSt.getKind() != Tree.Kind.ERRONEOUS && elseSt.getKind() != Tree.Kind.IF && !this.isErroneousExpression(elseSt)) {
            fixElse = true;
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        if (fixThen && (span = this.span(info, thenSt)) != null) {
            bf = new BracesFix(info.getFileObject(), TreePathHandle.create((TreePath)tp, (CompilationInfo)info));
            bf.fixThen = fixThen;
            bf.fixElse = fixElse;
            result.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), Collections.singletonList(JavaFix.toEditorFix(bf)), (FileObject)info.getFileObject(), (int)span[0], (int)span[1]));
        }
        if (fixElse && (span = this.span(info, elseSt)) != null) {
            bf = new BracesFix(info.getFileObject(), TreePathHandle.create((TreePath)tp, (CompilationInfo)info));
            bf.fixThen = fixThen;
            bf.fixElse = fixElse;
            result.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), Collections.singletonList(JavaFix.toEditorFix(bf)), (FileObject)info.getFileObject(), (int)span[0], (int)span[1]));
        }
        return result;
    }

    private boolean isErroneousExpression(StatementTree statement) {
        return statement instanceof ExpressionStatementTree && ((ExpressionStatementTree)statement).getExpression().getKind() == Tree.Kind.ERRONEOUS;
    }

    private int[] span(CompilationInfo info, Tree t) {
        int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), t);
        int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), t);
        if (start >= 0 && end >= 0) {
            return new int[]{start, end};
        }
        return null;
    }

    private static class BracesFix
    extends JavaFix {
        boolean fixThen;
        boolean fixElse;

        public BracesFix(FileObject file, TreePathHandle tph) {
            super(tph);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_Fix");
        }

        @Override
        protected void performRewrite(WorkingCopy copy, TreePath path, boolean canShowUI) {
            if (path != null) {
                TreeMaker make = copy.getTreeMaker();
                Tree oldTree = path.getLeaf();
                switch (oldTree.getKind()) {
                    case FOR_LOOP: {
                        ForLoopTree oldFor = (ForLoopTree)oldTree;
                        StatementTree oldBlock = oldFor.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        break;
                    }
                    case ENHANCED_FOR_LOOP: {
                        EnhancedForLoopTree oldEnhancedFor = (EnhancedForLoopTree)oldTree;
                        StatementTree oldBlock = oldEnhancedFor.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        break;
                    }
                    case WHILE_LOOP: {
                        WhileLoopTree oldWhile = (WhileLoopTree)oldTree;
                        StatementTree oldBlock = oldWhile.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        break;
                    }
                    case DO_WHILE_LOOP: {
                        DoWhileLoopTree oldDoWhile = (DoWhileLoopTree)oldTree;
                        StatementTree oldBlock = oldDoWhile.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        break;
                    }
                    case IF: {
                        BlockTree newBlock;
                        StatementTree oldBlock;
                        IfTree oldIf = (IfTree)oldTree;
                        if (this.fixThen) {
                            oldBlock = oldIf.getThenStatement();
                            newBlock = make.Block(Collections.singletonList(oldBlock), false);
                            copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        }
                        if (!this.fixElse) break;
                        oldBlock = oldIf.getElseStatement();
                        newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                    }
                }
            }
        }
    }
}

