/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DoubleCheck {
    public static ErrorDescription run(HintContext ctx) {
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Tree e = treePath.getLeaf();
        SynchronizedTree synch = (SynchronizedTree)e;
        TreePath outer = DoubleCheck.findOuterIf(ctx, treePath);
        if (outer == null) {
            return null;
        }
        IfTree same = null;
        TreePath block = new TreePath(treePath, synch.getBlock());
        for (StatementTree statementTree : synch.getBlock().getStatements()) {
            if (DoubleCheck.sameIfAndValidate(compilationInfo, new TreePath(block, statementTree), outer)) {
                same = (IfTree)statementTree;
                break;
            }
            if (!ctx.isCanceled()) continue;
            return null;
        }
        if (same == null) {
            return null;
        }
        Fix fix = JavaFix.toEditorFix(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), TreePathHandle.create((TreePath)outer, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), synch);
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(DoubleCheck.class, (String)"ERR_DoubleCheck"), fix);
    }

    private static TreePath findOuterIf(HintContext ctx, TreePath treePath) {
        while (!ctx.isCanceled() && (treePath = treePath.getParentPath()) != null) {
            BlockTree b;
            Tree leaf = treePath.getLeaf();
            if (leaf.getKind() == Tree.Kind.IF) {
                return treePath;
            }
            if (leaf.getKind() == Tree.Kind.BLOCK && (b = (BlockTree)leaf).getStatements().size() == 1) continue;
            return null;
        }
        return null;
    }

    private static boolean sameIfAndValidate(CompilationInfo info, TreePath statementTP, TreePath secondTP) {
        StatementTree statement = (StatementTree)statementTP.getLeaf();
        if (statement.getKind() != Tree.Kind.IF) {
            return false;
        }
        IfTree first = (IfTree)statement;
        IfTree second = (IfTree)secondTP.getLeaf();
        if (first.getElseStatement() != null) {
            return false;
        }
        if (second.getElseStatement() != null) {
            return false;
        }
        TreePath varFirst = DoubleCheck.equalToNull(new TreePath(statementTP, first.getCondition()));
        TreePath varSecond = DoubleCheck.equalToNull(new TreePath(secondTP, second.getCondition()));
        if (varFirst == null || varSecond == null) {
            return false;
        }
        Element firstVariable = info.getTrees().getElement(varFirst);
        Element secondVariable = info.getTrees().getElement(varSecond);
        if (firstVariable != null && ((Object)firstVariable).equals(secondVariable)) {
            return info.getSourceVersion().compareTo(SourceVersion.RELEASE_5) < 0 || !firstVariable.getModifiers().contains((Object)Modifier.VOLATILE);
        }
        return false;
    }

    private static TreePath equalToNull(TreePath tp) {
        ExpressionTree t = (ExpressionTree)tp.getLeaf();
        if (t.getKind() == Tree.Kind.PARENTHESIZED) {
            ParenthesizedTree p = (ParenthesizedTree)t;
            t = p.getExpression();
            tp = new TreePath(tp, t);
        }
        if (t.getKind() != Tree.Kind.EQUAL_TO) {
            return null;
        }
        BinaryTree bt = (BinaryTree)t;
        if (bt.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL && bt.getRightOperand().getKind() != Tree.Kind.NULL_LITERAL) {
            return new TreePath(tp, bt.getRightOperand());
        }
        if (bt.getLeftOperand().getKind() != Tree.Kind.NULL_LITERAL && bt.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            return new TreePath(tp, bt.getLeftOperand());
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private TreePathHandle synchHandle;
        private FileObject file;

        public FixImpl(TreePathHandle synchHandle, TreePathHandle ifHandle, FileObject file) {
            super(ifHandle);
            this.synchHandle = synchHandle;
            this.file = file;
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(DoubleCheck.class, (String)"FIX_DoubleCheck");
        }

        public String toString() {
            return "FixDoubleCheck";
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath ifTreePath, boolean canShowUI) {
            Tree syncTree = this.synchHandle.resolve((CompilationInfo)wc).getLeaf();
            wc.rewrite(ifTreePath.getLeaf(), syncTree);
        }
    }
}

