/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.hints.FieldForUnusedParamCustomizer;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class FieldForUnusedParam
extends AbstractHint {
    private static final String FINAL_FIELDS = "final-fields";
    private final AtomicBoolean cancel = new AtomicBoolean();

    public static boolean isFinalFields() {
        return new FieldForUnusedParam().getPreferences(null).getBoolean(FINAL_FIELDS, true);
    }

    static void setFinalFields(Preferences p, boolean selected) {
        p.putBoolean(FINAL_FIELDS, selected);
    }

    public FieldForUnusedParam() {
        super(true, true, AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.VARIABLE);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        return this.run(compilationInfo, treePath, CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)compilationInfo.getFileObject()));
    }

    List<ErrorDescription> run(final CompilationInfo info, TreePath treePath, int offset) {
        class Result
        extends RuntimeException {
            Result() {
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        }
        this.cancel.set(false);
        if (!this.getTreeKinds().contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        if (treePath.getParentPath() == null || treePath.getParentPath().getLeaf().getKind() != Tree.Kind.METHOD) {
            return null;
        }
        final Element el = info.getTrees().getElement(treePath);
        if (el == null || el.getKind() != ElementKind.PARAMETER) {
            return null;
        }
        MethodTree parent = (MethodTree)treePath.getParentPath().getLeaf();
        Element parentEl = info.getTrees().getElement(treePath.getParentPath());
        if (parentEl == null || parentEl.getKind() != ElementKind.CONSTRUCTOR || parent.getBody() == null) {
            return null;
        }
        boolean existing = false;
        for (VariableElement field : ElementFilter.fieldsIn(parentEl.getEnclosingElement().getEnclosedElements())) {
            if (this.cancel.get()) {
                return null;
            }
            if (!((Object)field.getSimpleName()).equals(el.getSimpleName())) continue;
            if (!info.getTypes().isAssignable(field.asType(), el.asType())) {
                return null;
            }
            existing = true;
            break;
        }
        boolean found = false;
        try {
            new CancellableTreePathScanner<Void, Void>(this.cancel){

                public Void visitIdentifier(IdentifierTree node, Void p) {
                    Element e = info.getTrees().getElement(this.getCurrentPath());
                    if (((Object)el).equals(e)) {
                        throw new Result();
                    }
                    return (Void)super.visitIdentifier(node, (Object)p);
                }
            }.scan(new TreePath(treePath.getParentPath(), parent.getBody()), null);
        }
        catch (Result r) {
            found = true;
        }
        if (this.cancel.get() || found) {
            return null;
        }
        List<FixImpl> fix = Collections.singletonList(new FixImpl(info.getJavaSource(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)info), existing));
        String displayName = NbBundle.getMessage(FieldForUnusedParam.class, (String)"ERR_UnusedParameter");
        ErrorDescription err = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)displayName, fix, (FileObject)info.getFileObject(), (int)offset, (int)offset);
        return Collections.singletonList(err);
    }

    @Override
    public String getId() {
        return FieldForUnusedParam.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(FieldForUnusedParam.class, (String)"DN_FieldUnusedParam");
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return new FieldForUnusedParamCustomizer(node);
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(FieldForUnusedParam.class, (String)"DSC_FieldUnusedParam");
    }

    static final class FixImpl
    implements Fix {
        private final JavaSource js;
        private final TreePathHandle tph;
        final boolean existing;

        public FixImpl(JavaSource js, TreePathHandle tph, boolean existing) {
            this.js = js;
            this.tph = tph;
            this.existing = existing;
        }

        public String getText() {
            return this.existing ? NbBundle.getMessage(FieldForUnusedParam.class, (String)"FIX_AssignToExisting") : NbBundle.getMessage(FieldForUnusedParam.class, (String)"FIX_CreateField");
        }

        public ChangeInfo implement() throws Exception {
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    int n;
                    wc.toPhase(JavaSource.Phase.PARSED);
                    TreePath variable = FixImpl.this.tph.resolve((CompilationInfo)wc);
                    if (variable == null) {
                        return;
                    }
                    VariableTree vt = (VariableTree)variable.getLeaf();
                    MethodTree mt = (MethodTree)variable.getParentPath().getLeaf();
                    ClassTree ct = (ClassTree)variable.getParentPath().getParentPath().getLeaf();
                    TreeMaker make = wc.getTreeMaker();
                    Name before = null;
                    int index = 0;
                    for (VariableTree variableTree : mt.getParameters()) {
                        if (variableTree == vt) {
                            if (mt.getParameters().size() <= index + 1) break;
                            before = mt.getParameters().get(index + 1).getName();
                            break;
                        }
                        ++index;
                    }
                    if (!FixImpl.this.existing) {
                        EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PRIVATE);
                        if (FieldForUnusedParam.isFinalFields()) {
                            modifiers.add(Modifier.FINAL);
                        }
                        VariableTree variableTree = make.Variable(make.Modifiers(modifiers), (CharSequence)vt.getName(), vt.getType(), null);
                        int insertPlace = -1;
                        index = 0;
                        for (Tree tree : ct.getMembers()) {
                            if (tree.getKind() == Tree.Kind.VARIABLE && ((Object)((VariableTree)tree).getName()).equals(before)) {
                                insertPlace = index;
                                break;
                            }
                            ++index;
                        }
                        wc.rewrite((Tree)ct, (Tree)(insertPlace != -1 ? make.insertClassMember(ct, insertPlace, (Tree)variableTree) : GeneratorUtilities.get((WorkingCopy)wc).insertClassMember(ct, (Tree)variableTree)));
                    }
                    ExpressionStatementTree assignment = make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)vt.getName()), (ExpressionTree)make.Identifier((CharSequence)vt.getName())));
                    int n2 = -1;
                    index = 0;
                    for (StatementTree statementTree : mt.getBody().getStatements()) {
                        MemberSelectTree mst;
                        AssignmentTree at;
                        ExpressionStatementTree expressionStatementTree;
                        if (statementTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (expressionStatementTree = (ExpressionStatementTree)statementTree).getExpression().getKind() == Tree.Kind.ASSIGNMENT && (at = (AssignmentTree)expressionStatementTree.getExpression()).getVariable().getKind() == Tree.Kind.MEMBER_SELECT && ((Object)(mst = (MemberSelectTree)at.getVariable()).getIdentifier()).equals(before) && mst.getExpression().getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)mst.getExpression()).getName().contentEquals("this")) {
                            n = index;
                            break;
                        }
                        ++index;
                    }
                    wc.rewrite((Tree)mt.getBody(), (Tree)(n != -1 ? make.insertBlockStatement(mt.getBody(), n, (StatementTree)assignment) : make.addBlockStatement(mt.getBody(), (StatementTree)assignment)));
                }
            }).commit();
            return null;
        }
    }
}

