/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.hints.Imports;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class StandardJavacWarnings
extends AbstractHint
implements PreferenceChangeListener {
    private static StandardJavacWarnings deprecated;
    private static StandardJavacWarnings unchecked;
    private static StandardJavacWarnings fallthrough;
    private static StandardJavacWarnings serialization;
    private static StandardJavacWarnings fajnly;
    private static StandardJavacWarnings unnecessaryCast;
    private static StandardJavacWarnings emptyStatementAfterIf;
    private static StandardJavacWarnings overrides;
    private static StandardJavacWarnings divisionByZero;
    private static StandardJavacWarnings rawTypes;
    private String JAVAC_ID = "Javac_";
    private Set<Tree.Kind> treeKinds = EnumSet.noneOf(Tree.Kind.class);
    private Kind kind;

    private StandardJavacWarnings(Kind kind) {
        super(kind.defaultOn(), false, AbstractHint.HintSeverity.WARNING, new String[0]);
        this.kind = kind;
        this.getPreferences(null);
    }

    public static synchronized StandardJavacWarnings createDeprecated() {
        if (deprecated == null) {
            deprecated = new StandardJavacWarnings(Kind.DEPRECATED);
        }
        return deprecated;
    }

    public static synchronized StandardJavacWarnings createUnchecked() {
        if (unchecked == null) {
            unchecked = new StandardJavacWarnings(Kind.UNCHECKED);
        }
        return unchecked;
    }

    public static synchronized StandardJavacWarnings createFallthrough() {
        if (fallthrough == null) {
            fallthrough = new StandardJavacWarnings(Kind.FALLTHROUGH);
        }
        return fallthrough;
    }

    public static synchronized StandardJavacWarnings createSerialization() {
        if (serialization == null) {
            serialization = new StandardJavacWarnings(Kind.SERIALIZATION);
        }
        return serialization;
    }

    public static synchronized StandardJavacWarnings createFinally() {
        if (fajnly == null) {
            fajnly = new StandardJavacWarnings(Kind.FINALLY);
        }
        return fajnly;
    }

    public static synchronized StandardJavacWarnings createUnnecessaryCast() {
        if (unnecessaryCast == null) {
            unnecessaryCast = new StandardJavacWarnings(Kind.UNNECESSARY_CAST);
        }
        return unnecessaryCast;
    }

    public static synchronized StandardJavacWarnings createEmptyStatementAfterIf() {
        if (emptyStatementAfterIf == null) {
            emptyStatementAfterIf = new StandardJavacWarnings(Kind.EMPTY_STATEMENT_AFTER_IF);
        }
        return emptyStatementAfterIf;
    }

    public static synchronized StandardJavacWarnings createOverrides() {
        if (overrides == null) {
            overrides = new StandardJavacWarnings(Kind.OVERRIDES);
        }
        return overrides;
    }

    public static synchronized StandardJavacWarnings createDivisionByZero() {
        if (divisionByZero == null) {
            divisionByZero = new StandardJavacWarnings(Kind.DIVISION_BY_ZERO);
        }
        return divisionByZero;
    }

    public static synchronized StandardJavacWarnings createRawTypes() {
        if (rawTypes == null) {
            rawTypes = new StandardJavacWarnings(Kind.RAWTYPES);
        }
        return rawTypes;
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.treeKinds;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return this.JAVAC_ID + this.kind.toString();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(Imports.class, (String)("LBL_Javac_" + this.kind.toString()));
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(Imports.class, (String)("DSC_Javac_" + this.kind.toString()));
    }

    @Override
    public final Preferences getPreferences(String profile) {
        Preferences p = super.getPreferences(profile);
        try {
            p.removePreferenceChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        p.addPreferenceChangeListener(this);
        return p;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        Preferences p = NbPreferences.forModule(JavaSource.class);
        p = p.node("compiler_settings");
        p.putBoolean(this.kind.key(), this.isEnabled());
    }

    private static enum Kind {
        DEPRECATED,
        UNCHECKED,
        FALLTHROUGH,
        SERIALIZATION,
        FINALLY,
        UNNECESSARY_CAST,
        EMPTY_STATEMENT_AFTER_IF,
        OVERRIDES,
        DIVISION_BY_ZERO,
        RAWTYPES;


        boolean defaultOn() {
            return false;
        }

        String key() {
            switch (this) {
                case DEPRECATED: {
                    return "enable_lint_deprecation";
                }
                case UNCHECKED: {
                    return "enable_lint_unchecked";
                }
                case FALLTHROUGH: {
                    return "enable_lint_fallthrough";
                }
                case SERIALIZATION: {
                    return "enable_lint_serial";
                }
                case FINALLY: {
                    return "enable_lint_finally";
                }
                case UNNECESSARY_CAST: {
                    return "enable_lint_cast";
                }
                case DIVISION_BY_ZERO: {
                    return "enable_lint_dvizero";
                }
                case EMPTY_STATEMENT_AFTER_IF: {
                    return "enable_lint_empty";
                }
                case OVERRIDES: {
                    return "enable_lint_overrides";
                }
                case RAWTYPES: {
                    return "enable_lint_rawtypes";
                }
            }
            return "unknown_kind";
        }
    }
}

