/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class StringBuilderAppend {
    public static ErrorDescription builder(HintContext ctx) {
        return StringBuilderAppend.hint(ctx, "StringBuilder");
    }

    public static ErrorDescription buffer(HintContext ctx) {
        return StringBuilderAppend.hint(ctx, "StringBuffer");
    }

    private static ErrorDescription hint(HintContext ctx, String clazzName) {
        CompilationInfo info = ctx.getInfo();
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        ExpressionTree param = mit.getArguments().get(0);
        List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements(info, new TreePath(ctx.getPath(), param));
        if (sorted.size() > 1) {
            String error = NbBundle.getMessage(StringBuilderAppend.class, (String)"ERR_StringBuilderAppend", (Object)clazzName);
            return ErrorDescriptionFactory.forTree(ctx, param, error, JavaFix.toEditorFix(new FixImpl(info, ctx.getPath())));
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(StringBuilderAppend.class, (String)"FIX_StringBuilderAppend");
        }

        @Override
        protected void performRewrite(WorkingCopy copy, TreePath tp, boolean canShowUI) {
            MethodInvocationTree mit = (MethodInvocationTree)tp.getLeaf();
            ExpressionTree param = mit.getArguments().get(0);
            List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements((CompilationInfo)copy, new TreePath(tp, param));
            ExpressionTree site = ((MemberSelectTree)mit.getMethodSelect()).getExpression();
            TreeMaker make = copy.getTreeMaker();
            for (List<TreePath> cluster : sorted) {
                ExpressionTree arg = (ExpressionTree)cluster.remove(0).getLeaf();
                while (!cluster.isEmpty()) {
                    arg = make.Binary(Tree.Kind.PLUS, arg, (ExpressionTree)cluster.remove(0).getLeaf());
                }
                while (arg.getKind() == Tree.Kind.PARENTHESIZED) {
                    arg = ((ParenthesizedTree)arg).getExpression();
                }
                site = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(site, (CharSequence)"append"), Collections.singletonList(arg));
            }
            copy.rewrite((Tree)mit, (Tree)site);
        }
    }
}

