/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class UnusedAssignmentOrBranch {
    private static final String UNUSED_ASSIGNMENT_ID = "org.netbeans.modules.java.hints.bugs.UnusedAssignmentOrBranch.unusedAssignment";
    private static final String DEAD_BRANCH_ID = "org.netbeans.modules.java.hints.bugs.UnusedAssignmentOrBranch.deadBranch";
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

    private static Flow.FlowResult runFlow(final HintContext ctx) {
        Flow.FlowResult flow = Flow.assignmentsForUse(ctx.getInfo(), new TreePath(ctx.getInfo().getCompilationUnit()), new Flow.Cancel(){

            @Override
            public boolean isCanceled() {
                return ctx.isCanceled();
            }
        });
        if (flow == null || ctx.isCanceled()) {
            return null;
        }
        return flow;
    }

    public static List<ErrorDescription> unusedAssignment(final HintContext ctx) {
        final String unusedAssignmentLabel = NbBundle.getMessage(UnusedAssignmentOrBranch.class, (String)"LBL_UNUSED_ASSIGNMENT_LABEL");
        final CompilationInfo info = ctx.getInfo();
        Flow.FlowResult flow = UnusedAssignmentOrBranch.runFlow(ctx);
        if (flow == null) {
            return null;
        }
        final HashSet<Tree> usedAssignments = new HashSet<Tree>();
        for (Iterable<? extends TreePath> i : flow.getAssignmentsForUse().values()) {
            for (TreePath treePath : i) {
                if (treePath == null) continue;
                usedAssignments.add(treePath.getLeaf());
            }
        }
        final HashSet usedVariables = new HashSet();
        new CancellableTreePathScanner<Void, Void>(){

            public Void visitAssignment(AssignmentTree node, Void p) {
                Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression())) {
                    this.scan(node.getExpression(), null);
                    return null;
                }
                return (Void)super.visitAssignment(node, (Object)p);
            }

            public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
                Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression())) {
                    this.scan(node.getExpression(), null);
                    return null;
                }
                return (Void)super.visitCompoundAssignment(node, (Object)p);
            }

            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element var = info.getTrees().getElement(this.getCurrentPath());
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind())) {
                    usedVariables.add(var);
                }
                return (Void)super.visitIdentifier(node, (Object)p);
            }

            protected boolean isCanceled() {
                return ctx.isCanceled();
            }
        }.scan((Tree)info.getCompilationUnit(), null);
        if (ctx.isCanceled()) {
            return null;
        }
        final ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        new CancellableTreePathScanner<Void, Void>(){

            public Void visitAssignment(AssignmentTree node, Void p) {
                Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression()) && usedVariables.contains(var)) {
                    this.unusedValue(node.getExpression());
                }
                return (Void)super.visitAssignment(node, (Object)p);
            }

            public Void visitVariable(VariableTree node, Void p) {
                Element var = info.getTrees().getElement(this.getCurrentPath());
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && node.getInitializer() != null && !usedAssignments.contains(node.getInitializer()) && usedVariables.contains(var)) {
                    this.unusedValue(node.getInitializer());
                }
                return (Void)super.visitVariable(node, (Object)p);
            }

            protected boolean isCanceled() {
                return ctx.isCanceled();
            }

            private void unusedValue(Tree t) {
                result.add(ErrorDescriptionFactory.forTree(ctx, t, unusedAssignmentLabel, new Fix[0]));
            }
        }.scan((Tree)info.getCompilationUnit(), null);
        return result;
    }

    public static List<ErrorDescription> deadBranch(HintContext ctx) {
        String deadBranchLabel = NbBundle.getMessage(UnusedAssignmentOrBranch.class, (String)"LBL_DEAD_BRANCH");
        Flow.FlowResult flow = UnusedAssignmentOrBranch.runFlow(ctx);
        if (flow == null) {
            return null;
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        for (Tree tree : flow.getDeadBranches()) {
            if (ctx.isCanceled()) {
                return null;
            }
            result.add(ErrorDescriptionFactory.forTree(ctx, tree, deadBranchLabel, new Fix[0]));
        }
        return result;
    }
}

