/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.preprocessorbridge.spi.ImportProcessor;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ImportClass
implements ErrorRule<ImportCandidatesHolder> {
    static RequestProcessor WORKER = new RequestProcessor("ImportClassEnabler", 1);
    private boolean cancelled;
    private ComputeImports compImports;

    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.doesnt.exist", "compiler.err.not.stmt"));
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<ImportCandidatesHolder> data) {
        TreePath imp;
        MethodInvocationTree mit;
        this.resume();
        int errorPosition = offset + 1;
        if (errorPosition == -1) {
            ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create errorPosition=-1");
            return Collections.emptyList();
        }
        TreePath path = info.getTreeUtilities().pathFor(errorPosition);
        if (path.getParentPath() != null && path.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && !(mit = (MethodInvocationTree)path.getParentPath().getLeaf()).getTypeArguments().contains(path.getLeaf())) {
            return Collections.emptyList();
        }
        Token ident = null;
        try {
            ident = ErrorHintsProvider.findUnresolvedElementToken(info, offset);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create ident={0}", ident);
        if (ident == null) {
            return Collections.emptyList();
        }
        FileObject file = info.getFileObject();
        String simpleName = ((Object)ident.text()).toString();
        Pair<List<String>, List<String>> candidates = this.getCandidateFQNs(info, file, simpleName, data);
        List<? extends ImportTree> imports = info.getCompilationUnit().getImports();
        for (ImportTree importTree : imports) {
            List<String> a;
            String toString = importTree.getQualifiedIdentifier().toString();
            if (candidates == null || (a = candidates.getA()) == null || !a.contains(toString)) continue;
            return Collections.emptyList();
        }
        if (this.isCancelled() || candidates == null) {
            ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancelled.");
            return CreatorBasedLazyFixList.CANCELLED;
        }
        for (imp = path; imp != null && imp.getLeaf().getKind() != Tree.Kind.IMPORT; imp = imp.getParentPath()) {
        }
        List<String> list = candidates.getA();
        List<String> unfiltered = candidates.getB();
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        if (unfiltered != null && list != null) {
            for (String fqn : unfiltered) {
                StringBuilder sort = new StringBuilder();
                sort.append("0001#");
                boolean prefered = list.contains(fqn);
                if (prefered) {
                    sort.append("A#");
                } else {
                    sort.append("Z#");
                }
                int order = Utilities.getImportanceLevel((String)fqn);
                String orderString = Integer.toHexString(order);
                sort.append("00000000".substring(0, 8 - orderString.length()));
                sort.append(orderString);
                sort.append('#');
                sort.append(fqn);
                fixes.add((Fix)new FixImport(file, fqn, sort.toString(), prefered, info, imp));
            }
        }
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create finished.");
        return fixes;
    }

    @Override
    public synchronized void cancel() {
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancel called.");
        this.cancelled = true;
        if (this.compImports != null) {
            this.compImports.cancel();
        }
    }

    @Override
    public String getId() {
        return ImportClass.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Add Import Fix";
    }

    public String getDescription() {
        return "Add Import Fix";
    }

    private synchronized void resume() {
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.resume called.");
        this.cancelled = false;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized void setComputeImports(ComputeImports compImports) {
        this.compImports = compImports;
    }

    public Pair<List<String>, List<String>> getCandidateFQNs(CompilationInfo info, FileObject file, String simpleName, ErrorRule.Data<ImportCandidatesHolder> data) {
        Pair<Map<String, List<String>>, Map<String, List<String>>> result;
        ImportCandidatesHolder holder = data.getData();
        if (holder == null) {
            holder = new ImportCandidatesHolder();
            data.setData(holder);
        }
        if ((result = holder.getCandidates()) == null || result.getA() == null || result.getB() == null) {
            HashMap candidates = new HashMap();
            ComputeImports imp = new ComputeImports();
            this.setComputeImports(imp);
            ComputeImports.Pair rawCandidates = imp.computeCandidates(info);
            this.setComputeImports(null);
            if (this.isCancelled() || rawCandidates == null) {
                ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.getCandidateFQNs cancelled, returning.");
                return null;
            }
            for (String sn : ((Map)rawCandidates.a).keySet()) {
                ArrayList<String> c = new ArrayList<String>();
                for (TypeElement te : (List)((Map)rawCandidates.a).get(sn)) {
                    c.add(te.getQualifiedName().toString());
                }
                candidates.put(sn, c);
            }
            HashMap notFilteredCandidates = new HashMap();
            for (String sn : ((Map)rawCandidates.b).keySet()) {
                ArrayList<String> c = new ArrayList<String>();
                for (TypeElement te : (List)((Map)rawCandidates.b).get(sn)) {
                    c.add(te.getQualifiedName().toString());
                }
                notFilteredCandidates.put(sn, c);
            }
            result = new Pair(candidates, notFilteredCandidates);
            holder.setCandidates(result);
        }
        List<String> candList = result.getA().get(simpleName);
        List<String> notFilteredCandList = result.getB().get(simpleName);
        return new Pair<List<String>, List<String>>(candList, notFilteredCandList);
    }

    static final class FixImport
    implements EnhancedFix {
        private final FileObject file;
        private final String fqn;
        private final String sortText;
        private final boolean isValid;
        @NullAllowed
        private final TreePathHandle importHandle;
        @NullAllowed
        private final String suffix;
        private final boolean statik;

        public FixImport(FileObject file, String fqn, String sortText, boolean isValid, CompilationInfo info, @NullAllowed TreePath imp) {
            this.file = file;
            this.fqn = fqn;
            this.sortText = sortText;
            this.isValid = isValid;
            if (imp != null) {
                this.importHandle = TreePathHandle.create((TreePath)imp, (CompilationInfo)info);
                String suffixLoc = ((ImportTree)imp.getLeaf()).getQualifiedIdentifier().toString();
                int dot = suffixLoc.indexOf(46);
                this.suffix = dot > -1 ? suffixLoc.substring(dot) : suffixLoc;
                this.statik = ((ImportTree)imp.getLeaf()).isStatic();
            } else {
                this.importHandle = null;
                this.suffix = null;
                this.statik = false;
            }
        }

        public String getText() {
            String displayName;
            String string = this.importHandle == null ? NbBundle.getMessage(ImportClass.class, (String)"Add_import_for_X", (Object[])new Object[]{this.fqn}) : (displayName = Bundle.Change_to_import_X(this.fqn + this.suffix, this.statik ? "static " : ""));
            if (this.isValid) {
                return displayName;
            }
            return JavaFixAllImports.NOT_VALID_IMPORT_HTML + displayName;
        }

        public ChangeInfo implement() throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            Task<WorkingCopy> task = new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    if (copy.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    if (FixImport.this.importHandle != null) {
                        TreePath imp = FixImport.this.importHandle.resolve((CompilationInfo)copy);
                        if (imp == null) {
                            Logger.getAnonymousLogger().warning(String.format("Attempt to change import for FQN: %s, but the import cannot be resolved in the current context", FixImport.this.fqn));
                            return;
                        }
                        Tree mst = ((ImportTree)imp.getLeaf()).getQualifiedIdentifier();
                        while (mst != null && mst.getKind() == Tree.Kind.MEMBER_SELECT) {
                            mst = ((MemberSelectTree)mst).getExpression();
                        }
                        if (mst == null) {
                            copy.rewrite(imp.getLeaf(), (Tree)copy.getTreeMaker().Identifier((CharSequence)(FixImport.this.fqn + FixImport.this.suffix)));
                            return;
                        }
                        copy.rewrite(mst, (Tree)copy.getTreeMaker().Identifier((CharSequence)FixImport.this.fqn));
                        return;
                    }
                    TypeElement te = copy.getElements().getTypeElement(FixImport.this.fqn);
                    if (te == null) {
                        Logger.getAnonymousLogger().warning(String.format("Attempt to fix import for FQN: %s, which does not have a TypeElement in currect context", FixImport.this.fqn));
                        return;
                    }
                    CompilationUnitTree cut = GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), Collections.singleton(te));
                    copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)cut);
                }
            };
            if (js != null) {
                js.runModificationTask((Task)task).commit();
            } else {
                String topLevelLanguageMIMEType;
                DataObject od = DataObject.find((FileObject)this.file);
                EditorCookie ec = (EditorCookie)od.getLookup().lookup(EditorCookie.class);
                StyledDocument doc = ec != null ? ec.openDocument() : null;
                String string = topLevelLanguageMIMEType = doc != null ? NbEditorUtilities.getMimeType((Document)doc) : null;
                if (topLevelLanguageMIMEType != null) {
                    Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)topLevelLanguageMIMEType));
                    Collection instances = lookup.lookupAll(ImportProcessor.class);
                    for (ImportProcessor importsProcesor : instances) {
                        importsProcesor.addImport((Document)doc, this.fqn);
                    }
                }
            }
            return null;
        }

        public int hashCode() {
            return this.fqn.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FixImport) {
                return this.fqn.equals(((FixImport)o).fqn);
            }
            return false;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }
    }

    public static class ImportCandidatesHolder {
        private Pair<Map<String, List<String>>, Map<String, List<String>>> candidates;

        public Pair<Map<String, List<String>>, Map<String, List<String>>> getCandidates() {
            return this.candidates;
        }

        public void setCandidates(Pair<Map<String, List<String>>, Map<String, List<String>>> candidates) {
            this.candidates = candidates;
        }
    }
}

