/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class VarArgsCast
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.warn.inexact.non-varargs.call"));

    @Override
    public Set<String> getCodes() {
        return CODES;
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        TreePath call = treePath;
        if (call.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION && (call = call.getParentPath()).getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        MethodInvocationTree mit = (MethodInvocationTree)call.getLeaf();
        TypeMirror mType = info.getTrees().getTypeMirror(new TreePath(call, mit.getMethodSelect()));
        if (mType == null || mType.getKind() != TypeKind.EXECUTABLE) {
            return null;
        }
        ExecutableType methodType = (ExecutableType)mType;
        if (methodType.getParameterTypes().isEmpty() || methodType.getParameterTypes().get(methodType.getParameterTypes().size() - 1).getKind() != TypeKind.ARRAY) {
            return null;
        }
        ArrayType targetArray = (ArrayType)methodType.getParameterTypes().get(methodType.getParameterTypes().size() - 1);
        TreePath target = new TreePath(call, mit.getArguments().get(mit.getArguments().size() - 1));
        return Arrays.asList(JavaFix.toEditorFix(new FixImpl(info, target, targetArray.getComponentType())), JavaFix.toEditorFix(new FixImpl(info, target, targetArray)));
    }

    @Override
    public String getId() {
        return VarArgsCast.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(VarArgsCast.class, (String)"DN_VarArgsCast");
    }

    @Override
    public void cancel() {
    }

    static final class FixImpl
    extends JavaFix {
        private final TypeMirrorHandle<TypeMirror> type;
        private final String treeName;
        private final String typeName;

        public FixImpl(CompilationInfo info, TreePath path, TypeMirror type) {
            super(info, path);
            this.type = TypeMirrorHandle.create((TypeMirror)type);
            this.treeName = Utilities.shortDisplayName(info, (ExpressionTree)path.getLeaf());
            this.typeName = ((Object)info.getTypeUtilities().getTypeName(type, new TypeUtilities.TypeNameOptions[0])).toString();
        }

        @Override
        protected String getText() {
            return NbBundle.getMessage(VarArgsCast.class, (String)"FIX_VarArgsCast", (Object)this.treeName, (Object)this.typeName);
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath tp, boolean canShowUI) {
            TypeMirror targetType = this.type.resolve((CompilationInfo)wc);
            if (targetType == null) {
                return;
            }
            TreeMaker make = wc.getTreeMaker();
            TypeCastTree nue = make.TypeCast(make.Type(targetType), (ExpressionTree)tp.getLeaf());
            if (FixImpl.requiresParenthesis(tp.getLeaf(), tp.getLeaf(), nue)) {
                nue = make.TypeCast(make.Type(targetType), (ExpressionTree)make.Parenthesized((ExpressionTree)tp.getLeaf()));
            }
            wc.rewrite(tp.getLeaf(), (Tree)nue);
        }
    }
}

