/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.code;

import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.hints.jackpot.code.FSWrapper;
import org.netbeans.modules.java.hints.jackpot.code.spi.Constraint;
import org.netbeans.modules.java.hints.jackpot.code.spi.Hint;
import org.netbeans.modules.java.hints.jackpot.code.spi.TriggerPattern;
import org.netbeans.modules.java.hints.jackpot.code.spi.TriggerPatterns;
import org.netbeans.modules.java.hints.jackpot.code.spi.TriggerTreeKind;
import org.netbeans.modules.java.hints.jackpot.spi.CustomizerProvider;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.jackpot.spi.HintProvider;
import org.netbeans.modules.java.hints.jackpot.spi.Trigger;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;

public class CodeHintProviderImpl
implements HintProvider {
    @Override
    public Map<HintMetadata, ? extends Collection<? extends HintDescription>> computeHints() {
        return this.computeHints(CodeHintProviderImpl.findLoader(), "META-INF/nb-hints/hints");
    }

    private Map<HintMetadata, ? extends Collection<? extends HintDescription>> computeHints(ClassLoader l, String path) {
        HashMap<HintMetadata, Collection<HintDescription>> result = new HashMap<HintMetadata, Collection<HintDescription>>();
        for (FSWrapper.ClassWrapper classWrapper : FSWrapper.listClasses()) {
            CodeHintProviderImpl.processClass(classWrapper, result);
        }
        return result;
    }

    static ClassLoader findLoader() {
        ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (l == null) {
            return CodeHintProviderImpl.class.getClassLoader();
        }
        return l;
    }

    public static void processClass(FSWrapper.ClassWrapper clazz, Map<HintMetadata, Collection<HintDescription>> result) throws SecurityException {
        String id;
        Hint metadata = clazz.getAnnotation(Hint.class);
        if (metadata == null) {
            metadata = new EmptyHintMetadataDescription();
        }
        if ((id = metadata.id()) == null || id.length() == 0) {
            id = clazz.getName();
        }
        HintMetadata hm = CodeHintProviderImpl.fromAnnotation(id, clazz, metadata);
        for (FSWrapper.MethodWrapper methodWrapper : clazz.getMethods()) {
            HintMetadata localMetadata;
            Hint localMetadataAnnotation = methodWrapper.getAnnotation(Hint.class);
            if (localMetadataAnnotation != null) {
                String localID = localMetadataAnnotation.id();
                if (localID == null || localID.length() == 0) {
                    localID = clazz.getName() + "." + methodWrapper.getName();
                }
                localMetadata = CodeHintProviderImpl.fromAnnotation(localID, clazz, localMetadataAnnotation);
            } else {
                localMetadata = hm;
            }
            CodeHintProviderImpl.processMethod(result, methodWrapper, localMetadata);
        }
    }

    private static HintMetadata fromAnnotation(String id, FSWrapper.ClassWrapper clazz, Hint metadata) {
        HintMetadata hm = HintMetadata.Builder.create(id).setBundle(clazz.getName()).setCategory(metadata.category()).setEnabled(metadata.enabled()).setSeverity(metadata.severity()).setKind(metadata.hintKind()).setCustomizerProvider(CodeHintProviderImpl.createCustomizerProvider(metadata)).addSuppressWarnings(metadata.suppressWarnings()).addOptions(metadata.options()).build();
        return hm;
    }

    private static CustomizerProvider createCustomizerProvider(Hint hint) {
        Class<? extends CustomizerProvider> clazz = hint.customizerProvider();
        if (clazz != CustomizerProvider.class) {
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(CodeHintProviderImpl.class.getName()).log(Level.INFO, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(CodeHintProviderImpl.class.getName()).log(Level.INFO, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(CodeHintProviderImpl.class.getName()).log(Level.INFO, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(CodeHintProviderImpl.class.getName()).log(Level.INFO, null, ex);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(CodeHintProviderImpl.class.getName()).log(Level.INFO, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(CodeHintProviderImpl.class.getName()).log(Level.INFO, null, ex);
            }
        }
        return null;
    }

    static void processMethod(Map<HintMetadata, Collection<HintDescription>> hints, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        CodeHintProviderImpl.processTreeKindHint(hints, m, metadata);
        CodeHintProviderImpl.processPatternHint(hints, m, metadata);
    }

    private static void processTreeKindHint(Map<HintMetadata, Collection<HintDescription>> hints, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        TriggerTreeKind kindTrigger = m.getAnnotation(TriggerTreeKind.class);
        if (kindTrigger == null) {
            return;
        }
        WorkerImpl w = new WorkerImpl(m.getClazz().getName(), m.getName());
        EnumSet<Tree.Kind> kinds = EnumSet.noneOf(Tree.Kind.class);
        kinds.addAll(Arrays.asList(kindTrigger.value()));
        CodeHintProviderImpl.addHint(hints, metadata, HintDescriptionFactory.create().setTrigger(new Trigger.Kinds(kinds)).setWorker(w).setMetadata(metadata).produce());
    }

    private static void processPatternHint(Map<HintMetadata, Collection<HintDescription>> hints, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        TriggerPattern patternTrigger = m.getAnnotation(TriggerPattern.class);
        if (patternTrigger != null) {
            CodeHintProviderImpl.processPatternHint(hints, patternTrigger, m, metadata);
            return;
        }
        TriggerPatterns patternTriggers = m.getAnnotation(TriggerPatterns.class);
        if (patternTriggers != null) {
            for (TriggerPattern pattern : patternTriggers.value()) {
                CodeHintProviderImpl.processPatternHint(hints, pattern, m, metadata);
            }
            return;
        }
    }

    private static void processPatternHint(Map<HintMetadata, Collection<HintDescription>> hints, TriggerPattern patternTrigger, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        String pattern = patternTrigger.value();
        HashMap<String, String> constraints = new HashMap<String, String>();
        for (Constraint c : patternTrigger.constraints()) {
            constraints.put(c.variable(), c.type());
        }
        Trigger.PatternDescription pd = Trigger.PatternDescription.create(pattern, constraints, new String[0]);
        CodeHintProviderImpl.addHint(hints, metadata, HintDescriptionFactory.create().setTrigger(pd).setWorker(new WorkerImpl(m.getClazz().getName(), m.getName())).setMetadata(metadata).produce());
    }

    private static void addHint(Map<HintMetadata, Collection<HintDescription>> hints, HintMetadata metadata, HintDescription hint) {
        Collection<HintDescription> list = hints.get(metadata);
        if (list == null) {
            list = new LinkedList<HintDescription>();
            hints.put(metadata, list);
        }
        list.add(hint);
    }

    private static final class EmptyHintMetadataDescription
    implements Hint {
        private static final String[] EMPTY_SW = new String[0];
        private static final HintMetadata.Options[] EMPTY_OPTIONS = new HintMetadata.Options[0];

        private EmptyHintMetadataDescription() {
        }

        @Override
        public String id() {
            return "";
        }

        @Override
        public String category() {
            return "general";
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public AbstractHint.HintSeverity severity() {
            return AbstractHint.HintSeverity.WARNING;
        }

        @Override
        public String[] suppressWarnings() {
            return EMPTY_SW;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Hint.class;
        }

        @Override
        public Class<? extends CustomizerProvider> customizerProvider() {
            return CustomizerProvider.class;
        }

        @Override
        public HintMetadata.Kind hintKind() {
            return HintMetadata.Kind.HINT;
        }

        @Override
        public HintMetadata.Options[] options() {
            return EMPTY_OPTIONS;
        }
    }

    static final class WorkerImpl
    implements HintDescription.Worker {
        private final String className;
        private final String methodName;
        private final AtomicReference<Method> methodRef = new AtomicReference();

        public WorkerImpl(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        @Override
        public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
            try {
                Object result;
                Method method = this.methodRef.get();
                if (method == null) {
                    method = this.getMethod();
                    this.methodRef.set(method);
                }
                if ((result = method.invoke(null, ctx)) == null) {
                    return null;
                }
                if (result instanceof Iterable) {
                    LinkedList<ErrorDescription> out = new LinkedList<ErrorDescription>();
                    for (ErrorDescription ed : NbCollections.iterable((Iterator)NbCollections.checkedIteratorByFilter(((Iterable)result).iterator(), ErrorDescription.class, (boolean)false))) {
                        out.add(ed);
                    }
                    return out;
                }
                if (result instanceof ErrorDescription) {
                    return Collections.singletonList((ErrorDescription)result);
                }
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }

        Method getMethod() throws NoSuchMethodException, ClassNotFoundException {
            return FSWrapper.resolveMethod(this.className, this.methodName);
        }
    }
}

