/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.spi.ClassPathBasedHintProvider;
import org.netbeans.modules.java.hints.jackpot.spi.ElementBasedHintProvider;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.jackpot.spi.HintProvider;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class RulesManager {
    public final Map<HintMetadata, Collection<? extends HintDescription>> allHints = new HashMap<HintMetadata, Collection<? extends HintDescription>>();
    private static final RulesManager INSTANCE = new RulesManager();

    public static RulesManager getInstance() {
        return INSTANCE;
    }

    private RulesManager() {
        this.reload();
    }

    public void reload() {
        for (HintProvider p : Lookup.getDefault().lookupAll(HintProvider.class)) {
            Map<HintMetadata, ? extends Collection<? extends HintDescription>> pHints = p.computeHints();
            this.allHints.putAll(pHints);
        }
    }

    public static void computeElementBasedHintsXXX(CompilationInfo info, AtomicBoolean cancel, List<HintDescription> outHints) {
        RulesManager.computeElementBasedHintsXXX(info, cancel, Lookup.getDefault().lookupAll(ElementBasedHintProvider.class), Lookup.getDefault().lookupAll(ClassPathBasedHintProvider.class), outHints);
    }

    public static void computeElementBasedHintsXXX(CompilationInfo info, AtomicBoolean cancel, Collection<? extends ElementBasedHintProvider> providers, Collection<? extends ClassPathBasedHintProvider> cpBasedProviders, List<HintDescription> outHints) {
        for (ElementBasedHintProvider elementBasedHintProvider : providers) {
            outHints.addAll(elementBasedHintProvider.computeHints(info));
        }
        ClasspathInfo cpInfo = info.getClasspathInfo();
        LinkedList<ClassPath> linkedList = new LinkedList<ClassPath>();
        linkedList.add(cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT));
        linkedList.add(cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE));
        linkedList.add(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE));
        ClassPath compound = ClassPathSupport.createProxyClassPath((ClassPath[])linkedList.toArray(new ClassPath[0]));
        for (ClassPathBasedHintProvider classPathBasedHintProvider : cpBasedProviders) {
            outHints.addAll(classPathBasedHintProvider.computeHints(compound));
        }
    }

    public static Preferences getPreferences(String hintId, String profile) {
        Preferences p;
        Map<String, Preferences> override = HintsSettings.getPreferencesOverride();
        if (override != null && (p = override.get(hintId)) != null) {
            return p;
        }
        profile = profile == null ? HintsSettings.getCurrentProfileId() : profile;
        return NbPreferences.forModule(RulesManager.class).node(profile).node(hintId);
    }
}

