/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.parser.EndPosParser;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.CancelService;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javadoc.Messager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.modules.java.hints.jackpot.impl.JackpotTrees;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.ClassPathBasedHintProvider;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.Trigger;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.pretty.ImportAnalysis2;
import org.netbeans.modules.java.source.transform.ImmutableTreeTranslator;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;

public class Utilities {
    private static long inc;

    private Utilities() {
    }

    public static <E> Iterable<E> checkedIterableByFilter(final Iterable raw, final Class<E> type, final boolean strict) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return NbCollections.checkedIteratorByFilter(raw.iterator(), (Class)type, (boolean)strict);
            }
        };
    }

    public static ExpressionTree prepareAssignment(TreeMaker make, String name, ExpressionTree value) {
        return make.Assignment((ExpressionTree)make.Identifier((CharSequence)name), value);
    }

    public static ExpressionTree findValue(AnnotationTree m, String name) {
        for (ExpressionTree expressionTree : m.getArguments()) {
            AssignmentTree at;
            String varName;
            if (expressionTree.getKind() == Tree.Kind.ASSIGNMENT && (varName = ((IdentifierTree)(at = (AssignmentTree)expressionTree).getVariable()).getName().toString()).equals(name)) {
                return at.getExpression();
            }
            if (!(expressionTree instanceof LiteralTree) || !"value".equals(name)) continue;
            return expressionTree;
        }
        return null;
    }

    public static java.util.List<AnnotationTree> findArrayValue(AnnotationTree at, String name) {
        ExpressionTree fixesArray = Utilities.findValue(at, name);
        LinkedList<AnnotationTree> fixes = new LinkedList<AnnotationTree>();
        if (fixesArray != null && fixesArray.getKind() == Tree.Kind.NEW_ARRAY) {
            NewArrayTree trees = (NewArrayTree)fixesArray;
            for (ExpressionTree expressionTree : trees.getInitializers()) {
                if (expressionTree.getKind() != Tree.Kind.ANNOTATION) continue;
                fixes.add((AnnotationTree)expressionTree);
            }
        }
        if (fixesArray != null && fixesArray.getKind() == Tree.Kind.ANNOTATION) {
            fixes.add((AnnotationTree)fixesArray);
        }
        return fixes;
    }

    public static boolean isPureMemberSelect(Tree mst, boolean allowVariables) {
        switch (mst.getKind()) {
            case IDENTIFIER: {
                return allowVariables || ((IdentifierTree)mst).getName().charAt(0) != '$';
            }
            case MEMBER_SELECT: {
                return Utilities.isPureMemberSelect(((MemberSelectTree)mst).getExpression(), allowVariables);
            }
        }
        return false;
    }

    public static Map<String, Collection<HintDescription>> sortOutHints(Iterable<? extends HintDescription> hints, Map<String, Collection<HintDescription>> output) {
        for (HintDescription hintDescription : hints) {
            Collection<HintDescription> h = output.get(hintDescription.getMetadata().displayName);
            if (h == null) {
                h = new LinkedList<HintDescription>();
                output.put(hintDescription.getMetadata().displayName, h);
            }
            h.add(hintDescription);
        }
        return output;
    }

    public static java.util.List<HintDescription> listAllHints(Set<ClassPath> cps) {
        LinkedList<HintDescription> result = new LinkedList<HintDescription>();
        for (Collection<? extends HintDescription> hints : RulesManager.getInstance().allHints.values()) {
            for (HintDescription hintDescription : hints) {
                if (!(hintDescription.getTrigger() instanceof Trigger.PatternDescription)) continue;
                result.add(hintDescription);
            }
        }
        result.addAll(Utilities.listClassPathHints(cps));
        return result;
    }

    public static java.util.List<HintDescription> listClassPathHints(Set<ClassPath> cps) {
        LinkedList<HintDescription> result = new LinkedList<HintDescription>();
        HashSet<FileObject> roots = new HashSet<FileObject>();
        for (ClassPath cp : cps) {
            for (FileObject r : cp.getRoots()) {
                SourceForBinaryQuery.Result2 src;
                try {
                    src = SourceForBinaryQuery.findSourceRoots2((URL)r.getURL());
                }
                catch (FileStateInvalidException ex) {
                    Logger.getLogger(Utilities.class.getName()).log(Level.FINE, null, ex);
                    src = null;
                }
                if (src != null && src.preferSources()) {
                    roots.addAll(Arrays.asList(src.getRoots()));
                    continue;
                }
                roots.add(r);
            }
        }
        ClassPath cp = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[0]));
        for (ClassPathBasedHintProvider p : Lookup.getDefault().lookupAll(ClassPathBasedHintProvider.class)) {
            result.addAll(p.computeHints(cp));
        }
        return result;
    }

    public static Tree parseAndAttribute(CompilationInfo info, String pattern, Scope scope) {
        return Utilities.parseAndAttribute(info, pattern, scope, null);
    }

    public static Tree parseAndAttribute(CompilationInfo info, String pattern, Scope scope, Collection<Diagnostic<? extends JavaFileObject>> errors) {
        return Utilities.parseAndAttribute(info, JavaSourceAccessor.getINSTANCE().getJavacTask(info), pattern, scope, errors);
    }

    public static Tree parseAndAttribute(CompilationInfo info, String pattern, Scope scope, SourcePositions[] sourcePositions, Collection<Diagnostic<? extends JavaFileObject>> errors) {
        return Utilities.parseAndAttribute(info, JavaSourceAccessor.getINSTANCE().getJavacTask(info), pattern, scope, sourcePositions, errors);
    }

    public static Tree parseAndAttribute(JavacTaskImpl jti, String pattern) {
        return Utilities.parseAndAttribute(jti, pattern, null);
    }

    public static Tree parseAndAttribute(JavacTaskImpl jti, String pattern, Collection<Diagnostic<? extends JavaFileObject>> errors) {
        return Utilities.parseAndAttribute(null, jti, pattern, null, errors);
    }

    public static Tree parseAndAttribute(JavacTaskImpl jti, String pattern, SourcePositions[] sourcePositions, Collection<Diagnostic<? extends JavaFileObject>> errors) {
        return Utilities.parseAndAttribute(null, jti, pattern, null, sourcePositions, errors);
    }

    private static Tree parseAndAttribute(CompilationInfo info, JavacTaskImpl jti, String pattern, Scope scope, Collection<Diagnostic<? extends JavaFileObject>> errors) {
        return Utilities.parseAndAttribute(info, jti, pattern, scope, new SourcePositions[1], errors);
    }

    /*
     * WARNING - void declaration
     */
    private static Tree parseAndAttribute(CompilationInfo info, JavacTaskImpl jti, String pattern, Scope scope, SourcePositions[] sourcePositions, Collection<Diagnostic<? extends JavaFileObject>> errors) {
        Context c = jti.getContext();
        TreeFactory make = TreeFactory.instance((Context)c);
        LinkedList<Diagnostic<? extends JavaFileObject>> patternTreeErrors = new LinkedList<Diagnostic<? extends JavaFileObject>>();
        Tree patternTree = !Utilities.isStatement(pattern) ? Utilities.parseExpression(c, pattern, true, sourcePositions, patternTreeErrors) : null;
        int offset = 0;
        boolean expression = true;
        boolean classMember = false;
        if (pattern.startsWith("case ")) {
            LinkedList<Diagnostic<? extends JavaFileObject>> currentPatternTreeErrors = new LinkedList<Diagnostic<? extends JavaFileObject>>();
            JCTree.JCStatement switchTree = Utilities.parseStatement(c, "switch ($$foo) {" + pattern + "}", sourcePositions, currentPatternTreeErrors);
            offset = "switch ($$foo) {".length();
            patternTreeErrors = currentPatternTreeErrors;
            patternTree = ((SwitchTree)((Object)switchTree)).getCases().get(0);
        }
        if (patternTree == null || Utilities.isErrorTree(patternTree)) {
            void var15_19;
            SourcePositions[] currentPatternTreePositions = new SourcePositions[1];
            LinkedList<Diagnostic<? extends JavaFileObject>> currentPatternTreeErrors = new LinkedList<Diagnostic<? extends JavaFileObject>>();
            JCTree.JCStatement jCStatement = Utilities.parseStatement(c, "{" + pattern + "}", currentPatternTreePositions, currentPatternTreeErrors);
            assert (jCStatement.getKind() == Tree.Kind.BLOCK) : jCStatement.getKind();
            java.util.List<? extends StatementTree> statements = ((BlockTree)((Object)jCStatement)).getStatements();
            if (statements.size() == 1) {
                Tree tree = statements.get(0);
            } else {
                LinkedList<? extends StatementTree> newStatements = new LinkedList<StatementTree>();
                newStatements.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$$1$")));
                newStatements.addAll(statements);
                newStatements.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$$2$")));
                BlockTree blockTree = make.Block(newStatements, false);
            }
            if (!currentPatternTreeErrors.isEmpty() || Utilities.containsError((Tree)var15_19)) {
                SourcePositions[] classPatternTreePositions = new SourcePositions[1];
                LinkedList<Diagnostic<? extends JavaFileObject>> classPatternTreeErrors = new LinkedList<Diagnostic<? extends JavaFileObject>>();
                JCTree.JCExpression classPatternTree = Utilities.parseExpression(c, "new Object() {" + pattern + "}", false, classPatternTreePositions, classPatternTreeErrors);
                if (!Utilities.containsError(classPatternTree)) {
                    sourcePositions[0] = classPatternTreePositions[0];
                    offset = "new Object() {".length();
                    patternTreeErrors = classPatternTreeErrors;
                    patternTree = classPatternTree;
                    classMember = true;
                } else {
                    sourcePositions[0] = currentPatternTreePositions[0];
                    offset = 1;
                    patternTreeErrors = currentPatternTreeErrors;
                    patternTree = var15_19;
                }
            } else {
                sourcePositions[0] = currentPatternTreePositions[0];
                offset = 1;
                patternTreeErrors = currentPatternTreeErrors;
                patternTree = var15_19;
            }
            expression = false;
        }
        int syntheticOffset = 0;
        if (scope != null) {
            TypeMirror type = Utilities.attributeTree(jti, patternTree, scope, patternTreeErrors);
            if (Utilities.isError(type) && expression) {
                Elements elements = jti.getElements();
                if (Utilities.isPureMemberSelect(patternTree, false)) {
                    JCTree.JCCompilationUnit cut;
                    SourcePositions[] varPositions = new SourcePositions[1];
                    LinkedList<Diagnostic<? extends JavaFileObject>> varErrors = new LinkedList<Diagnostic<? extends JavaFileObject>>();
                    JCTree.JCExpression var = Utilities.parseExpression(c, pattern + ".class;", false, varPositions, varErrors);
                    type = Utilities.attributeTree(jti, var, scope, varErrors);
                    ExpressionTree typeTree = ((MemberSelectTree)((Object)var)).getExpression();
                    JavacTrees trees = JavacTrees.instance(c);
                    if (!Utilities.isError(((Trees)trees).getElement(new TreePath(new TreePath(cut = ((JavacScope)scope).getEnv().toplevel), typeTree)))) {
                        sourcePositions[0] = varPositions[0];
                        offset = 0;
                        patternTreeErrors = varErrors;
                        patternTree = typeTree;
                    }
                }
            }
            syntheticOffset = 1;
        }
        if (classMember) {
            java.util.List<? extends Tree> members = ((NewClassTree)patternTree).getClassBody().getMembers();
            if (members.size() > 1 + syntheticOffset) {
                ModifiersTree modifiersTree = make.Modifiers(EnumSet.noneOf(Modifier.class));
                LinkedList<? extends Tree> newMembers = new LinkedList<Tree>();
                newMembers.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$$1$")));
                newMembers.addAll(members.subList(syntheticOffset, members.size()));
                patternTree = make.Class(modifiersTree, (CharSequence)"$", Collections.emptyList(), null, Collections.emptyList(), newMembers);
            } else {
                patternTree = members.get(0 + syntheticOffset);
            }
        }
        if (errors != null) {
            for (Diagnostic diagnostic : patternTreeErrors) {
                errors.add(new OffsetDiagnostic(diagnostic, -offset));
            }
        }
        sourcePositions[0] = new OffsetSourcePositions(sourcePositions[0], -offset);
        return patternTree;
    }

    private static boolean isError(Element el) {
        return el == null || el.getKind() == ElementKind.CLASS && Utilities.isError(((TypeElement)el).asType());
    }

    private static boolean isError(TypeMirror type) {
        return type == null || type.getKind() == TypeKind.ERROR;
    }

    private static boolean isStatement(String pattern) {
        return pattern.trim().endsWith(";");
    }

    private static boolean isErrorTree(Tree t) {
        return t.getKind() == Tree.Kind.ERRONEOUS || t.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)t).getName().contentEquals("<error>");
    }

    private static boolean containsError(Tree t) {
        return new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean scan(Tree node, Void p) {
                if (node != null && Utilities.isErrorTree(node)) {
                    return true;
                }
                return super.scan(node, p) == Boolean.TRUE;
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
            }
        }.scan(t, (Void)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JCTree.JCStatement parseStatement(Context context, CharSequence stmt, SourcePositions[] pos, java.util.List<Diagnostic<? extends JavaFileObject>> errors) {
        if (stmt == null || pos != null && pos.length != 1) {
            throw new IllegalArgumentException();
        }
        JavaCompiler compiler = JavaCompiler.instance(context);
        JavaFileObject prev = compiler.log.useSource(new DummyJFO());
        DiagnosticListener oldDiag = compiler.log.getDiagnosticListener();
        int origNErrors = compiler.log.nerrors;
        int origNWarnings = compiler.log.nwarnings;
        boolean origDeferDiagnostic = compiler.log.deferDiagnostics;
        compiler.log.deferDiagnostics = false;
        compiler.log.setDiagnosticListener(new DiagnosticListenerImpl(errors));
        try {
            CharBuffer buf = CharBuffer.wrap((stmt + "\u0000").toCharArray(), 0, stmt.length());
            ParserFactory factory = ParserFactory.instance(context);
            ScannerFactory scannerFactory = ScannerFactory.instance(context);
            Names names = Names.instance(context);
            JackpotJavacParser parser = new JackpotJavacParser(context, factory, scannerFactory.newScanner(buf, false), false, false, CancelService.instance((Context)context), names);
            if (parser instanceof JavacParser) {
                if (pos != null) {
                    pos[0] = new ParserSourcePositions((JavacParser)((Object)parser));
                }
                JCTree.JCStatement jCStatement = parser.parseStatement();
                return jCStatement;
            }
            JCTree.JCStatement jCStatement = null;
            return jCStatement;
        }
        finally {
            compiler.log.useSource(prev);
            compiler.log.setDiagnosticListener(oldDiag);
            compiler.log.nerrors = origNErrors;
            compiler.log.nwarnings = origNWarnings;
            compiler.log.deferDiagnostics = origDeferDiagnostic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JCTree.JCExpression parseExpression(Context context, CharSequence expr, boolean onlyFullInput, SourcePositions[] pos, java.util.List<Diagnostic<? extends JavaFileObject>> errors) {
        if (expr == null || pos != null && pos.length != 1) {
            throw new IllegalArgumentException();
        }
        JavaCompiler compiler = JavaCompiler.instance(context);
        JavaFileObject prev = compiler.log.useSource(new DummyJFO());
        DiagnosticListener oldDiag = compiler.log.getDiagnosticListener();
        int origNErrors = compiler.log.nerrors;
        int origNWarnings = compiler.log.nwarnings;
        boolean origDeferDiagnostic = compiler.log.deferDiagnostics;
        compiler.log.deferDiagnostics = false;
        compiler.log.setDiagnosticListener(new DiagnosticListenerImpl(errors));
        try {
            CharBuffer buf = CharBuffer.wrap((expr + "\u0000").toCharArray(), 0, expr.length());
            ParserFactory factory = ParserFactory.instance(context);
            ScannerFactory scannerFactory = ScannerFactory.instance(context);
            Names names = Names.instance(context);
            Scanner scanner = scannerFactory.newScanner(buf, false);
            JackpotJavacParser parser = new JackpotJavacParser(context, factory, scanner, false, false, CancelService.instance((Context)context), names);
            if (parser instanceof JavacParser) {
                if (pos != null) {
                    pos[0] = new ParserSourcePositions((JavacParser)((Object)parser));
                }
                JCTree.JCExpression result = parser.parseExpression();
                if (!onlyFullInput || scanner.token() == Token.EOF) {
                    JCTree.JCExpression jCExpression = result;
                    return jCExpression;
                }
            }
            JCTree.JCExpression jCExpression = null;
            return jCExpression;
        }
        finally {
            compiler.log.useSource(prev);
            compiler.log.setDiagnosticListener(oldDiag);
            compiler.log.nerrors = origNErrors;
            compiler.log.nwarnings = origNWarnings;
            compiler.log.deferDiagnostics = origDeferDiagnostic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeMirror attributeTree(JavacTaskImpl jti, Tree tree, Scope scope, java.util.List<Diagnostic<? extends JavaFileObject>> errors) {
        Log log = Log.instance(jti.getContext());
        JavaFileObject prev = log.useSource(new DummyJFO());
        DiagnosticListener oldDiag = log.getDiagnosticListener();
        int origNErrors = log.nerrors;
        int origNWarnings = log.nwarnings;
        boolean origDeferDiagnostic = log.deferDiagnostics;
        log.deferDiagnostics = false;
        log.setDiagnosticListener(new DiagnosticListenerImpl(errors));
        try {
            Attr attr = Attr.instance(jti.getContext());
            Env<AttrContext> env = ((JavacScope)scope).getEnv();
            if (tree instanceof JCTree.JCExpression) {
                Type type = attr.attribExpr((JCTree)tree, env, Type.noType);
                return type;
            }
            Type type = attr.attribStat((JCTree)tree, env);
            return type;
        }
        finally {
            log.useSource(prev);
            log.setDiagnosticListener(oldDiag);
            log.nerrors = origNErrors;
            log.nwarnings = origNWarnings;
            log.deferDiagnostics = origDeferDiagnostic;
        }
    }

    @CheckForNull
    public static CharSequence getWildcardTreeName(@NonNull Tree t) {
        IdentifierTree identTree;
        String name;
        if (t.getKind() == Tree.Kind.EXPRESSION_STATEMENT && ((ExpressionStatementTree)t).getExpression().getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree identTree2 = (IdentifierTree)((ExpressionStatementTree)t).getExpression();
            return identTree2.getName().toString();
        }
        if (t.getKind() == Tree.Kind.IDENTIFIER && (name = (identTree = (IdentifierTree)t).getName().toString()).startsWith("$")) {
            return name;
        }
        return null;
    }

    public static boolean isMultistatementWildcard(@NonNull CharSequence name) {
        return name.charAt(name.length() - 1) == '$';
    }

    public static boolean isMultistatementWildcardTree(Tree tree) {
        CharSequence name = Utilities.getWildcardTreeName(tree);
        return name != null && Utilities.isMultistatementWildcard(name);
    }

    public static Scope constructScope(CompilationInfo info, Map<String, TypeMirror> constraints) {
        return Utilities.constructScope(info, constraints, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scope constructScope(CompilationInfo info, Map<String, TypeMirror> constraints, Iterable<? extends String> auxiliaryImports) {
        StringBuilder clazz = new StringBuilder();
        clazz.append("package $;");
        for (String string : auxiliaryImports) {
            clazz.append(string);
        }
        long count = inc++;
        clazz.append("public class $" + count + "{");
        for (Map.Entry<String, TypeMirror> e : constraints.entrySet()) {
            if (e.getValue() == null) continue;
            clazz.append("private ");
            clazz.append(((Object)e.getValue()).toString());
            clazz.append(" ");
            clazz.append(e.getKey());
            clazz.append(";\n");
        }
        clazz.append("private void test() {\n");
        clazz.append("}\n");
        clazz.append("}\n");
        JavacTaskImpl jti = JavaSourceAccessor.getINSTANCE().getJavacTask(info);
        Context context = jti.getContext();
        JavaCompiler compiler = JavaCompiler.instance(context);
        Log log = Log.instance(context);
        int origNErrors = log.nerrors;
        int origNWarnings = log.nwarnings;
        boolean origDeferDiagnostic = compiler.log.deferDiagnostics;
        compiler.log.deferDiagnostics = false;
        log.nerrors = 0;
        InferableJavaFileObject jfo = FileObjects.memoryFileObject((CharSequence)"$", (CharSequence)"$", (URI)new File("/tmp/$" + count + ".java").toURI(), (long)System.currentTimeMillis(), (CharSequence)clazz.toString());
        DiagnosticListener old = log.getDiagnosticListener();
        boolean oldSkipAPs = compiler.skipAnnotationProcessing;
        DiagnosticCollector dc = new DiagnosticCollector();
        try {
            log.setDiagnosticListener(dc);
            compiler.skipAnnotationProcessing = true;
            JCTree.JCCompilationUnit cut = compiler.parse((JavaFileObject)jfo);
            compiler.enterTrees(List.of(cut));
            Todo todo = compiler.todo;
            ListBuffer<Env> defer = ListBuffer.lb();
            while (todo.peek() != null) {
                Env env = (Env)todo.remove();
                if (env.toplevel == cut) {
                    compiler.attribute(env);
                    continue;
                }
                defer = defer.append(env);
            }
            todo.addAll(defer);
            Scope scope = (Scope)new ScannerImpl().scan(cut, info);
            return scope;
        }
        finally {
            log.setDiagnosticListener(old);
            log.nerrors = origNErrors;
            log.nwarnings = origNWarnings;
            log.deferDiagnostics = origDeferDiagnostic;
            compiler.skipAnnotationProcessing = oldSkipAPs;
        }
    }

    public static String toHumanReadableTime(double d) {
        StringBuilder result = new StringBuilder();
        long inSeconds = (long)(d / 1000.0);
        int seconds = (int)(inSeconds % 60L);
        long inMinutes = inSeconds / 60L;
        int minutes = (int)(inMinutes % 60L);
        long inHours = inMinutes / 60L;
        if (inHours > 0L) {
            result.append(inHours);
            result.append("h");
        }
        if (minutes > 0) {
            result.append(minutes);
            result.append("m");
        }
        result.append(seconds);
        result.append("s");
        return result.toString();
    }

    public static ClasspathInfo createUniversalCPInfo() {
        return ((SPI)Lookup.getDefault().lookup(SPI.class)).createUniversalCPInfo();
    }

    public static void waitScanFinished() throws InterruptedException {
        SourceUtils.waitScanFinished();
    }

    public static Set<? extends String> findSuppressedWarnings(CompilationInfo info, TreePath path) {
        HashSet<String> keys = new HashSet<String>();
        while (path != null) {
            Tree leaf = path.getLeaf();
            switch (leaf.getKind()) {
                case METHOD: {
                    Utilities.handleSuppressWarnings(info, path, ((MethodTree)leaf).getModifiers(), keys);
                    break;
                }
                case CLASS: {
                    Utilities.handleSuppressWarnings(info, path, ((ClassTree)leaf).getModifiers(), keys);
                    break;
                }
                case VARIABLE: {
                    Utilities.handleSuppressWarnings(info, path, ((VariableTree)leaf).getModifiers(), keys);
                }
            }
            path = path.getParentPath();
        }
        return Collections.unmodifiableSet(keys);
    }

    private static void handleSuppressWarnings(CompilationInfo info, TreePath path, ModifiersTree modifiers, final Set<String> keys) {
        Element el = info.getTrees().getElement(path);
        if (el == null) {
            return;
        }
        for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
            javax.lang.model.element.Name fqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals("java.lang.SuppressWarnings")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().contentEquals("value")) continue;
                e.getValue().accept(new AnnotationValueVisitor<Void, Void>(){

                    @Override
                    public Void visit(AnnotationValue av, Void p) {
                        av.accept(this, p);
                        return null;
                    }

                    @Override
                    public Void visit(AnnotationValue av) {
                        av.accept(this, null);
                        return null;
                    }

                    @Override
                    public Void visitBoolean(boolean b, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitByte(byte b, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitChar(char c, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitDouble(double d, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitFloat(float f, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitInt(int i, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitLong(long i, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitShort(short s, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitString(String s, Void p) {
                        keys.add(s);
                        return null;
                    }

                    @Override
                    public Void visitType(TypeMirror t, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitEnumConstant(VariableElement c, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitAnnotation(AnnotationMirror a, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitArray(java.util.List<? extends AnnotationValue> vals, Void p) {
                        for (AnnotationValue annotationValue : vals) {
                            annotationValue.accept(this, p);
                        }
                        return null;
                    }

                    @Override
                    public Void visitUnknown(AnnotationValue av, Void p) {
                        return null;
                    }
                }, null);
            }
        }
    }

    public static Tree generalizePattern(CompilationInfo info, TreePath original) {
        return Utilities.generalizePattern(JavaSourceAccessor.getINSTANCE().getJavacTask(info), original);
    }

    public static Tree generalizePattern(JavaCompiler.CompilationTask task, TreePath original) {
        JavacTaskImpl jti = (JavacTaskImpl)task;
        Context c = jti.getContext();
        TreeFactory make = TreeFactory.instance((Context)c);
        Trees javacTrees = Trees.instance(task);
        GeneralizePattern gp = new GeneralizePattern(javacTrees, make);
        gp.scan(original, null);
        GeneralizePatternITT itt = new GeneralizePatternITT(gp.tree2Variable);
        itt.attach(c, new NoImports(c), null);
        return itt.translate(original.getLeaf());
    }

    public static Tree generalizePattern(CompilationInfo info, TreePath original, int firstStatement, int lastStatement) {
        JavacTaskImpl jti = JavaSourceAccessor.getINSTANCE().getJavacTask(info);
        Context c = jti.getContext();
        TreeFactory make = TreeFactory.instance((Context)c);
        Tree translated = Utilities.generalizePattern(jti, original);
        assert (translated.getKind() == Tree.Kind.BLOCK);
        LinkedList<? extends StatementTree> newStatements = new LinkedList<StatementTree>();
        BlockTree block = (BlockTree)translated;
        if (firstStatement != lastStatement) {
            newStatements.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$s0$")));
            newStatements.addAll(block.getStatements().subList(firstStatement, lastStatement + 1));
            newStatements.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$s1$")));
            translated = make.Block(newStatements, block.isStatic());
        } else {
            translated = block.getStatements().get(firstStatement);
        }
        return translated;
    }

    public static long patternValue(Tree pattern) {
        class VisitorImpl
        extends TreeScanner<Void, Void> {
            private int value;

            VisitorImpl() {
            }

            @Override
            public Void scan(Tree node, Void p) {
                if (node != null) {
                    ++this.value;
                }
                return (Void)super.scan(node, p);
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                if (node.getName().toString().startsWith("$")) {
                    --this.value;
                }
                return (Void)super.visitIdentifier(node, p);
            }

            @Override
            public Void visitNewClass(NewClassTree node, Void p) {
                return null;
            }
        }
        VisitorImpl vi = new VisitorImpl();
        vi.scan(pattern, null);
        return vi.value;
    }

    public static boolean containsMultistatementTrees(java.util.List<? extends Tree> statements) {
        for (Tree tree : statements) {
            if (!Utilities.isMultistatementWildcardTree(tree)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJavadocSupported(CompilationInfo info) {
        Context c = JavaSourceAccessor.getINSTANCE().getJavacTask(info).getContext();
        try {
            return c.get(Log.logKey) instanceof Messager;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static java.util.List<? extends Tree> filterHidden(TreePath basePath, Iterable<? extends Tree> members) {
        LinkedList<Tree> result = new LinkedList<Tree>();
        for (Tree tree : members) {
            if (Utilities.isSynthetic(basePath != null ? basePath.getCompilationUnit() : null, tree)) continue;
            result.add(tree);
        }
        return result;
    }

    private static boolean isSynthetic(CompilationUnitTree cut, Tree leaf) throws NullPointerException {
        IdentifierTree it;
        MethodInvocationTree mit;
        ExpressionStatementTree est;
        JCTree tree = (JCTree)leaf;
        if (tree.pos == -1) {
            return true;
        }
        if (leaf.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)leaf).mods.flags & 0x1000000000L) != 0L;
        }
        if (cut != null && leaf.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (est = (ExpressionStatementTree)leaf).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (mit = (MethodInvocationTree)est.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((it = (IdentifierTree)mit.getMethodSelect()).getName().toString())) {
            return (Integer)((JCTree.JCCompilationUnit)cut).endPositions.get(tree) == -1;
        }
        return false;
    }

    public static boolean isFakeBlock(Tree t) {
        if (!(t instanceof BlockTree)) {
            return false;
        }
        BlockTree bt = (BlockTree)t;
        if (bt.getStatements().isEmpty()) {
            return false;
        }
        CharSequence wildcardTreeName = Utilities.getWildcardTreeName(bt.getStatements().get(0));
        if (wildcardTreeName == null) {
            return false;
        }
        return ((Object)wildcardTreeName).toString().startsWith("$$");
    }

    public static boolean isFakeClass(Tree t) {
        if (!(t instanceof ClassTree)) {
            return false;
        }
        ClassTree ct = (ClassTree)t;
        if (ct.getMembers().isEmpty()) {
            return false;
        }
        CharSequence wildcardTreeName = Utilities.getWildcardTreeName(ct.getMembers().get(0));
        if (wildcardTreeName == null) {
            return false;
        }
        return ((Object)wildcardTreeName).toString().startsWith("$$");
    }

    private static class ParserSourcePositions
    implements SourcePositions {
        private JavacParser parser;

        private ParserSourcePositions(JavacParser parser) {
            this.parser = parser;
        }

        @Override
        public long getStartPosition(CompilationUnitTree file, Tree tree) {
            return this.parser.getStartPos((JCTree)tree);
        }

        @Override
        public long getEndPosition(CompilationUnitTree file, Tree tree) {
            return this.parser.getEndPos((JCTree)tree);
        }
    }

    private static final class OffsetDiagnostic<S>
    implements Diagnostic<S> {
        private final Diagnostic<? extends S> delegate;
        private final long offset;

        public OffsetDiagnostic(Diagnostic<? extends S> delegate, long offset) {
            this.delegate = delegate;
            this.offset = offset;
        }

        @Override
        public Diagnostic.Kind getKind() {
            return this.delegate.getKind();
        }

        @Override
        public S getSource() {
            return this.delegate.getSource();
        }

        @Override
        public long getPosition() {
            return this.delegate.getPosition() + this.offset;
        }

        @Override
        public long getStartPosition() {
            return this.delegate.getStartPosition() + this.offset;
        }

        @Override
        public long getEndPosition() {
            return this.delegate.getEndPosition() + this.offset;
        }

        @Override
        public long getLineNumber() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public long getColumnNumber() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getCode() {
            return this.delegate.getCode();
        }

        @Override
        public String getMessage(Locale locale) {
            return this.delegate.getMessage(locale);
        }
    }

    private static final class OffsetSourcePositions
    implements SourcePositions {
        private final SourcePositions delegate;
        private final long offset;

        public OffsetSourcePositions(SourcePositions delegate, long offset) {
            this.delegate = delegate;
            this.offset = offset;
        }

        @Override
        public long getStartPosition(CompilationUnitTree cut, Tree tree) {
            return this.delegate.getStartPosition(cut, tree) + this.offset;
        }

        @Override
        public long getEndPosition(CompilationUnitTree cut, Tree tree) {
            return this.delegate.getEndPosition(cut, tree) + this.offset;
        }
    }

    private static final class DiagnosticListenerImpl
    implements DiagnosticListener<JavaFileObject> {
        private final Collection<Diagnostic<? extends JavaFileObject>> errors;

        public DiagnosticListenerImpl(Collection<Diagnostic<? extends JavaFileObject>> errors) {
            this.errors = errors;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.errors.add(diagnostic);
        }
    }

    private static final class DummyJFO
    extends SimpleJavaFileObject {
        private DummyJFO() {
            super(URI.create("dummy.java"), JavaFileObject.Kind.SOURCE);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return "";
        }
    }

    private static final class PushbackLexer
    implements Lexer {
        private final Lexer delegate;
        private final java.util.List<Token> tokenBuffer;
        private final java.util.List<Integer> posBuffer;
        private final java.util.List<Name> nameBuffer;
        private Token currentBufferToken;
        private int currentBufferPos;
        private Name currentBufferName;

        public PushbackLexer(Lexer delegate) {
            this.delegate = delegate;
            this.tokenBuffer = new LinkedList<Token>();
            this.posBuffer = new LinkedList<Integer>();
            this.nameBuffer = new LinkedList<Name>();
        }

        public void add(Token token, int pos, Name name) {
            this.tokenBuffer.add(token);
            this.posBuffer.add(pos);
            this.nameBuffer.add(name);
        }

        public void token(Token token) {
            this.delegate.token(token);
        }

        public Token token() {
            if (this.currentBufferToken != null) {
                return this.currentBufferToken;
            }
            return this.delegate.token();
        }

        public String stringVal() {
            if (this.currentBufferToken != null) {
                return this.currentBufferName != null ? this.currentBufferName.toString() : null;
            }
            return this.delegate.stringVal();
        }

        public void resetDeprecatedFlag() {
            this.delegate.resetDeprecatedFlag();
        }

        public int radix() {
            return this.delegate.radix();
        }

        public int prevEndPos() {
            return this.delegate.prevEndPos();
        }

        public int pos() {
            if (this.currentBufferToken != null) {
                return this.currentBufferPos;
            }
            return this.delegate.pos();
        }

        @Override
        public void nextToken() {
            if (!this.tokenBuffer.isEmpty()) {
                this.currentBufferToken = this.tokenBuffer.remove(0);
                this.currentBufferPos = this.posBuffer.remove(0);
                this.currentBufferName = this.nameBuffer.remove(0);
            } else {
                this.delegate.nextToken();
            }
        }

        public Name name() {
            if (this.currentBufferToken != null) {
                return this.currentBufferName;
            }
            return this.delegate.name();
        }

        public char[] getRawCharacters(int beginIndex, int endIndex) {
            return this.delegate.getRawCharacters(beginIndex, endIndex);
        }

        public char[] getRawCharacters() {
            return this.delegate.getRawCharacters();
        }

        @Override
        public Position.LineMap getLineMap() {
            return this.delegate.getLineMap();
        }

        @Override
        public void errPos(int pos) {
            this.delegate.errPos(pos);
        }

        @Override
        public int errPos() {
            return this.delegate.errPos();
        }

        public int endPos() {
            return this.delegate.endPos();
        }

        public String docComment() {
            return this.delegate.docComment();
        }

        public boolean deprecatedFlag() {
            return this.delegate.deprecatedFlag();
        }
    }

    private static class JackpotJavacParser
    extends EndPosParser {
        private final Context ctx;

        public JackpotJavacParser(Context ctx, ParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, CancelService cancelService, Names names) {
            super(fac, (Lexer)new PushbackLexer(S), keepDocComments, keepLineMap, cancelService);
            this.ctx = ctx;
        }

        protected JCTree.JCModifiers modifiersOpt(JCTree.JCModifiers partial) {
            String ident;
            if (this.S.token() == Token.IDENTIFIER && Utilities.isMultistatementWildcard(ident = this.S.stringVal())) {
                Name name = this.S.name();
                this.S.nextToken();
                return new JackpotTrees.ModifiersWildcard(name, this.F.Ident(name));
            }
            return super.modifiersOpt(partial);
        }

        protected JCTree.JCVariableDecl formalParameter() {
            String ident;
            if (this.S.token() == Token.IDENTIFIER && (ident = this.S.stringVal()).startsWith("$")) {
                Name name = this.S.name();
                this.S.nextToken();
                return new JackpotTrees.VariableWildcard(this.ctx, name, this.F.Ident(name));
            }
            return super.formalParameter();
        }

        protected JCTree.JCCatch catchClause() {
            if (this.S.token() == Token.CATCH) {
                int origPos = this.S.pos();
                this.S.nextToken();
                Token peeked = this.S.token();
                String ident = this.S.stringVal();
                if (peeked == Token.IDENTIFIER && Utilities.isMultistatementWildcard(ident)) {
                    this.accept(Token.CATCH);
                    Name name = this.S.name();
                    this.accept(Token.IDENTIFIER);
                    return new JackpotTrees.CatchWildcard(this.ctx, name, this.F.Ident(name));
                }
                ((PushbackLexer)this.S).add(Token.CATCH, origPos, null);
                ((PushbackLexer)this.S).add(null, -1, null);
                this.S.nextToken();
            }
            return super.catchClause();
        }

        public List<JCTree> classOrInterfaceBodyDeclaration(Name className, boolean isInterface) {
            if (this.S.token() == Token.IDENTIFIER) {
                int identPos = this.S.pos();
                String ident = this.S.stringVal();
                if (ident.startsWith("$")) {
                    Name name = this.S.name();
                    this.S.nextToken();
                    if (this.S.token() == Token.SEMI) {
                        this.S.nextToken();
                        return List.of(this.F.Ident(name));
                    }
                    ((PushbackLexer)this.S).add(Token.IDENTIFIER, identPos, name);
                    ((PushbackLexer)this.S).add(null, -1, null);
                    this.S.nextToken();
                }
            }
            return super.classOrInterfaceBodyDeclaration(className, isInterface);
        }

        protected JCTree.JCExpression checkExprStat(JCTree.JCExpression t) {
            if (t.getTag() == 35 && ((IdentifierTree)((Object)t)).getName().toString().startsWith("$")) {
                return t;
            }
            return super.checkExprStat(t);
        }

        protected JCTree.JCCase switchBlockStatementGroup() {
            if (this.S.token() == Token.CASE) {
                String ident;
                int origPos = this.S.pos();
                this.S.nextToken();
                if (this.S.token() == Token.IDENTIFIER && (ident = this.S.stringVal()).startsWith("$") && ident.endsWith("$")) {
                    int pos = this.S.pos();
                    Name name = this.S.name();
                    this.S.nextToken();
                    if (this.S.token() == Token.SEMI) {
                        this.S.nextToken();
                    }
                    return new JackpotTrees.CaseWildcard(this.ctx, name, this.F.at(pos).Ident(name));
                }
                ((PushbackLexer)this.S).add(Token.CASE, origPos, null);
                ((PushbackLexer)this.S).add(null, -1, null);
                this.S.nextToken();
            }
            return super.switchBlockStatementGroup();
        }

        protected JCTree resource() {
            char[] maybeSemicolon;
            if (this.S.token() == Token.IDENTIFIER && this.S.stringVal().startsWith("$") && ((maybeSemicolon = this.S.getRawCharacters(this.S.endPos(), this.S.endPos() + 1))[0] == ';' || maybeSemicolon[0] == ')')) {
                int pos = this.S.pos();
                Name name = this.S.name();
                this.S.nextToken();
                return this.F.at(pos).Ident(name);
            }
            return super.resource();
        }
    }

    private static final class NoImports
    extends ImportAnalysis2 {
        public NoImports(Context env) {
            super(env);
        }

        public void classEntered(ClassTree clazz) {
        }

        public void classLeft() {
        }

        public ExpressionTree resolveImport(MemberSelectTree orig, Element element) {
            return orig;
        }

        public void setCompilationUnit(CompilationUnitTree cut) {
        }

        public void setImports(java.util.List<? extends ImportTree> importsToAdd) {
        }

        public Set<? extends Element> getImports() {
            return Collections.emptySet();
        }

        public void setPackage(ExpressionTree packageNameTree) {
        }
    }

    private static final class GeneralizePatternITT
    extends ImmutableTreeTranslator {
        private final Map<Tree, Tree> tree2Variable;

        public GeneralizePatternITT(Map<Tree, Tree> tree2Variable) {
            super(null);
            this.tree2Variable = tree2Variable;
        }

        public Tree translate(Tree tree) {
            Tree var = this.tree2Variable.remove(tree);
            if (var != null) {
                return super.translate(var);
            }
            return super.translate(tree);
        }
    }

    private static final class GeneralizePattern
    extends TreePathScanner<Void, Void> {
        public final Map<Tree, Tree> tree2Variable = new HashMap<Tree, Tree>();
        private final Map<Element, String> element2Variable = new HashMap<Element, String>();
        private final Trees javacTrees;
        private final TreeFactory make;
        private int currentVariableIndex = 0;

        public GeneralizePattern(Trees javacTrees, TreeFactory make) {
            this.javacTrees = javacTrees;
            this.make = make;
        }

        @NonNull
        private String getVariable(@NonNull Element el) {
            String var = this.element2Variable.get(el);
            if (var == null) {
                var = "$" + this.currentVariableIndex++;
                this.element2Variable.put(el, var);
            }
            return var;
        }

        private boolean shouldBeGeneralized(@NonNull Element el) {
            if (el.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return true;
            }
            switch (el.getKind()) {
                case LOCAL_VARIABLE: 
                case EXCEPTION_PARAMETER: 
                case PARAMETER: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void p) {
            Element e = this.javacTrees.getElement(this.getCurrentPath());
            if (e != null && this.shouldBeGeneralized(e)) {
                this.tree2Variable.put(node, this.make.Identifier((CharSequence)this.getVariable(e)));
            }
            return (Void)super.visitIdentifier(node, p);
        }

        @Override
        public Void visitVariable(VariableTree node, Void p) {
            Element e = this.javacTrees.getElement(this.getCurrentPath());
            if (e != null && this.shouldBeGeneralized(e)) {
                VariableTree nue = this.make.Variable(node.getModifiers(), (CharSequence)this.getVariable(e), node.getType(), node.getInitializer());
                this.tree2Variable.put(node, nue);
            }
            return (Void)super.visitVariable(node, p);
        }

        @Override
        public Void visitNewClass(NewClassTree node, Void p) {
            java.util.List<? extends ExpressionTree> arguments = node.getArguments();
            if (!arguments.isEmpty() && arguments.get(0).getKind() == Tree.Kind.OTHER) {
                this.tree2Variable.put(node, this.make.Identifier((CharSequence)("$" + this.currentVariableIndex++)));
                return null;
            }
            NewClassTree nue = this.make.NewClass(node.getEnclosingExpression(), Collections.singletonList(this.make.Identifier((CharSequence)("$" + this.currentVariableIndex++ + "$"))), (ExpressionTree)this.make.Identifier((CharSequence)("$" + this.currentVariableIndex++)), Collections.singletonList(this.make.Identifier((CharSequence)("$" + this.currentVariableIndex++ + "$"))), null);
            this.tree2Variable.put(node, nue);
            return null;
        }
    }

    public static final class NbSPIImpl
    implements SPI {
        @Override
        public ClasspathInfo createUniversalCPInfo() {
            JavaPlatform select = JavaPlatform.getDefault();
            if (select.getSpecification().getVersion() != null) {
                for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                    if (!"j2se".equals(p.getSpecification().getName()) || p.getSpecification().getVersion() == null || p.getSpecification().getVersion().compareTo((Object)select.getSpecification().getVersion()) <= 0) continue;
                    select = p;
                }
            }
            return ClasspathInfo.create((ClassPath)select.getBootstrapLibraries(), (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY);
        }
    }

    public static interface SPI {
        public ClasspathInfo createUniversalCPInfo();
    }

    private static final class ScannerImpl
    extends TreePathScanner<Scope, CompilationInfo> {
        private ScannerImpl() {
        }

        @Override
        public Scope visitBlock(BlockTree node, CompilationInfo p) {
            return p.getTrees().getScope(this.getCurrentPath());
        }

        @Override
        public Scope visitMethod(MethodTree node, CompilationInfo p) {
            if (node.getReturnType() == null) {
                return null;
            }
            return (Scope)super.visitMethod(node, p);
        }

        @Override
        public Scope reduce(Scope r1, Scope r2) {
            return r1 != null ? r1 : r2;
        }
    }
}

