/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.batch;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;

public final class ProgressHandleWrapper {
    private static final int TOTAL = 1000;
    private final ProgressHandleAbstraction handle;
    private final int[] parts;
    private int currentPart = -1;
    private int currentPartTotalWork;
    private int currentPartWorkDone;
    private long currentPartStartTime;
    private int currentOffset;
    private final long[] spentTime;
    private boolean debug;

    public ProgressHandleWrapper(int ... parts) {
        this((ProgressHandleAbstraction)null, parts);
    }

    public ProgressHandleWrapper(ProgressHandle handle, int ... parts) {
        this(new ProgressHandleBasedProgressHandleAbstraction(handle), parts);
    }

    public ProgressHandleWrapper(ProgressHandleAbstraction handle, int ... parts) {
        this.handle = handle;
        if (handle == null) {
            this.parts = null;
            this.spentTime = null;
        } else {
            int total = 0;
            for (int i : parts) {
                total += i;
            }
            this.parts = new int[parts.length];
            for (int cntr = 0; cntr < parts.length; ++cntr) {
                this.parts[cntr] = 1000 * parts[cntr] / total;
            }
            this.spentTime = new long[parts.length];
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void startNextPart(int totalWork) {
        if (this.handle == null) {
            return;
        }
        if (this.currentPart == -1) {
            this.handle.start(1000);
        } else {
            this.currentOffset += this.parts[this.currentPart];
            this.spentTime[this.currentPart] = System.currentTimeMillis() - this.currentPartStartTime;
        }
        ++this.currentPart;
        this.currentPartTotalWork = totalWork;
        this.currentPartWorkDone = 0;
        this.currentPartStartTime = System.currentTimeMillis();
        this.currentPartWorkDoneUpdated();
    }

    public ProgressHandleWrapper startNextPartWithEmbedding(int ... embeddedParts) {
        return new ProgressHandleWrapper(new ProgressHandleWrapperBasedProgressHandleAbstraction(this), embeddedParts);
    }

    public void tick() {
        if (this.handle == null) {
            return;
        }
        ++this.currentPartWorkDone;
        this.currentPartWorkDoneUpdated();
    }

    private void setCurrentPartWorkDone(int done) {
        if (this.handle == null) {
            return;
        }
        this.currentPartWorkDone = done;
        this.currentPartWorkDoneUpdated();
    }

    private void currentPartWorkDoneUpdated() {
        if (this.currentPartTotalWork > 0) {
            int parentProgress = this.currentOffset + this.parts[this.currentPart] * this.currentPartWorkDone / this.currentPartTotalWork;
            if (this.debug) {
                System.err.println("currentOffset=" + this.currentOffset);
                System.err.println("currentPart=" + this.currentPart);
                System.err.println("parts[currentPart]= " + this.parts[this.currentPart]);
                System.err.println("currentPartWorkDone=" + this.currentPartWorkDone);
                System.err.println("currentPartTotalWork= " + this.currentPartTotalWork);
                System.err.println("parentProgress=" + parentProgress);
            }
            this.handle.progress(parentProgress);
        } else {
            this.handle.progress(this.currentOffset + this.parts[this.currentPart]);
        }
        this.setAutomatedMessage();
    }

    public void setMessage(String message) {
        if (this.handle == null) {
            return;
        }
        this.handle.progress(message);
    }

    private void setAutomatedMessage() {
        String timeString;
        if (this.handle == null || this.currentPart == -1) {
            return;
        }
        long spentTime = System.currentTimeMillis() - this.currentPartStartTime;
        double timePerUnit = (double)spentTime / (double)this.currentPartWorkDone;
        if (spentTime > 0L) {
            double totalTime = (double)this.currentPartTotalWork * timePerUnit;
            timeString = Utilities.toHumanReadableTime(spentTime) + "/" + Utilities.toHumanReadableTime(totalTime);
        } else {
            timeString = "No estimate";
        }
        this.handle.progress("Part " + (this.currentPart + 1) + "/" + this.parts.length + ", " + this.currentPartWorkDone + "/" + this.currentPartTotalWork + ", " + timeString);
    }

    public void finish() {
        if (this.handle == null) {
            return;
        }
        this.handle.finish();
        if (this.currentPart < 0) {
            return;
        }
        this.spentTime[this.currentPart] = System.currentTimeMillis() - this.currentPartStartTime;
        double total = 0.0;
        for (long t : this.spentTime) {
            total += (double)t;
        }
        double[] actualSplit = new double[this.spentTime.length];
        int i = 0;
        for (long t : this.spentTime) {
            actualSplit[i++] = 1000.0 * ((double)t / total);
        }
        Logger.getLogger(ProgressHandleWrapper.class.getName()).log(Level.INFO, "Progress handle with split: {0}, actual times: {1}, actual split: {2}", new Object[]{Arrays.toString(this.parts), Arrays.toString(this.spentTime), Arrays.toString(actualSplit)});
    }

    public static int[] prepareParts(int count) {
        int[] result = new int[count];
        for (int cntr = 0; cntr < count; ++cntr) {
            result[cntr] = 1;
        }
        return result;
    }

    private static final class ProgressHandleWrapperBasedProgressHandleAbstraction
    implements ProgressHandleAbstraction {
        private final ProgressHandleWrapper delegate;

        public ProgressHandleWrapperBasedProgressHandleAbstraction(ProgressHandleWrapper delegate) {
            this.delegate = delegate;
        }

        @Override
        public void start(int totalWork) {
            this.delegate.startNextPart(totalWork);
        }

        @Override
        public void progress(int currentWorkDone) {
            this.delegate.setCurrentPartWorkDone(currentWorkDone);
        }

        @Override
        public void progress(String message) {
            this.delegate.setMessage(message);
        }

        @Override
        public void finish() {
        }
    }

    private static final class ProgressHandleBasedProgressHandleAbstraction
    implements ProgressHandleAbstraction {
        private final ProgressHandle delegate;

        public ProgressHandleBasedProgressHandleAbstraction(ProgressHandle delegate) {
            this.delegate = delegate;
        }

        @Override
        public void start(int totalWork) {
            this.delegate.start(totalWork);
        }

        @Override
        public void progress(int currentWorkDone) {
            this.delegate.progress(currentWorkDone);
        }

        @Override
        public void progress(String message) {
            this.delegate.progress(message);
        }

        @Override
        public void finish() {
            this.delegate.finish();
        }
    }

    public static interface ProgressHandleAbstraction {
        public void start(int var1);

        public void progress(int var1);

        public void progress(String var1);

        public void finish();
    }
}

