/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.Trigger;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Lookup;

public abstract class PatternConvertor {
    @CheckForNull
    protected abstract Iterable<? extends HintDescription> parseString(@NonNull String var1);

    @CheckForNull
    public static Iterable<? extends HintDescription> create(@NonNull String code) {
        ArrayList<String> patterns = new ArrayList<String>();
        if (code.contains(";;")) {
            PatternConvertor c = (PatternConvertor)Lookup.getDefault().lookup(PatternConvertor.class);
            if (c != null) {
                return c.parseString(code);
            }
            for (String s : code.split(";;")) {
                if ((s = s.trim()).isEmpty()) continue;
                patterns.add(s);
            }
        } else {
            patterns.add(code);
        }
        ArrayList<HintDescription> result = new ArrayList<HintDescription>(patterns.size());
        for (String pattern : patterns) {
            Trigger.PatternDescription pd = Trigger.PatternDescription.create(pattern, Collections.<String, String>emptyMap(), new String[0]);
            HintDescription desc = HintDescriptionFactory.create().setTrigger(pd).setWorker(new WorkerImpl()).produce();
            result.add(desc);
        }
        return result;
    }

    private static final class WorkerImpl
    implements HintDescription.Worker {
        private WorkerImpl() {
        }

        @Override
        public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
            ErrorDescription ed = ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), "Found pattern occurrence", new Fix[0]);
            return Collections.singleton(ed);
        }
    }
}

