/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi.support;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.java.hints.jackpot.impl.SyntheticFix;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ErrorDescriptionFactory {
    private ErrorDescriptionFactory() {
    }

    public static ErrorDescription forTree(HintContext context, TreePath tree, String text, Fix ... fixes) {
        return ErrorDescriptionFactory.forTree(context, tree.getLeaf(), text, fixes);
    }

    public static ErrorDescription forTree(HintContext context, Tree tree, String text, Fix ... fixes) {
        int start = (int)context.getInfo().getTrees().getSourcePositions().getStartPosition(context.getInfo().getCompilationUnit(), tree);
        int end = (int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree);
        if (start != -1 && end != -1) {
            List<Fix> fixesForED = ErrorDescriptionFactory.resolveDefaultFixes(context, fixes);
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((Severity)context.getSeverity().toEditorSeverity(), (String)text, fixesForED, (FileObject)context.getInfo().getFileObject(), (int)start, (int)end);
        }
        return null;
    }

    public static ErrorDescription forName(HintContext context, TreePath tree, String text, Fix ... fixes) {
        return ErrorDescriptionFactory.forName(context, tree.getLeaf(), text, fixes);
    }

    public static ErrorDescription forName(HintContext context, Tree tree, String text, Fix ... fixes) {
        int[] span = ErrorDescriptionFactory.computeNameSpan(tree, context);
        if (span != null && span[0] != -1 && span[1] != -1) {
            List<Fix> fixesForED = ErrorDescriptionFactory.resolveDefaultFixes(context, fixes);
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((Severity)context.getSeverity().toEditorSeverity(), (String)text, fixesForED, (FileObject)context.getInfo().getFileObject(), (int)span[0], (int)span[1]);
        }
        return null;
    }

    private static int[] computeNameSpan(Tree tree, HintContext context) {
        switch (tree.getKind()) {
            case METHOD: {
                return context.getInfo().getTreeUtilities().findNameSpan((MethodTree)tree);
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return context.getInfo().getTreeUtilities().findNameSpan((ClassTree)tree);
            }
            case VARIABLE: {
                return context.getInfo().getTreeUtilities().findNameSpan((VariableTree)tree);
            }
            case MEMBER_SELECT: {
                MemberSelectTree mst = (MemberSelectTree)tree;
                int[] span = context.getInfo().getTreeUtilities().findNameSpan(mst);
                if (span == null) {
                    int end = (int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree);
                    span = new int[]{end - mst.getIdentifier().length(), end};
                }
                return span;
            }
            case METHOD_INVOCATION: {
                return ErrorDescriptionFactory.computeNameSpan(((MethodInvocationTree)tree).getMethodSelect(), context);
            }
        }
        int start = (int)context.getInfo().getTrees().getSourcePositions().getStartPosition(context.getInfo().getCompilationUnit(), tree);
        if (StatementTree.class.isAssignableFrom(tree.getKind().asInterface()) && tree.getKind() != Tree.Kind.EXPRESSION_STATEMENT && tree.getKind() != Tree.Kind.BLOCK) {
            TokenSequence ts = context.getInfo().getTokenHierarchy().tokenSequence();
            ts.move(start);
            if (ts.moveNext()) {
                return new int[]{ts.offset(), ts.offset() + ts.token().length()};
            }
        }
        return new int[]{start, (int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree)};
    }

    public static List<Fix> resolveDefaultFixes(HintContext ctx, Fix ... provided) {
        LinkedList<Fix> auxiliaryFixes = new LinkedList<Fix>();
        if (ctx.getHintMetadata() != null) {
            LinkedHashSet<String> suppressWarningsKeys = new LinkedHashSet<String>();
            for (String string : ctx.getHintMetadata().suppressWarnings) {
                if (string == null || string.length() == 0) break;
                suppressWarningsKeys.add(string);
            }
            auxiliaryFixes.add(new DisableConfigure(ctx.getHintMetadata(), true));
            auxiliaryFixes.add(new DisableConfigure(ctx.getHintMetadata(), false));
            if (!suppressWarningsKeys.isEmpty()) {
                auxiliaryFixes.addAll(FixFactory.createSuppressWarnings(ctx.getInfo(), ctx.getPath(), suppressWarningsKeys.toArray(new String[0])));
            }
            LinkedList<Fix> result = new LinkedList<Fix>();
            for (Fix f : provided != null ? provided : new Fix[]{}) {
                if (f == null) continue;
                if (FixFactory.isSuppressWarningsFix(f)) {
                    Logger.getLogger(ErrorDescriptionFactory.class.getName()).log(Level.FINE, "Eliminated SuppressWarnings fix");
                    continue;
                }
                result.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes((Fix)f, auxiliaryFixes));
            }
            if (result.isEmpty()) {
                result.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes((Fix)new TopLevelConfigureFix(ctx.getHintMetadata()), auxiliaryFixes));
            }
            return result;
        }
        return Arrays.asList(provided);
    }

    private static final class TopLevelConfigureFix
    extends DisableConfigure
    implements EnhancedFix {
        public TopLevelConfigureFix(@NonNull HintMetadata metadata) {
            super(metadata, false);
        }

        public CharSequence getSortText() {
            return "\uffffzz";
        }
    }

    private static class DisableConfigure
    implements Fix,
    SyntheticFix {
        @NonNull
        private final HintMetadata metadata;
        private final boolean disable;

        DisableConfigure(@NonNull HintMetadata metadata, boolean disable) {
            this.metadata = metadata;
            this.disable = disable;
        }

        public String getText() {
            String key;
            String displayName = this.metadata.displayName;
            switch (this.metadata.kind) {
                case HINT: {
                    key = this.disable ? "FIX_DisableHint" : "FIX_ConfigureHint";
                    break;
                }
                case SUGGESTION: {
                    key = this.disable ? "FIX_DisableSuggestion" : "FIX_ConfigureSuggestion";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return NbBundle.getMessage(ErrorDescriptionFactory.class, (String)key, (Object)displayName);
        }

        public ChangeInfo implement() throws Exception {
            if (this.disable) {
                HintsSettings.setEnabled(this.metadata, false);
            } else {
                OptionsDisplayer.getDefault().open("Editor/Hints/text/x-java/" + this.metadata.id);
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DisableConfigure other = (DisableConfigure)obj;
            if (!(this.metadata == other.metadata || this.metadata != null && this.metadata.equals(other.metadata))) {
                return false;
            }
            return this.disable == other.disable;
        }

        public int hashCode() {
            int hash = 7;
            hash = 43 * hash + (this.metadata != null ? this.metadata.hashCode() : 0);
            hash = 43 * hash + (this.disable ? 1 : 0);
            return hash;
        }
    }
}

