/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Tiny {
    public static ErrorDescription flipEquals(HintContext ctx) {
        int selectEnd;
        int selectStart;
        int caret = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)ctx.getInfo().getFileObject());
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        ExpressionTree select = mit.getMethodSelect();
        switch (select.getKind()) {
            case MEMBER_SELECT: {
                int[] span = ctx.getInfo().getTreeUtilities().findNameSpan((MemberSelectTree)select);
                if (span == null) {
                    return null;
                }
                selectStart = span[0];
                selectEnd = span[1];
                break;
            }
            case IDENTIFIER: {
                selectStart = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), select);
                selectEnd = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), select);
                break;
            }
            default: {
                Logger.getLogger(Tiny.class.getName()).log(Level.FINE, "flipEquals: unexpected method select kind: {0}", (Object)select.getKind());
                return null;
            }
        }
        if (selectStart > caret || selectEnd < caret) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_flipEquals");
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_flipEquals");
        String fixPattern = ctx.getVariables().containsKey("$this") ? "$other.equals($this)" : "$other.equals(this)";
        Fix fix = JavaFix.rewriteFix(ctx, fixDisplayName, ctx.getPath(), fixPattern, new String[0]);
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, fix);
    }

    public static ErrorDescription convertToDifferentBase(HintContext ctx) {
        int start = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), ctx.getPath().getLeaf());
        int end = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), ctx.getPath().getLeaf());
        String code = ctx.getInfo().getText().substring(start, end);
        int currentRadix = 10;
        if (code.startsWith("0x") || code.startsWith("0X")) {
            currentRadix = 16;
        } else if (code.startsWith("0b") || code.startsWith("0B")) {
            currentRadix = 2;
        } else if (code.startsWith("0") || code.startsWith("0")) {
            currentRadix = 8;
        }
        LinkedList<Fix> fixes = new LinkedList<Fix>();
        if (currentRadix != 16) {
            fixes.add(JavaFix.toEditorFix(new ToDifferentRadixFixImpl(ctx.getInfo(), ctx.getPath(), "0x", 16)));
        }
        if (currentRadix != 10) {
            fixes.add(JavaFix.toEditorFix(new ToDifferentRadixFixImpl(ctx.getInfo(), ctx.getPath(), "", 10)));
        }
        if (currentRadix != 8) {
            fixes.add(JavaFix.toEditorFix(new ToDifferentRadixFixImpl(ctx.getInfo(), ctx.getPath(), "0", 8)));
        }
        if (currentRadix != 2 && ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) >= 0) {
            fixes.add(JavaFix.toEditorFix(new ToDifferentRadixFixImpl(ctx.getInfo(), ctx.getPath(), "0b", 2)));
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(Tiny.class, (String)"ERR_convertToDifferentBase"), fixes.toArray(new Fix[0]));
    }

    private static final class ToDifferentRadixFixImpl
    extends JavaFix {
        private final String prefix;
        private final int radix;

        public ToDifferentRadixFixImpl(CompilationInfo info, TreePath tp, String prefix, int radix) {
            super(info, tp);
            this.prefix = prefix;
            this.radix = radix;
        }

        @Override
        protected String getText() {
            return NbBundle.getMessage(Tiny.class, (String)("FIX_convertToDifferentBase_" + this.radix));
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath tp, boolean canShowUI) {
            String target;
            String suffix;
            LiteralTree leaf = (LiteralTree)tp.getLeaf();
            if (leaf.getKind() == Tree.Kind.INT_LITERAL) {
                suffix = "";
                int value = ((Number)leaf.getValue()).intValue();
                switch (this.radix) {
                    case 2: {
                        target = Integer.toBinaryString(value);
                        break;
                    }
                    case 8: {
                        target = Integer.toOctalString(value);
                        break;
                    }
                    case 10: {
                        target = Integer.toString(value);
                        break;
                    }
                    case 16: {
                        target = Integer.toHexString(value);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            } else if (leaf.getKind() == Tree.Kind.LONG_LITERAL) {
                int end = (int)wc.getTrees().getSourcePositions().getEndPosition(wc.getCompilationUnit(), leaf);
                suffix = wc.getText().substring(end - 1, end);
                long value = ((Number)leaf.getValue()).longValue();
                switch (this.radix) {
                    case 2: {
                        target = Long.toBinaryString(value);
                        break;
                    }
                    case 8: {
                        target = Long.toOctalString(value);
                        break;
                    }
                    case 10: {
                        target = Long.toString(value);
                        break;
                    }
                    case 16: {
                        target = Long.toHexString(value);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            } else {
                throw new IllegalStateException();
            }
            target = this.prefix + target + suffix;
            wc.rewrite((Tree)leaf, (Tree)wc.getTreeMaker().Identifier((CharSequence)target));
        }
    }
}

