/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.componentssupport.ui.IconUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.CustomComponentHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.ComponentProducerWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DocumentAdapter;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NewComponentDescriptor;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.PaletteCategory;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ComponentProducerVisualPanel
extends JPanel {
    private static final String MSG_ERR_CLASS_NAME_EMPTY = "MSG_CP_EmptyClassName";
    private static final String MSG_ERR_CLASS_NAME_INVALID = "MSG_CP_InvalidClassName";
    private static final String MSG_ERR_CLASS_NAME_EXISTS = "MSG_CP_ExistingClassName";
    private static final String MSG_ERR_PALETTE_DISP_NAME_EMPTY = "MSG_CP_EmptyPaletteDispName";
    private static final String MSG_ERR_LIB_NAME_EMPTY = "MSG_CP_EmptyLibName";
    private static final String MSG_ERR_SMALL_NOT_EXIST = "MSG_CP_SmallIconNotExist";
    private static final String MSG_ERR_LARGE_NOT_EXIST = "MSG_CP_LargeIconNotExist";
    private static final String LBL_SELECT = "LBL_Select";
    private static final String TXT_NONE = "TXT_NONE";
    private static final String NONE = ComponentProducerVisualPanel.getMessage("TXT_NONE", new Object[0]);
    private static final int ICON_LARGE_W = 32;
    private static final int ICON_LARGE_H = 32;
    private static final int ICON_SMALL_W = 16;
    private static final int ICON_SMALL_H = 16;
    private JCheckBox myCPAddLibDependencyChk;
    private JTextField myCPClassName;
    private JLabel myCPClassNameLabel;
    private JTextField myCPLargeIconPath;
    private JButton myCPLargeIconPathButton;
    private JLabel myCPLargeIconPathLabel;
    private JTextField myCPLibName;
    private JLabel myCPLibNameLabel;
    private JComboBox myCPPaletteCategoryCombo;
    private JLabel myCPPaletteCategoryLabel;
    private JTextField myCPPaletteDispName;
    private JLabel myCPPaletteDispNameLabel;
    private JTextField myCPPaletteTooltip;
    private JLabel myCPPaletteTooltipLabel;
    private JTextField myCPSmallIconPath;
    private JButton myCPSmallIconPathButton;
    private JLabel myCPSmallIconPathLabel;
    private JRadioButton myCPValidAlwaysRadio;
    private JRadioButton myCPValidCustomRadio;
    private JRadioButton myCPValidPlatformRadio;
    private JPanel myCompProducerPanel;
    private JPanel myLibNamePanel;
    private ButtonGroup myValidButtonGroup;
    private JPanel myValidityPanel;
    private WizardDescriptor mySettings;
    private ComponentProducerWizardPanel myPanel;
    private boolean isSmallIconUpdated;
    private boolean isLargeIconUpdated;
    private boolean isCPClassNameUpdated;
    private boolean listenersAttached;
    DocumentListener myDocListener;
    DocumentListener myClassNameListener;
    DocumentListener mySmallIconPathListener;
    DocumentListener myLargeIconPathListener;
    ActionListener myAddLibDependencyListener;

    ComponentProducerVisualPanel(ComponentProducerWizardPanel panel) {
        this.myPanel = panel;
        this.initComponents();
        this.myCPPaletteCategoryCombo.setModel(PaletteCategory.getComboBoxModel());
        this.myCPValidAlwaysRadio.setSelected(true);
        this.myDocListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
        this.myClassNameListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComponentProducerVisualPanel.this.isCPClassNameUpdated = true;
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
        this.mySmallIconPathListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComponentProducerVisualPanel.this.isSmallIconUpdated = true;
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
        this.myLargeIconPathListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComponentProducerVisualPanel.this.isLargeIconUpdated = true;
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
        this.myAddLibDependencyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentProducerVisualPanel.this.checkValidity();
            }
        };
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
        this.checkValidity();
    }

    @Override
    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    void storeData(WizardDescriptor descriptor) {
        descriptor.putProperty("compProdClassName", (Object)this.getClassNameValue());
        descriptor.putProperty("compProdPaletteDispName", (Object)this.getPaletteDispNameValue());
        descriptor.putProperty("compProdPaletteTip", (Object)this.getPaletteTooltipValue());
        descriptor.putProperty("compProdPaletteCategory", (Object)this.getPaletteCategoryValue());
        descriptor.putProperty("compProdSmallIcon", (Object)this.getSmallIconValue());
        descriptor.putProperty("compProdLargeIcon", (Object)this.getLargeIconValue());
        descriptor.putProperty("compProdAddLib", (Object)this.getAddLibraryValue());
        descriptor.putProperty("compProdLibName", (Object)this.getLibraryNameValue());
        descriptor.putProperty("compProdValidAlways", (Object)this.getValidAlwaysValue());
        descriptor.putProperty("compProdValidPlatform", (Object)this.getValidPlatformValue());
        descriptor.putProperty("compProdValidCustom", (Object)this.getValidCustomValue());
    }

    void readData(WizardDescriptor descriptor) {
        this.mySettings = descriptor;
        this.readClassNameValue();
        this.myCPPaletteDispName.setText(this.getPaletteDispName());
        this.myCPPaletteTooltip.setText(this.getPaletteTooltip());
        this.myCPPaletteCategoryCombo.setSelectedItem((Object)this.getPaletteCategory());
        this.myCPSmallIconPath.setText(this.getSmallIcon());
        this.myCPLargeIconPath.setText(this.getLargeIcon());
        this.myCPAddLibDependencyChk.setSelected(this.getAddLib());
        this.myCPLibName.setText((String)this.mySettings.getProperty("compProdLibName"));
        if (this.getValidAlways() != null) {
            this.myCPValidAlwaysRadio.setSelected(this.getValidAlways());
        }
        if (this.getValidPlatform() != null) {
            this.myCPValidPlatformRadio.setSelected(this.getValidPlatform());
        }
        if (this.getValidCustom() != null) {
            this.myCPValidCustomRadio.setSelected(this.getValidCustom());
        }
        this.checkValidity();
    }

    private CustomComponentHelper getHelper() {
        return (CustomComponentHelper)this.mySettings.getProperty("custCompHelper");
    }

    private String getPaletteDispName() {
        String value = (String)this.mySettings.getProperty("compProdPaletteDispName");
        return value == null ? this.getPrefix() : value;
    }

    private String getPaletteTooltip() {
        String value = (String)this.mySettings.getProperty("compProdPaletteTip");
        return value == null ? this.getPrefix() : value;
    }

    private PaletteCategory getPaletteCategory() {
        Object value = this.mySettings.getProperty("compProdPaletteCategory");
        if (value == null || !(value instanceof PaletteCategory)) {
            return PaletteCategory.CATEGORY_DISPLAYABLES;
        }
        return (PaletteCategory)((Object)value);
    }

    private String getPrefix() {
        String prefix = (String)this.mySettings.getProperty("prefix");
        assert (prefix != null);
        return prefix;
    }

    private void readClassNameValue() {
        String name = (String)this.mySettings.getProperty("compProdClassName");
        if (name == null || !this.isCPClassNameUpdated) {
            name = NewComponentDescriptor.createDefaultProducerClass(this.getPrefix());
            this.myCPClassName.setText(name);
            this.isCPClassNameUpdated = false;
        } else {
            this.myCPClassName.setText(name);
        }
    }

    private Boolean getAddLib() {
        Object value = this.mySettings.getProperty("compProdAddLib");
        if (value == null) {
            return Boolean.FALSE;
        }
        return (Boolean)value;
    }

    private String getSmallIcon() {
        String value = (String)this.mySettings.getProperty("compProdSmallIcon");
        return value == null || value.length() == 0 ? NONE : value;
    }

    private String getLargeIcon() {
        String value = (String)this.mySettings.getProperty("compProdLargeIcon");
        return value == null || value.length() == 0 ? NONE : value;
    }

    private Boolean getValidAlways() {
        return (Boolean)this.mySettings.getProperty("compProdValidAlways");
    }

    private Boolean getValidPlatform() {
        return (Boolean)this.mySettings.getProperty("compProdValidPlatform");
    }

    private Boolean getValidCustom() {
        return (Boolean)this.mySettings.getProperty("compProdValidCustom");
    }

    private boolean checkValidity() {
        if (!this.isCPClassNameValid()) {
            return false;
        }
        if (!this.isCPPaletteDispNameValid()) {
            return false;
        }
        if (!this.isCPSmallIconValid()) {
            return false;
        }
        if (!this.isCPLargeIconValid()) {
            return false;
        }
        if (!this.isCPLibNameValid()) {
            return false;
        }
        this.markValid();
        return true;
    }

    private boolean isCPSmallIconValid() {
        String path = this.getSmallIconValue();
        if (path.length() == 0) {
            this.setWarning(IconUtils.getNoIconMessage(16, 16));
        } else {
            if (!ComponentProducerVisualPanel.isFileExist(path)) {
                this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_SMALL_NOT_EXIST, new Object[0]));
                return false;
            }
            if (!IconUtils.isValidIcon(new File(path), 16, 16)) {
                this.setWarning(IconUtils.getIconDimensionMessage(new File(path), 16, 16));
            }
        }
        return true;
    }

    private boolean isCPLargeIconValid() {
        String path = this.getLargeIconValue();
        if (path.length() == 0) {
            this.setWarning(IconUtils.getNoIconMessage(32, 32));
        } else {
            if (!ComponentProducerVisualPanel.isFileExist(path)) {
                this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_LARGE_NOT_EXIST, new Object[0]));
                return false;
            }
            if (!IconUtils.isValidIcon(new File(path), 32, 32)) {
                this.setWarning(IconUtils.getIconDimensionMessage(new File(path), 32, 32));
            }
        }
        return true;
    }

    private static boolean isFileExist(String path) {
        File file = new File(path);
        return file.exists();
    }

    private boolean isCPClassNameValid() {
        String name = this.getClassNameValue();
        if (name.length() == 0) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_CLASS_NAME_EMPTY, new Object[0]));
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)name)) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_CLASS_NAME_INVALID, new Object[0]));
            return false;
        }
        if (this.getHelper().isProducerClassNameExist(name)) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_CLASS_NAME_EXISTS, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCPPaletteDispNameValid() {
        String name = this.getPaletteDispNameValue();
        if (name.length() == 0) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_PALETTE_DISP_NAME_EMPTY, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCPLibNameValid() {
        if (!this.getAddLibraryValue().booleanValue()) {
            return true;
        }
        String name = this.getLibraryNameValue();
        if (name.length() == 0) {
            this.setError(ComponentProducerVisualPanel.getMessage(MSG_ERR_LIB_NAME_EMPTY, new Object[0]));
            return false;
        }
        return true;
    }

    protected final void setError(String message) {
        assert (message != null);
        this.setMessage(message);
        this.setValid(false);
    }

    protected final void setWarning(String message) {
        assert (message != null);
        this.setMessage(message);
        this.setValid(true);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    private final void setMessage(String message) {
        this.mySettings.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    private final void setValid(boolean valid) {
        this.myPanel.setValid(valid);
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(ComponentProducerVisualPanel.class);
    }

    private static String getMessage(String key, Object ... args) {
        return NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)key, (Object[])args);
    }

    private String getClassNameValue() {
        return this.myCPClassName.getText().trim();
    }

    private String getPaletteDispNameValue() {
        return this.myCPPaletteDispName.getText().trim();
    }

    private String getPaletteTooltipValue() {
        return this.myCPPaletteTooltip.getText().trim();
    }

    private PaletteCategory getPaletteCategoryValue() {
        return (PaletteCategory)((Object)this.myCPPaletteCategoryCombo.getSelectedItem());
    }

    private String getSmallIconValue() {
        String value = this.myCPSmallIconPath.getText().trim();
        return value.equals(NONE) ? "" : value;
    }

    private String getLargeIconValue() {
        String value = this.myCPLargeIconPath.getText().trim();
        return value.equals(NONE) ? "" : value;
    }

    private Boolean getAddLibraryValue() {
        return this.myCPAddLibDependencyChk.isSelected();
    }

    private String getLibraryNameValue() {
        return this.myCPLibName.getText().trim();
    }

    private Boolean getValidAlwaysValue() {
        return this.myCPValidAlwaysRadio.isSelected();
    }

    private Boolean getValidPlatformValue() {
        return this.myCPValidPlatformRadio.isSelected();
    }

    private Boolean getValidCustomValue() {
        return this.myCPValidCustomRadio.isSelected();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.myCPClassName.getDocument().addDocumentListener(this.myClassNameListener);
            this.myCPPaletteDispName.getDocument().addDocumentListener(this.myDocListener);
            this.myCPPaletteTooltip.getDocument().addDocumentListener(this.myDocListener);
            this.myCPSmallIconPath.getDocument().addDocumentListener(this.mySmallIconPathListener);
            this.myCPLargeIconPath.getDocument().addDocumentListener(this.myLargeIconPathListener);
            this.myCPLibName.getDocument().addDocumentListener(this.myDocListener);
            this.myCPAddLibDependencyChk.addActionListener(this.myAddLibDependencyListener);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.myCPClassName.getDocument().removeDocumentListener(this.myClassNameListener);
            this.myCPPaletteDispName.getDocument().removeDocumentListener(this.myDocListener);
            this.myCPPaletteTooltip.getDocument().removeDocumentListener(this.myDocListener);
            this.myCPSmallIconPath.getDocument().removeDocumentListener(this.mySmallIconPathListener);
            this.myCPLargeIconPath.getDocument().removeDocumentListener(this.myLargeIconPathListener);
            this.myCPLibName.getDocument().removeDocumentListener(this.myDocListener);
            this.myCPAddLibDependencyChk.removeActionListener(this.myAddLibDependencyListener);
            this.listenersAttached = false;
        }
    }

    private void initComponents() {
        this.myValidButtonGroup = new ButtonGroup();
        this.myCompProducerPanel = new JPanel();
        this.myCPClassNameLabel = new JLabel();
        this.myCPClassName = new JTextField();
        this.myCPPaletteDispNameLabel = new JLabel();
        this.myCPPaletteDispName = new JTextField();
        this.myCPPaletteTooltipLabel = new JLabel();
        this.myCPPaletteTooltip = new JTextField();
        this.myCPPaletteCategoryLabel = new JLabel();
        this.myCPPaletteCategoryCombo = new JComboBox();
        this.myCPSmallIconPathLabel = new JLabel();
        this.myCPSmallIconPath = new JTextField();
        this.myCPSmallIconPathButton = new JButton();
        this.myCPLargeIconPathLabel = new JLabel();
        this.myCPLargeIconPath = new JTextField();
        this.myCPLargeIconPathButton = new JButton();
        this.myCPAddLibDependencyChk = new JCheckBox();
        this.myLibNamePanel = new JPanel();
        this.myCPLibNameLabel = new JLabel();
        this.myCPLibName = new JTextField();
        this.myValidityPanel = new JPanel();
        this.myCPValidAlwaysRadio = new JRadioButton();
        this.myCPValidPlatformRadio = new JRadioButton();
        this.myCPValidCustomRadio = new JRadioButton();
        this.myCompProducerPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ComponentProducer")));
        this.myCPClassNameLabel.setLabelFor(this.myCPClassName);
        Mnemonics.setLocalizedText((JLabel)this.myCPClassNameLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ClassNameLabel"));
        this.myCPClassName.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ClassNameLabel"));
        this.myCPPaletteDispNameLabel.setLabelFor(this.myCPPaletteDispName);
        Mnemonics.setLocalizedText((JLabel)this.myCPPaletteDispNameLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_PaletteDisplayName"));
        this.myCPPaletteDispName.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteDisplayName"));
        this.myCPPaletteTooltipLabel.setLabelFor(this.myCPPaletteTooltip);
        Mnemonics.setLocalizedText((JLabel)this.myCPPaletteTooltipLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_PaletteTooltip"));
        this.myCPPaletteTooltip.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteTooltip"));
        this.myCPPaletteCategoryLabel.setLabelFor(this.myCPPaletteCategoryCombo);
        Mnemonics.setLocalizedText((JLabel)this.myCPPaletteCategoryLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_PaletteCategory"));
        this.myCPPaletteCategoryCombo.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteCategory"));
        this.myCPSmallIconPathLabel.setLabelFor(this.myCPSmallIconPath);
        Mnemonics.setLocalizedText((JLabel)this.myCPSmallIconPathLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_SmallIconPath"));
        this.myCPSmallIconPath.setText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)TXT_NONE));
        this.myCPSmallIconPath.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_SmallIconPath"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCPSmallIconPathButton, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_SmallIconButton"));
        this.myCPSmallIconPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComponentProducerVisualPanel.this.myCPSmallIconPathButtonActionPerformed(evt);
            }
        });
        this.myCPLargeIconPathLabel.setLabelFor(this.myCPLargeIconPath);
        Mnemonics.setLocalizedText((JLabel)this.myCPLargeIconPathLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_LargeIconPath"));
        this.myCPLargeIconPath.setText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)TXT_NONE));
        this.myCPLargeIconPath.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LargeIconPath"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCPLargeIconPathButton, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_LargeIconButton"));
        this.myCPLargeIconPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComponentProducerVisualPanel.this.myCPLargeIconPathButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.myCPAddLibDependencyChk, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_AddLibraryChk"));
        this.myCPLibNameLabel.setLabelFor(this.myCPLibName);
        Mnemonics.setLocalizedText((JLabel)this.myCPLibNameLabel, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_LibName"));
        this.myCPLibName.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LibName"));
        GroupLayout myLibNamePanelLayout = new GroupLayout(this.myLibNamePanel);
        this.myLibNamePanel.setLayout(myLibNamePanelLayout);
        myLibNamePanelLayout.setHorizontalGroup(myLibNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myLibNamePanelLayout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.myCPLibNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myCPLibName, -1, 327, Short.MAX_VALUE)));
        myLibNamePanelLayout.setVerticalGroup(myLibNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myLibNamePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCPLibNameLabel).addComponent(this.myCPLibName, -2, -1, -2)));
        this.myCPLibNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_LibName"));
        this.myCPLibNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LibName"));
        this.myValidityPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_Validity")));
        this.myValidButtonGroup.add(this.myCPValidAlwaysRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.myCPValidAlwaysRadio, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ValidAlways"));
        this.myCPValidAlwaysRadio.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidAlways"));
        this.myValidButtonGroup.add(this.myCPValidPlatformRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.myCPValidPlatformRadio, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ValidPlatform"));
        this.myCPValidPlatformRadio.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidPlatform"));
        this.myValidButtonGroup.add(this.myCPValidCustomRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.myCPValidCustomRadio, (String)NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"LBL_CP_ValidCustom"));
        this.myCPValidCustomRadio.setToolTipText(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidCustom"));
        GroupLayout myValidityPanelLayout = new GroupLayout(this.myValidityPanel);
        this.myValidityPanel.setLayout(myValidityPanelLayout);
        myValidityPanelLayout.setHorizontalGroup(myValidityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myValidityPanelLayout.createSequentialGroup().addContainerGap().addGroup(myValidityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCPValidAlwaysRadio).addComponent(this.myCPValidPlatformRadio).addComponent(this.myCPValidCustomRadio)).addContainerGap(260, Short.MAX_VALUE)));
        myValidityPanelLayout.setVerticalGroup(myValidityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myValidityPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.myCPValidAlwaysRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myCPValidPlatformRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myCPValidCustomRadio).addContainerGap(-1, Short.MAX_VALUE)));
        this.myCPValidAlwaysRadio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ValidAlways"));
        this.myCPValidAlwaysRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidAlways"));
        this.myCPValidPlatformRadio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ValidPlatform"));
        this.myCPValidPlatformRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidPlatform"));
        this.myCPValidCustomRadio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ValidCustom"));
        this.myCPValidCustomRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ValidCustom"));
        GroupLayout myCompProducerPanelLayout = new GroupLayout(this.myCompProducerPanel);
        this.myCompProducerPanel.setLayout(myCompProducerPanelLayout);
        myCompProducerPanelLayout.setHorizontalGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myCompProducerPanelLayout.createSequentialGroup().addContainerGap().addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myValidityPanel, -1, -1, Short.MAX_VALUE).addComponent(this.myCPAddLibDependencyChk).addComponent(this.myLibNamePanel, -1, -1, Short.MAX_VALUE).addGroup(myCompProducerPanelLayout.createSequentialGroup().addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCPPaletteDispNameLabel).addComponent(this.myCPPaletteTooltipLabel).addComponent(this.myCPPaletteCategoryLabel).addComponent(this.myCPSmallIconPathLabel).addComponent(this.myCPLargeIconPathLabel).addComponent(this.myCPClassNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCPClassName, -1, 315, Short.MAX_VALUE).addComponent(this.myCPPaletteTooltip, -1, 315, Short.MAX_VALUE).addComponent(this.myCPPaletteDispName, -1, 315, Short.MAX_VALUE).addComponent(this.myCPPaletteCategoryCombo, -2, 182, -2).addGroup(GroupLayout.Alignment.TRAILING, myCompProducerPanelLayout.createSequentialGroup().addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.myCPLargeIconPath, -1, 222, Short.MAX_VALUE).addComponent(this.myCPSmallIconPath, -1, 222, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCPSmallIconPathButton, GroupLayout.Alignment.TRAILING).addComponent(this.myCPLargeIconPathButton, GroupLayout.Alignment.TRAILING)))))).addContainerGap()));
        myCompProducerPanelLayout.setVerticalGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myCompProducerPanelLayout.createSequentialGroup().addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCPClassNameLabel).addComponent(this.myCPClassName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCPPaletteDispNameLabel).addComponent(this.myCPPaletteDispName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCPPaletteTooltipLabel).addComponent(this.myCPPaletteTooltip, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCPPaletteCategoryLabel).addComponent(this.myCPPaletteCategoryCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCPSmallIconPathLabel).addComponent(this.myCPSmallIconPathButton).addComponent(this.myCPSmallIconPath, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompProducerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCPLargeIconPathLabel).addComponent(this.myCPLargeIconPathButton).addComponent(this.myCPLargeIconPath, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myCPAddLibDependencyChk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myLibNamePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myValidityPanel, -2, -1, -2)));
        this.myCPClassNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ClassNameLabel"));
        this.myCPClassNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ClassNameLabel"));
        this.myCPPaletteDispNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_PaletteDisplayName"));
        this.myCPPaletteDispNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteDisplayName"));
        this.myCPPaletteTooltipLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_PaletteTooltip"));
        this.myCPPaletteTooltipLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteTooltip"));
        this.myCPPaletteCategoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_PaletteCategory"));
        this.myCPPaletteCategoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_PaletteCategory"));
        this.myCPSmallIconPathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_SmallIconPath"));
        this.myCPSmallIconPathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_SmallIconPath"));
        this.myCPSmallIconPathButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_SmallIconButton"));
        this.myCPSmallIconPathButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_SmallIconButton"));
        this.myCPLargeIconPathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_LargeIconPath"));
        this.myCPLargeIconPathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LargeIconPath"));
        this.myCPLargeIconPathButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_LargeIconButton"));
        this.myCPLargeIconPathButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_LargeIconButton"));
        this.myCPAddLibDependencyChk.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_AddLibraryChk"));
        this.myCPAddLibDependencyChk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_AddLibraryChk"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCompProducerPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCompProducerPanel, -2, -1, -2));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSN_CP_ComponentProducerPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentProducerVisualPanel.class, (String)"ACSD_CP_ComponentProducerPanel"));
    }

    private void myCPSmallIconPathButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = IconUtils.getIconFileChooser(this.myCPSmallIconPath.getText());
        int ret = chooser.showDialog(this, ComponentProducerVisualPanel.getMessage(LBL_SELECT, new Object[0]));
        if (ret == 0) {
            File iconFile = chooser.getSelectedFile();
            File secondIcon = ComponentProducerVisualPanel.getAnotherIconPath(iconFile);
            if (secondIcon != null) {
                boolean isIconSmall = IconUtils.isValidIcon(iconFile, 16, 16);
                String small = isIconSmall ? iconFile.getAbsolutePath() : secondIcon.getAbsolutePath();
                String large = isIconSmall ? secondIcon.getAbsolutePath() : iconFile.getAbsolutePath();
                this.myCPSmallIconPath.setText(small);
                if (!this.isLargeIconUpdated) {
                    this.myCPLargeIconPath.setText(large);
                    this.isLargeIconUpdated = false;
                }
            } else {
                this.myCPSmallIconPath.setText(iconFile.getAbsolutePath());
            }
        }
    }

    private void myCPLargeIconPathButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = IconUtils.getIconFileChooser(this.myCPLargeIconPath.getText());
        int ret = chooser.showDialog(this, ComponentProducerVisualPanel.getMessage(LBL_SELECT, new Object[0]));
        if (ret == 0) {
            File iconFile = chooser.getSelectedFile();
            File secondIcon = ComponentProducerVisualPanel.getAnotherIconPath(iconFile);
            if (secondIcon != null) {
                boolean isIconSmall = IconUtils.isValidIcon(iconFile, 16, 16);
                String small = isIconSmall ? iconFile.getAbsolutePath() : secondIcon.getAbsolutePath();
                String large = isIconSmall ? secondIcon.getAbsolutePath() : iconFile.getAbsolutePath();
                this.myCPLargeIconPath.setText(large);
                if (!this.isSmallIconUpdated) {
                    this.myCPSmallIconPath.setText(small);
                    this.isSmallIconUpdated = false;
                }
            } else {
                this.myCPLargeIconPath.setText(iconFile.getAbsolutePath());
            }
        }
    }

    private static File getAnotherIconPath(File iconFile) {
        Set<File> allFiles = IconUtils.getPossibleIcons(iconFile.getAbsolutePath());
        assert (allFiles.contains(iconFile));
        allFiles.remove(iconFile);
        boolean isIconSmall = IconUtils.isValidIcon(iconFile, 16, 16);
        File secondIcon = null;
        boolean isSecondIconSmall = false;
        Iterator<File> it = allFiles.iterator();
        while (it.hasNext() && !isSecondIconSmall) {
            File f = it.next();
            isSecondIconSmall = isIconSmall ? IconUtils.isValidIcon(f, 32, 32) : IconUtils.isValidIcon(f, 16, 16);
            if (!isSecondIconSmall) continue;
            secondIcon = f;
            break;
        }
        return secondIcon;
    }
}

