/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.CustomComponentVisualPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.EditableListModel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.JavaMELibsVisualPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NewComponentDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DescriptorsVisualPanel
extends JPanel {
    private static final String CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String DLD_DELETE_TITLE = "MSG_ComponentDeleteTitle";
    private static final String DLD_DELETE_MSG = "MSG_ComponentDeleteMsg";
    private static final String ACSN_DESC_PANEL = "ACSN_DescPanel";
    private static final String ACSD_DESC_PANEL = "ACSD_DescPanel";
    private JScrollPane jScrollPane1;
    private JButton myAddButton;
    private JLabel myCompDescrLabel;
    private JList myCompDescrList;
    private JButton myRemoveButton;
    private WizardDescriptor myWizardDescriptor;
    private WizardDescriptor myInnerDescriptor;

    public DescriptorsVisualPanel() {
        this.initComponents();
        this.initAccessibility();
        this.myCompDescrList.setModel(new CompDescriptorsListModel());
        this.myCompDescrList.getSelectionModel().setSelectionMode(0);
        this.myCompDescrList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DescriptorsVisualPanel.this.updateRemoveButton();
            }
        });
        this.updateRemoveButton();
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(DescriptorsVisualPanel.class);
    }

    private void updateRemoveButton() {
        if (this.myCompDescrList.isSelectionEmpty()) {
            this.myRemoveButton.setEnabled(false);
        } else {
            this.myRemoveButton.setEnabled(true);
        }
    }

    void readData(WizardDescriptor settings) {
        this.myWizardDescriptor = settings;
        CompDescriptorsListModel model = (CompDescriptorsListModel)this.myCompDescrList.getModel();
        List components = (List)this.myWizardDescriptor.getProperty("customComponents");
        model.updateModel(components);
    }

    void storeData(WizardDescriptor settings) {
    }

    private void initComponents() {
        this.myCompDescrLabel = new JLabel();
        this.myAddButton = new JButton();
        this.myRemoveButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.myCompDescrList = new JList();
        this.myCompDescrLabel.setLabelFor(this.myCompDescrList);
        Mnemonics.setLocalizedText((JLabel)this.myCompDescrLabel, (String)NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"LBL_AddedComponentDescriptors"));
        Mnemonics.setLocalizedText((AbstractButton)this.myAddButton, (String)NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"BTN_AddComponentDescr"));
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DescriptorsVisualPanel.this.addPressed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.myRemoveButton, (String)NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"BTN_RemoveComponentDescr"));
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DescriptorsVisualPanel.this.removePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.myCompDescrList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCompDescrLabel).addComponent(this.jScrollPane1, -1, 321, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.myAddButton, -1, -1, Short.MAX_VALUE).addComponent(this.myRemoveButton, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myCompDescrLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myAddButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myRemoveButton).addContainerGap(228, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 284, Short.MAX_VALUE))));
        this.myCompDescrLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSN_AddedComponentDescriptors"));
        this.myCompDescrLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSD_AddedComponentDescriptors"));
        this.myAddButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSN_AddComponentDescr"));
        this.myAddButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSD_AddComponentDescr"));
        this.myRemoveButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSN_RemoveComponentDescr"));
        this.myRemoveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSD_RemoveComponentDescr"));
    }

    private void addPressed(ActionEvent evt) {
        NewComponentDescriptor iterator = new NewComponentDescriptor(this.myWizardDescriptor);
        this.myInnerDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        this.myInnerDescriptor.putProperty(AUTO_WIZARD_STYLE, (Object)true);
        this.myInnerDescriptor.putProperty(CONTENT_DISPLAYED, (Object)true);
        this.myInnerDescriptor.putProperty(CONTENT_NUMBERED, (Object)true);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.myInnerDescriptor);
        dialog.setVisible(true);
        this.readData(this.myWizardDescriptor);
    }

    private void removePressed(ActionEvent evt) {
        int index = this.myCompDescrList.getSelectedIndex();
        List components = (List)this.myWizardDescriptor.getProperty("customComponents");
        String name = (String)((Map)components.get(index)).get("prefix");
        String title = DescriptorsVisualPanel.getMessage(DLD_DELETE_TITLE, new Object[0]);
        String msg = DescriptorsVisualPanel.getMessage(DLD_DELETE_MSG, name);
        if (!UIUtils.userConfirmOkCancel(title, msg)) {
            return;
        }
        ((CompDescriptorsListModel)this.myCompDescrList.getModel()).remove(index);
        components.remove(index);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSN_DESC_PANEL));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSD_DESC_PANEL));
    }

    private static String getMessage(String key, Object ... args) {
        return NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)key, (Object[])args);
    }

    private class CompDescriptorsListModel
    extends EditableListModel {
        private CompDescriptorsListModel() {
        }

        public void updateModel(List<Map<String, Object>> components) {
            if (components == null) {
                return;
            }
            this.removeAllElements();
            for (Map<String, Object> component : components) {
                String prefix = (String)component.get("prefix");
                String typeID = (String)component.get("compDescrTypeId");
                assert (prefix != null && typeID != null) : "Component data is not consistent";
                this.addElement(prefix + " [ " + typeID + " ]");
            }
        }
    }
}

