/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jsp.lexer;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.spi.jsp.lexer.JspParseData;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.netbeans.spi.lexer.TokenPropertyProvider;

public class JspLexer
implements Lexer<JspTokenId> {
    private static final Logger LOGGER = Logger.getLogger(JspLexer.class.getName());
    private static final boolean LOG = Boolean.getBoolean("j2ee_lexer_debug");
    private static final int EOF = -1;
    private static final String JSP_STANDART_TAG_PREFIX = "jsp:";
    private final LexerInput input;
    private final InputAttributes inputAttributes;
    private final JspParseData jspParseData;
    private final TokenFactory<JspTokenId> tokenFactory;
    private int lexerState = 0;
    private int lexerStateBeforeEL = 0;
    private int lexerStateBeforeScriptlet = 0;
    private int lexerStateJspScriptlet = 0;
    private static final int INIT = 0;
    private static final int ISI_ERROR = 1;
    private static final int ISA_LT = 2;
    private static final int ISI_TAGNAME = 3;
    private static final int ISI_DIRNAME = 4;
    private static final int ISP_TAG = 5;
    private static final int ISP_DIR = 6;
    private static final int ISI_TAG_I_WS = 7;
    private static final int ISI_DIR_I_WS = 8;
    private static final int ISI_ENDTAG = 9;
    private static final int ISI_TAG_ATTR = 10;
    private static final int ISI_DIR_ATTR = 11;
    private static final int ISP_TAG_EQ = 12;
    private static final int ISP_DIR_EQ = 13;
    private static final int ISI_TAG_STRING = 14;
    private static final int ISI_DIR_STRING = 15;
    private static final int ISI_TAG_STRING_B = 16;
    private static final int ISI_DIR_STRING_B = 17;
    private static final int ISI_TAG_STRING2 = 18;
    private static final int ISI_DIR_STRING2 = 19;
    private static final int ISI_TAG_STRING2_B = 20;
    private static final int ISI_DIR_STRING2_B = 21;
    private static final int ISA_ENDSLASH = 22;
    private static final int ISA_ENDPC = 23;
    private static final int ISA_LT_PC = 24;
    private static final int ISI_JSP_COMMENT = 25;
    private static final int ISI_JSP_COMMENT_M = 26;
    private static final int ISI_JSP_COMMENT_MM = 27;
    private static final int ISI_JSP_COMMENT_MMP = 28;
    private static final int ISI_TAG_ERROR = 30;
    private static final int ISI_DIR_ERROR = 31;
    private static final int ISI_DIR_ERROR_P = 32;
    private static final int ISA_LT_PC_AT = 33;
    private static final int ISA_LT_SLASH = 34;
    private static final int ISA_LT_PC_DASH = 35;
    private static final int ISI_SCRIPTLET = 36;
    private static final int ISP_SCRIPTLET_PC = 37;
    private static final int ISA_EL_DELIM_DOLLAR = 38;
    private static final int ISA_EL_DELIM_HASH = 42;
    private static final int ISI_EL = 39;
    private static final int ISI_EL_SINGLE_QUOTE = 50;
    private static final int ISA_EL_SINGLE_QUOTE_ESCAPE = 51;
    private static final int ISI_EL_DOUBLE_QUOTE = 52;
    private static final int ISA_EL_DOUBLE_QUOTE_ESCAPE = 53;
    private static final int ISA_BS = 40;
    private static final int ISP_GT_SCRIPTLET = 41;
    private static final int JAVA_SCRITPLET = 1;
    private static final int JAVA_DECLARATION = 2;
    private static final int JAVA_EXPRESSION = 3;
    private static final int JAVA_SCRITPLET_DOCUMENT = 4;
    private static final int JAVA_DECLARATION_DOCUMENT = 5;
    private static final int JAVA_EXPRESSION_DOCUMENT = 6;

    public Object state() {
        return this.lexerState + (this.lexerStateBeforeEL << 6) + (this.lexerStateBeforeScriptlet << 12) + (this.lexerStateJspScriptlet << 18);
    }

    public JspLexer(LexerRestartInfo<JspTokenId> info) {
        this.input = info.input();
        this.inputAttributes = info.inputAttributes();
        this.tokenFactory = info.tokenFactory();
        if (info.state() == null) {
            this.lexerState = 0;
            this.lexerStateBeforeEL = 0;
            this.lexerStateJspScriptlet = 0;
        } else {
            int encoded = (Integer)info.state();
            this.lexerStateJspScriptlet = encoded >> 18;
            this.lexerStateBeforeScriptlet = encoded << 14 >>> 26;
            this.lexerStateBeforeEL = encoded << 20 >>> 26;
            this.lexerState = encoded << 26 >>> 26;
        }
        this.jspParseData = this.inputAttributes != null ? (JspParseData)this.inputAttributes.getValue(LanguagePath.get(JspTokenId.language()), JspParseData.class) : null;
    }

    public boolean isIdentifierPart(char character) {
        return Character.isJavaIdentifierPart(character);
    }

    private boolean isJspTag(CharSequence tagName) {
        if (this.startsWith(tagName, JSP_STANDART_TAG_PREFIX)) {
            return true;
        }
        if (this.jspParseData != null) {
            if (!this.jspParseData.isInitialized()) {
                return this.contains(tagName, ':');
            }
            int colonIndex = this.indexOf(tagName, ':');
            if (colonIndex != -1) {
                CharSequence prefix = tagName.subSequence(0, colonIndex);
                return this.jspParseData.isTagLibRegistered(((Object)prefix).toString());
            }
        }
        return false;
    }

    private boolean contains(CharSequence text, char ch) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != ch) continue;
            return true;
        }
        return false;
    }

    private boolean startsWith(CharSequence text, CharSequence prefix) {
        if (text.length() < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (text.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private int indexOf(CharSequence text, char ch) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private boolean isELIgnored() {
        return this.jspParseData == null ? false : this.jspParseData.isELIgnored();
    }

    private boolean isXMLSyntax() {
        return this.jspParseData == null ? false : this.jspParseData.isXMLSyntax();
    }

    private CharSequence getPossibleTagName() {
        int actChar;
        int prev_read = this.input.readLength();
        int read = 0;
        do {
            actChar = this.input.read();
            ++read;
        } while ((Character.isLetter(actChar) || Character.isDigit(actChar) || actChar == 95 || actChar == 45 || actChar == 58 || actChar == 46 || actChar == 47) && actChar != -1);
        CharSequence tagName = this.input.readText().subSequence(prev_read, prev_read + read - 1);
        this.input.backup(read);
        return tagName;
    }

    private boolean followsJspTag() {
        return this.isJspTag(this.getPossibleTagName());
    }

    private boolean followsScriptletExpressionDelimiter(int actChar) {
        if (actChar == 60) {
            int next = this.input.read();
            if (next == 37) {
                next = this.input.read();
                if (next == 61) {
                    return true;
                }
                this.input.backup(2);
            } else {
                this.input.backup(1);
            }
        }
        return false;
    }

    public Token<JspTokenId> nextToken() {
        block190: while (true) {
            int actChar;
            if ((actChar = this.input.read()) == -1) {
                if (this.input.readLengthEOF() == 1) {
                    return null;
                }
                break;
            }
            block0 : switch (this.lexerState) {
                case 0: {
                    switch (actChar) {
                        case 60: {
                            this.lexerState = 2;
                            break block0;
                        }
                        case 92: {
                            this.lexerState = 40;
                            break block0;
                        }
                        case 36: {
                            this.lexerStateBeforeEL = this.lexerState;
                            this.lexerState = 38;
                            break block0;
                        }
                        case 35: {
                            this.lexerStateBeforeEL = this.lexerState;
                            this.lexerState = 42;
                        }
                    }
                    break;
                }
                case 40: {
                    if (actChar == 92) break;
                    this.lexerState = 0;
                    break;
                }
                case 38: {
                    if (this.isELIgnored()) {
                        this.lexerState = this.lexerStateBeforeEL;
                        this.lexerStateBeforeEL = 0;
                        break;
                    }
                }
                case 42: {
                    switch (actChar) {
                        case 123: {
                            if (this.input.readLength() > 2) {
                                this.input.backup(2);
                                this.lexerState = this.lexerStateBeforeEL;
                                this.lexerStateBeforeEL = 0;
                                return this.token(JspTokenId.TEXT);
                            }
                            this.lexerState = 39;
                            break block0;
                        }
                    }
                    this.input.backup(1);
                    this.lexerState = this.lexerStateBeforeEL;
                    this.lexerStateBeforeEL = 0;
                    break;
                }
                case 39: {
                    switch (actChar) {
                        case 39: {
                            this.lexerState = 50;
                            break block0;
                        }
                        case 34: {
                            this.lexerState = 52;
                            break block0;
                        }
                        case 125: {
                            this.lexerState = this.lexerStateBeforeEL;
                            this.lexerStateBeforeEL = 0;
                            return this.token(JspTokenId.EL);
                        }
                    }
                    break;
                }
                case 50: {
                    switch (actChar) {
                        case 92: {
                            this.lexerState = 51;
                            break block0;
                        }
                        case 39: {
                            this.lexerState = 39;
                        }
                    }
                    break;
                }
                case 52: {
                    switch (actChar) {
                        case 92: {
                            this.lexerState = 53;
                            break block0;
                        }
                        case 34: {
                            this.lexerState = 39;
                        }
                    }
                    break;
                }
                case 53: {
                    this.lexerState = 52;
                    break;
                }
                case 51: {
                    this.lexerState = 50;
                    break;
                }
                case 2: {
                    CharSequence tagName;
                    if (Character.isLetter(actChar) || actChar == 95) {
                        this.input.backup(1);
                        tagName = this.getPossibleTagName();
                        if (this.isJspTag(tagName)) {
                            if (this.input.readLength() > 1) {
                                this.input.backup(1);
                                this.lexerState = 0;
                                return this.token(JspTokenId.TEXT);
                            }
                            if (CharSequenceUtilities.equals((CharSequence)"jsp:scriptlet", (Object)tagName)) {
                                this.lexerStateJspScriptlet = 4;
                            } else if (CharSequenceUtilities.equals((CharSequence)"jsp:declaration", (Object)tagName)) {
                                this.lexerStateJspScriptlet = 5;
                            } else if (CharSequenceUtilities.equals((CharSequence)"jsp:expression", (Object)tagName)) {
                                this.lexerStateJspScriptlet = 6;
                            }
                            this.lexerState = 3;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        this.lexerState = 0;
                        break;
                    }
                    switch (actChar) {
                        case 47: {
                            this.lexerState = 34;
                            break block0;
                        }
                        case 37: {
                            this.lexerState = 24;
                            break block0;
                        }
                    }
                    this.input.backup(1);
                    this.lexerState = 0;
                    break;
                }
                case 34: {
                    if (Character.isLetter(actChar) || actChar == 95) {
                        this.input.backup(1);
                        if (this.followsJspTag()) {
                            if (this.input.readLength() > 2) {
                                this.input.backup(2);
                                this.lexerState = 0;
                                return this.token(JspTokenId.TEXT);
                            }
                            this.lexerState = 9;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        this.lexerState = 0;
                        break;
                    }
                    this.lexerState = 0;
                    break;
                }
                case 3: 
                case 4: {
                    if (Character.isLetter(actChar) || Character.isDigit(actChar) || actChar == 95 || actChar == 45 || actChar == 58 || actChar == 46) continue block190;
                    switch (actChar) {
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            break;
                        }
                        case 47: {
                            this.input.backup(1);
                            this.lexerState = this.lexerState == 3 ? 5 : 6;
                            break;
                        }
                        case 62: {
                            this.input.backup(1);
                            if (this.lexerStateJspScriptlet != 0) {
                                this.lexerState = 41;
                                break;
                            }
                            this.lexerState = this.lexerState == 3 ? 5 : 6;
                            break;
                        }
                        case 32: {
                            this.input.backup(1);
                            this.lexerState = this.lexerState == 3 ? 5 : 6;
                            break;
                        }
                        case 10: {
                            this.lexerState = 5;
                            this.input.backup(1);
                            return this.token(JspTokenId.TAG);
                        }
                        default: {
                            this.lexerState = this.lexerState == 3 ? 5 : 6;
                        }
                    }
                    return this.token(JspTokenId.TAG);
                }
                case 41: {
                    assert (actChar == 62);
                    this.lexerState = 36;
                    return this.token(JspTokenId.SYMBOL);
                }
                case 5: 
                case 6: {
                    if (Character.isLetter(actChar) || actChar == 95) {
                        this.lexerState = this.lexerState == 5 ? 10 : 11;
                        break;
                    }
                    switch (actChar) {
                        case 10: {
                            return this.token(JspTokenId.EOL);
                        }
                        case 62: {
                            if (this.lexerState == 5) {
                                this.lexerState = 0;
                                return this.token(JspTokenId.SYMBOL);
                            }
                            this.lexerState = 31;
                            break block0;
                        }
                        case 47: {
                            if (this.lexerState == 5) {
                                this.lexerState = 22;
                                break block0;
                            }
                            this.lexerState = 31;
                            break block0;
                        }
                        case 37: {
                            if (this.lexerState == 6) {
                                this.lexerState = 23;
                                break block0;
                            }
                            this.lexerState = 30;
                            break block0;
                        }
                        case 61: {
                            this.lexerState = this.lexerState == 5 ? 12 : 13;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        case 9: 
                        case 32: {
                            this.lexerState = this.lexerState == 5 ? 7 : 8;
                            break block0;
                        }
                        case 60: {
                            assert (this.input.readLength() == 1) : "There is something more than '<' char in the read text: '" + this.input.readText() + "'";
                            this.input.backup(1);
                            this.lexerState = 0;
                        }
                    }
                    this.lexerState = this.lexerState == 5 ? 30 : 31;
                    break;
                }
                case 7: 
                case 8: {
                    switch (actChar) {
                        case 9: 
                        case 32: {
                            break block0;
                        }
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            return this.token(JspTokenId.TAG);
                        }
                    }
                    this.lexerState = this.lexerState == 7 ? 5 : 6;
                    this.input.backup(1);
                    return this.token(JspTokenId.WHITESPACE);
                }
                case 9: {
                    if (Character.isLetter(actChar) || Character.isDigit(actChar) || actChar == 95 || actChar == 46 || actChar == 45 || actChar == 58) continue block190;
                    this.lexerState = 5;
                    this.input.backup(1);
                    return this.token(JspTokenId.ENDTAG);
                }
                case 10: 
                case 11: {
                    if (Character.isLetter(actChar) || Character.isDigit(actChar) || actChar == 95 || actChar == 58 || actChar == 45) continue block190;
                    this.lexerState = this.lexerState == 10 ? 5 : 6;
                    this.input.backup(1);
                    return this.token(JspTokenId.ATTRIBUTE);
                }
                case 12: 
                case 13: {
                    switch (actChar) {
                        case 10: {
                            return this.token(JspTokenId.EOL);
                        }
                        case 34: {
                            this.lexerState = this.lexerState == 12 ? 14 : 15;
                            break block0;
                        }
                        case 39: {
                            this.lexerState = this.lexerState == 12 ? 18 : 19;
                            break block0;
                        }
                        case 9: 
                        case 32: {
                            break block0;
                        }
                    }
                    this.lexerState = this.lexerState == 12 ? 5 : 6;
                    this.input.backup(this.input.readLength());
                    break;
                }
                case 14: 
                case 15: 
                case 18: 
                case 19: {
                    if (actChar == 34 && (this.lexerState == 14 || this.lexerState == 15)) {
                        this.lexerState = this.lexerState == 14 ? 5 : 6;
                        return this.token(JspTokenId.ATTR_VALUE);
                    }
                    if (actChar == 39 && (this.lexerState == 18 || this.lexerState == 19)) {
                        this.lexerState = this.lexerState == 18 ? 5 : 6;
                        return this.token(JspTokenId.ATTR_VALUE);
                    }
                    if (this.followsScriptletExpressionDelimiter(actChar)) {
                        if (this.input.readLength() == 3) {
                            this.lexerStateBeforeScriptlet = this.lexerState;
                            this.lexerStateJspScriptlet = 3;
                            this.lexerState = 36;
                            return this.token(JspTokenId.SYMBOL2);
                        }
                        this.input.backup(3);
                        return this.token(JspTokenId.ATTR_VALUE);
                    }
                    switch (actChar) {
                        case 92: {
                            switch (this.lexerState) {
                                case 14: {
                                    this.lexerState = 16;
                                    break block0;
                                }
                                case 15: {
                                    this.lexerState = 17;
                                    break block0;
                                }
                                case 18: {
                                    this.lexerState = 20;
                                    break block0;
                                }
                                case 19: {
                                    this.lexerState = 21;
                                }
                            }
                            break block0;
                        }
                        case 10: {
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.ATTR_VALUE);
                        }
                        case 36: {
                            if (this.input.readLength() > 1) {
                                this.input.backup(1);
                                return this.token(JspTokenId.ATTR_VALUE);
                            }
                            this.lexerStateBeforeEL = this.lexerState;
                            this.lexerState = 38;
                            break block0;
                        }
                        case 35: {
                            if (this.input.readLength() > 1) {
                                this.input.backup(1);
                                return this.token(JspTokenId.ATTR_VALUE);
                            }
                            this.lexerStateBeforeEL = this.lexerState;
                            this.lexerState = 42;
                            break block0;
                        }
                    }
                    break;
                }
                case 16: 
                case 17: 
                case 20: 
                case 21: {
                    switch (actChar) {
                        case 34: 
                        case 35: 
                        case 36: 
                        case 39: 
                        case 92: {
                            break;
                        }
                        default: {
                            this.input.backup(1);
                        }
                    }
                    switch (this.lexerState) {
                        case 16: {
                            this.lexerState = 14;
                            break block0;
                        }
                        case 17: {
                            this.lexerState = 15;
                            break block0;
                        }
                        case 20: {
                            this.lexerState = 18;
                            break block0;
                        }
                        case 21: {
                            this.lexerState = 19;
                        }
                    }
                    break;
                }
                case 22: {
                    switch (actChar) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        case 10: {
                            this.lexerState = 30;
                            this.input.backup(1);
                            return this.token(JspTokenId.SYMBOL);
                        }
                    }
                    this.lexerState = 5;
                    this.input.backup(1);
                    return this.token(JspTokenId.SYMBOL);
                }
                case 23: {
                    switch (actChar) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        case 10: {
                            this.lexerState = 31;
                            this.input.backup(1);
                            return this.token(JspTokenId.SYMBOL);
                        }
                    }
                    this.lexerState = 6;
                    this.input.backup(1);
                    return this.token(JspTokenId.SYMBOL);
                }
                case 24: {
                    switch (actChar) {
                        case 64: {
                            if (this.input.readLength() == 3) {
                                this.lexerState = 33;
                                return this.token(JspTokenId.SYMBOL);
                            }
                            this.input.backup(3);
                            this.lexerState = 0;
                            return this.token(JspTokenId.TEXT);
                        }
                        case 45: {
                            this.lexerState = 35;
                            break block0;
                        }
                        case 33: 
                        case 61: {
                            if (this.input.readLength() == 3) {
                                this.lexerStateJspScriptlet = actChar == 33 ? 2 : 3;
                                this.lexerState = 36;
                                return this.token(JspTokenId.SYMBOL2);
                            }
                            this.input.backup(3);
                            this.lexerState = 0;
                            return this.token(JspTokenId.TEXT);
                        }
                    }
                    if (this.input.readLength() == 3) {
                        this.lexerStateJspScriptlet = 1;
                        this.lexerState = 36;
                        this.input.backup(1);
                        return this.token(JspTokenId.SYMBOL2);
                    }
                    this.input.backup(3);
                    this.lexerState = 0;
                    return this.token(JspTokenId.TEXT);
                }
                case 36: {
                    CharSequence tagName;
                    switch (actChar) {
                        case 37: {
                            this.lexerState = 37;
                            break block0;
                        }
                        case 60: {
                            tagName = this.getPossibleTagName();
                            if (!CharSequenceUtilities.equals((CharSequence)"/jsp:scriptlet", (Object)tagName) && !CharSequenceUtilities.equals((CharSequence)"/jsp:declaration", (Object)tagName) && !CharSequenceUtilities.equals((CharSequence)"/jsp:expression", (Object)tagName)) break;
                            if (this.input.readLength() == 1) {
                                this.input.backup(1);
                                this.lexerState = 0;
                                break block0;
                            }
                            this.input.backup(1);
                            int lxs = this.lexerStateJspScriptlet;
                            this.lexerStateJspScriptlet = 0;
                            return this.scriptletToken(JspTokenId.SCRIPTLET, lxs);
                        }
                    }
                    break;
                }
                case 37: {
                    switch (actChar) {
                        case 62: {
                            if (this.input.readLength() == 2) {
                                this.lexerState = this.lexerStateBeforeScriptlet;
                                this.lexerStateBeforeScriptlet = 0;
                                this.lexerStateJspScriptlet = 0;
                                return this.token(JspTokenId.SYMBOL2);
                            }
                            this.input.backup(2);
                            this.lexerState = 36;
                            int lxs = this.lexerStateJspScriptlet;
                            this.lexerStateJspScriptlet = 0;
                            return this.scriptletToken(JspTokenId.SCRIPTLET, lxs);
                        }
                    }
                    this.lexerState = 36;
                    break;
                }
                case 35: {
                    switch (actChar) {
                        case 45: {
                            if (this.input.readLength() == 4) {
                                this.lexerState = 25;
                                break;
                            }
                            this.input.backup(4);
                            this.lexerState = 0;
                            return this.token(JspTokenId.TEXT);
                        }
                        default: {
                            this.lexerState = 0;
                            return this.token(JspTokenId.TEXT);
                        }
                    }
                }
                case 25: {
                    switch (actChar) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.COMMENT);
                        }
                        case 45: {
                            this.lexerState = 26;
                        }
                    }
                    break;
                }
                case 26: {
                    switch (actChar) {
                        case 10: {
                            this.lexerState = 25;
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.COMMENT);
                        }
                        case 45: {
                            this.lexerState = 27;
                            break block0;
                        }
                    }
                    this.lexerState = 25;
                    break;
                }
                case 27: {
                    switch (actChar) {
                        case 10: {
                            this.lexerState = 25;
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.COMMENT);
                        }
                        case 37: {
                            this.lexerState = 28;
                            break block0;
                        }
                        case 45: {
                            this.lexerState = 27;
                            break block0;
                        }
                    }
                    this.lexerState = 25;
                    break;
                }
                case 28: {
                    switch (actChar) {
                        case 10: {
                            this.lexerState = 25;
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.COMMENT);
                        }
                        case 62: {
                            this.lexerState = 0;
                            return this.token(JspTokenId.COMMENT);
                        }
                    }
                    this.lexerState = 25;
                    break;
                }
                case 1: {
                    switch (actChar) {
                        case 10: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                        case 60: {
                            this.lexerState = 2;
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                    }
                    break;
                }
                case 30: {
                    switch (actChar) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                this.lexerState = 5;
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                        case 9: 
                        case 32: 
                        case 62: {
                            this.lexerState = 5;
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                    }
                    break;
                }
                case 31: {
                    switch (actChar) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                this.lexerState = 6;
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                        case 9: 
                        case 32: {
                            this.lexerState = 6;
                            if (this.input.readLength() <= 1) break;
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                    }
                    break;
                }
                case 32: {
                    switch (actChar) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                this.lexerState = 8;
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                        case 62: {
                            this.input.backup(2);
                            this.lexerState = 8;
                            return this.token(JspTokenId.ERROR);
                        }
                    }
                    break;
                }
                case 33: {
                    if (Character.isLetter(actChar) || actChar == 95) {
                        this.lexerState = 4;
                        break;
                    }
                    switch (actChar) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.SYMBOL);
                        }
                        case 9: 
                        case 32: {
                            break block0;
                        }
                        case 37: {
                            this.lexerState = 23;
                            break block0;
                        }
                    }
                    this.lexerState = 31;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(JspTokenId.SYMBOL);
                }
            }
        }
        this.input.backup(1);
        switch (this.lexerState) {
            case 0: 
            case 2: 
            case 34: 
            case 40: {
                if (this.input.readLength() == 0) {
                    return null;
                }
                return this.token(JspTokenId.TEXT);
            }
            case 1: 
            case 30: {
                this.lexerState = 0;
                return this.token(JspTokenId.ERROR);
            }
            case 31: 
            case 32: {
                this.lexerState = 0;
                return this.token(JspTokenId.ERROR);
            }
            case 12: 
            case 22: {
                this.lexerState = 0;
                return this.token(JspTokenId.SYMBOL);
            }
            case 13: 
            case 23: 
            case 24: 
            case 35: {
                this.lexerState = 0;
                return this.token(JspTokenId.SYMBOL);
            }
            case 3: 
            case 9: {
                this.lexerState = 0;
                return this.token(JspTokenId.TAG);
            }
            case 4: {
                this.lexerState = 0;
                return this.token(JspTokenId.TAG);
            }
            case 5: 
            case 7: {
                this.lexerState = 0;
                return this.token(JspTokenId.TAG);
            }
            case 6: 
            case 8: 
            case 33: {
                this.lexerState = 0;
                return this.token(JspTokenId.TAG);
            }
            case 10: {
                this.lexerState = 0;
                return this.token(JspTokenId.ATTRIBUTE);
            }
            case 11: {
                this.lexerState = 0;
                return this.token(JspTokenId.ATTRIBUTE);
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                this.lexerState = 0;
                return this.token(JspTokenId.ATTR_VALUE);
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                this.lexerState = 0;
                return this.token(JspTokenId.ATTR_VALUE);
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                this.lexerState = 0;
                return this.token(JspTokenId.COMMENT);
            }
            case 38: 
            case 42: {
                this.lexerState = 0;
                return this.token(JspTokenId.TEXT);
            }
            case 39: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.lexerState = 0;
                return this.token(JspTokenId.EL);
            }
            case 36: 
            case 37: {
                this.lexerState = 0;
                return this.scriptletToken(JspTokenId.SCRIPTLET, this.lexerStateJspScriptlet);
            }
        }
        return null;
    }

    private Token<JspTokenId> token(JspTokenId tokenId) {
        if (LOG) {
            this.checkToken(tokenId);
        }
        return this.tokenFactory.createToken((TokenId)tokenId);
    }

    private Token<JspTokenId> scriptletToken(JspTokenId tokenId, int javaCodeType) {
        JspTokenId.JavaCodeType scriptletType;
        if (LOG) {
            this.checkToken(tokenId);
        }
        switch (javaCodeType) {
            case 1: 
            case 4: {
                scriptletType = JspTokenId.JavaCodeType.SCRIPTLET;
                break;
            }
            case 2: 
            case 5: {
                scriptletType = JspTokenId.JavaCodeType.DECLARATION;
                break;
            }
            case 3: 
            case 6: {
                scriptletType = JspTokenId.JavaCodeType.EXPRESSION;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported scriptlet type " + this.lexerStateJspScriptlet);
            }
        }
        return this.tokenFactory.createPropertyToken((TokenId)tokenId, this.input.readLength(), (TokenPropertyProvider)new JspTokenPropertyProvider(scriptletType), PartType.COMPLETE);
    }

    private void checkToken(JspTokenId tokenId) {
        if (this.input.readLength() == 0) {
            LOGGER.log(Level.INFO, "Found zero length token: ");
        }
        LOGGER.log(Level.INFO, "[" + this.getClass().getSimpleName() + "] token ('" + ((Object)this.input.readText()).toString() + "'; id=" + (Object)((Object)tokenId) + "; state=" + this.state() + ")\n");
    }

    public void release() {
    }

    private static class JspTokenPropertyProvider
    implements TokenPropertyProvider {
        private final JspTokenId.JavaCodeType scriptletType;

        JspTokenPropertyProvider(JspTokenId.JavaCodeType scriptletType) {
            this.scriptletType = scriptletType;
        }

        public Object getValue(Token token, Object key) {
            if ("JAVA_CODE_TYPE".equals(key)) {
                return this.scriptletType;
            }
            return null;
        }
    }
}

