/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.refactoring.api.CssRefactoring;
import org.netbeans.modules.css.refactoring.api.EntryHandle;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.completion.AttrValuesCompletion;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class HtmlDeclarationFinder
implements DeclarationFinder {
    private static final String XHTML_MIMETYPE = "text/xhtml";
    private static CssSelectorElementHandle CSS_SELECTOR_ELEMENT_HANDLE_SINGLETON = new CssSelectorElementHandle();

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        DeclarationFinder.DeclarationLocation loc = this.findCoreHtmlDeclaration(info, caretOffset);
        if (loc != null) {
            return loc;
        }
        for (HtmlExtension ext : HtmlExtension.getRegisteredExtensions(info.getSnapshot().getSource().getMimeType())) {
            loc = ext.findDeclaration(info, caretOffset);
            if (loc == null) continue;
            return loc;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(Document doc, int caretOffset) {
        OffsetRange range = this.getCoreHtmlReferenceSpan(doc, caretOffset);
        if (range != null) {
            return range;
        }
        String mimeType = NbEditorUtilities.getMimeType((Document)doc);
        for (HtmlExtension ext : HtmlExtension.getRegisteredExtensions(mimeType)) {
            range = ext.getReferenceSpan(doc, caretOffset);
            if (range == null) continue;
            return range;
        }
        return OffsetRange.NONE;
    }

    private OffsetRange getCoreHtmlReferenceSpan(Document doc, int caretOffset) {
        TokenSequence cssTs;
        TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(doc, caretOffset);
        if (ts == null) {
            return null;
        }
        if (ts.token().id() == HTMLTokenId.VALUE) {
            return (OffsetRange)new AttributeValueAction<OffsetRange>(ts){

                @Override
                public OffsetRange resolve() {
                    ValueCompletion<HtmlCompletionItem> support;
                    if (this.tagName != null && this.attrName != null && AttrValuesCompletion.FILE_NAME_SUPPORT == (support = AttrValuesCompletion.getSupport(this.tagName, this.attrName))) {
                        return this.valueRange;
                    }
                    return null;
                }
            }.run();
        }
        if (ts.token().id() == HTMLTokenId.VALUE_CSS && (cssTs = ts.embedded(CssTokenId.language())) != null) {
            cssTs.move(caretOffset);
            if ((cssTs.moveNext() || cssTs.movePrevious()) && cssTs.token().id() == CssTokenId.IDENT) {
                return new OffsetRange(cssTs.offset(), cssTs.offset() + cssTs.token().length());
            }
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation findCoreHtmlDeclaration(final ParserResult info, final int caretOffset) {
        final FileObject file = info.getSnapshot().getSource().getFileObject();
        TokenSequence ts = info.getSnapshot().getTokenHierarchy().tokenSequence(HTMLTokenId.language());
        if (ts == null) {
            return null;
        }
        int astCaretOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        if (astCaretOffset == -1) {
            return null;
        }
        ts.move(astCaretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (ts.token().id() == HTMLTokenId.VALUE) {
            return (DeclarationFinder.DeclarationLocation)new AttributeValueAction<DeclarationFinder.DeclarationLocation>(ts){

                @Override
                public DeclarationFinder.DeclarationLocation resolve() {
                    FileObject resolved;
                    ValueCompletion<HtmlCompletionItem> support;
                    if (this.tagName != null && this.attrName != null && AttrValuesCompletion.FILE_NAME_SUPPORT == (support = AttrValuesCompletion.getSupport(this.tagName, this.attrName)) && (resolved = WebUtils.resolve((FileObject)info.getSnapshot().getSource().getFileObject(), (String)this.unquotedValue)) != null) {
                        return new DeclarationFinder.DeclarationLocation(resolved, 0);
                    }
                    return null;
                }
            }.run();
        }
        if (ts.token().id() == HTMLTokenId.VALUE_CSS) {
            final Document doc = info.getSnapshot().getSource().getDocument(true);
            final AtomicReference ret = new AtomicReference();
            doc.render(new Runnable(){

                @Override
                public void run() {
                    Token valueToken;
                    TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(doc, caretOffset);
                    if (ts != null && ts.token() != null && (valueToken = ts.token()).id() == HTMLTokenId.VALUE_CSS) {
                        RefactoringElementType type;
                        TokenSequence cssTs = ts.embedded(CssTokenId.language());
                        String unquotedValue = null;
                        if (cssTs != null) {
                            cssTs.move(caretOffset);
                            if ((cssTs.moveNext() || cssTs.movePrevious()) && cssTs.token().id() == CssTokenId.IDENT) {
                                unquotedValue = ((Object)cssTs.token().text()).toString();
                            }
                        }
                        if (unquotedValue == null) {
                            return;
                        }
                        String cssTokenType = (String)valueToken.getProperty((Object)"valueCssType");
                        if (cssTokenType == null) {
                            return;
                        }
                        if ("class".equals(cssTokenType)) {
                            type = RefactoringElementType.CLASS;
                        } else if ("id".equals(cssTokenType)) {
                            type = RefactoringElementType.ID;
                        } else {
                            type = null;
                            assert (false);
                        }
                        Map occurances = CssRefactoring.findAllOccurances((String)unquotedValue, (RefactoringElementType)type, (FileObject)file, (boolean)true);
                        if (occurances == null) {
                            return;
                        }
                        DeclarationFinder.DeclarationLocation dl = null;
                        for (FileObject f : occurances.keySet()) {
                            Collection entries = (Collection)occurances.get(f);
                            for (EntryHandle entryHandle : entries) {
                                DeclarationFinder.DeclarationLocation dloc = new DeclarationFinder.DeclarationLocation(f, entryHandle.entry().getDocumentRange().getStart());
                                if (dl == null) {
                                    dl = dloc;
                                }
                                AlternativeLocationImpl aloc = new AlternativeLocationImpl(dloc, entryHandle, type);
                                dl.addAlternative((DeclarationFinder.AlternativeLocation)aloc);
                            }
                        }
                        if (dl != null && dl.getAlternativeLocations().size() == 1) {
                            dl.getAlternativeLocations().clear();
                        }
                        ret.set(dl);
                    }
                }
            });
            return (DeclarationFinder.DeclarationLocation)ret.get();
        }
        return null;
    }

    private static class CssSelectorElementHandle
    implements ElementHandle {
        private CssSelectorElementHandle() {
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }

    private static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private DeclarationFinder.DeclarationLocation location;
        private EntryHandle entryHandle;
        private RefactoringElementType type;
        private static final int SELECTOR_TEXT_MAX_LENGTH = 50;

        public AlternativeLocationImpl(DeclarationFinder.DeclarationLocation location, EntryHandle entry, RefactoringElementType type) {
            this.location = location;
            this.entryHandle = entry;
            this.type = type;
        }

        public ElementHandle getElement() {
            return CSS_SELECTOR_ELEMENT_HANDLE_SINGLETON;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            Project project;
            String elementTextPrefix;
            StringBuilder b = new StringBuilder();
            String lineText = ((Object)this.entryHandle.entry().getLineText()).toString();
            assert (lineText != null);
            int curlyBracketIndex = lineText.indexOf(123);
            String croppedLineText = curlyBracketIndex == -1 ? lineText : lineText.substring(0, curlyBracketIndex);
            switch (this.type) {
                case CLASS: {
                    elementTextPrefix = ".";
                    break;
                }
                case ID: {
                    elementTextPrefix = "#";
                    break;
                }
                default: {
                    elementTextPrefix = "";
                }
            }
            String elementText = elementTextPrefix + this.entryHandle.entry().getName();
            int elementTextIndex = croppedLineText.indexOf(elementText);
            if (elementTextIndex == -1) {
                String msg = "A parsing error occured when trying to extract display name for html declaration finder.elementText='" + elementText + "'; lineText='" + lineText + "'; croppedLineText='" + croppedLineText + "'; elementTextPrefix='" + elementTextPrefix + "'";
                Logger.getAnonymousLogger().log(Level.INFO, msg, new IllegalStateException());
                return this.entryHandle.entry().getName();
            }
            String prefix = croppedLineText.substring(0, elementTextIndex).trim();
            String postfix = croppedLineText.substring(elementTextIndex + elementText.length()).trim();
            int overlap = croppedLineText.length() - 50;
            if (overlap > 0) {
                int stripFromPrefix = Math.min(overlap / 2, prefix.length());
                prefix = ".." + prefix.substring(stripFromPrefix);
                int stripFromPostfix = Math.min(overlap - stripFromPrefix, postfix.length());
                postfix = postfix.substring(0, postfix.length() - stripFromPostfix) + "..";
            }
            b.append("<font color=007c00>");
            b.append(prefix);
            b.append(' ');
            b.append("<b>");
            b.append(elementText);
            b.append("</b>");
            b.append(' ');
            b.append(postfix);
            b.append("</font> in ");
            FileObject file = this.location.getFileObject();
            FileObject pathRoot = ProjectWebRootQuery.getWebRoot((FileObject)file);
            String path = null;
            String resolveTo = null;
            if (pathRoot != null) {
                path = FileUtil.getRelativePath((FileObject)pathRoot, (FileObject)file);
            }
            if (path == null && (project = FileOwnerQuery.getOwner((FileObject)file)) != null && (path = FileUtil.getRelativePath((FileObject)(pathRoot = project.getProjectDirectory()), (FileObject)file)) != null) {
                resolveTo = "${project.home}/";
            }
            if (path == null) {
                path = file.getPath();
            }
            if (resolveTo != null) {
                b.append("<i>");
                b.append(resolveTo);
                b.append("</i>");
            }
            b.append(path);
            int lineOffset = this.entryHandle.entry().getLineOffset();
            if (lineOffset != -1) {
                b.append(":");
                b.append(lineOffset + 1);
            }
            if (!this.entryHandle.isRelatedEntry()) {
                b.append(" <font color=ff0000>(");
                b.append(NbBundle.getMessage(HtmlDeclarationFinder.class, (String)"MSG_Unrelated"));
                b.append(")</font>");
            }
            return b.toString();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            return AlternativeLocationImpl.getComparableString(this).compareTo(AlternativeLocationImpl.getComparableString(o));
        }

        private static String getComparableString(DeclarationFinder.AlternativeLocation loc) {
            return loc.getLocation().getOffset() + loc.getLocation().getFileObject().getPath();
        }
    }

    private abstract class AttributeValueAction<T> {
        private TokenSequence<HTMLTokenId> ts;
        protected String tagName;
        protected String attrName;
        protected String unquotedValue;
        protected OffsetRange valueRange;

        public AttributeValueAction(TokenSequence<HTMLTokenId> ts) {
            this.ts = ts;
        }

        public abstract T resolve();

        public T run() {
            this.parseSquence();
            return this.resolve();
        }

        private void parseSquence() {
            int quotesDiff = WebUtils.isValueQuoted((CharSequence)((Object)this.ts.token().text()).toString()) ? 1 : 0;
            this.unquotedValue = WebUtils.unquotedValue((CharSequence)((Object)this.ts.token().text()).toString());
            this.valueRange = new OffsetRange(this.ts.offset() + quotesDiff, this.ts.offset() + this.ts.token().length() - quotesDiff);
            while (this.ts.movePrevious()) {
                HTMLTokenId id = (HTMLTokenId)this.ts.token().id();
                if (id == HTMLTokenId.ARGUMENT && this.attrName == null) {
                    this.attrName = ((Object)this.ts.token().text()).toString();
                    continue;
                }
                if (id == HTMLTokenId.TAG_OPEN) {
                    this.tagName = ((Object)this.ts.token().text()).toString();
                    break;
                }
                if (id != HTMLTokenId.TAG_OPEN_SYMBOL && id != HTMLTokenId.TAG_CLOSE_SYMBOL && id != HTMLTokenId.TEXT) continue;
                break;
            }
        }
    }
}

