/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;

class HtmlRenameHandler
implements InstantRenamer {
    public boolean isRenameAllowed(ParserResult info, int caretOffset, String[] explanationRetValue) {
        int astCaretOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        if (astCaretOffset == -1) {
            return false;
        }
        HtmlParserResult result = (HtmlParserResult)info;
        AstNode node = result.findLeafTag(astCaretOffset, true, true);
        if (node == null) {
            return false;
        }
        switch (node.type()) {
            case OPEN_TAG: {
                int from = node.startOffset();
                int to = node.startOffset() + 1 + node.name().length();
                return astCaretOffset >= from && astCaretOffset <= to;
            }
            case ENDTAG: {
                return true;
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(ParserResult info, int caretOffset) {
        AstNode pair;
        int astCaretOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        if (astCaretOffset == -1) {
            return Collections.emptySet();
        }
        HtmlParserResult result = (HtmlParserResult)info;
        AstNode node = result.findLeafTag(astCaretOffset, true, true);
        if (node != null && (pair = node.getMatchingTag()) != null) {
            AstNode close;
            AstNode open;
            HashSet<OffsetRange> set = new HashSet<OffsetRange>();
            switch (node.type()) {
                case OPEN_TAG: {
                    open = node;
                    close = pair;
                    break;
                }
                case ENDTAG: {
                    open = pair;
                    close = node;
                    break;
                }
                default: {
                    return Collections.emptySet();
                }
            }
            Snapshot s = info.getSnapshot();
            set.add(new OffsetRange(s.getOriginalOffset(open.startOffset() + 1), s.getOriginalOffset(open.startOffset() + 1 + open.name().length())));
            set.add(new OffsetRange(s.getOriginalOffset(close.startOffset() + 2), s.getOriginalOffset(close.startOffset() + 2 + close.name().length())));
            return set;
        }
        return Collections.emptySet();
    }
}

