/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import java.net.URL;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.lucene.Evictable;
import org.netbeans.modules.parsing.lucene.EvictionPolicy;
import org.netbeans.modules.parsing.lucene.LRUCache;
import org.openide.util.Utilities;

class IndexCacheFactory {
    private static final Logger LOG = Logger.getLogger(IndexCacheFactory.class.getName());
    private static final IndexCacheFactory instance = new IndexCacheFactory();
    private final LRUCache<URL, Evictable> cache = new LRUCache<URL, Evictable>(new DefaultPolicy());

    private IndexCacheFactory() {
    }

    public LRUCache<URL, Evictable> getCache() {
        return this.cache;
    }

    public static IndexCacheFactory getDefault() {
        return instance;
    }

    private static class DefaultPolicy
    implements EvictionPolicy<URL, Evictable> {
        private static final int DEFAULT_SIZE = 400;
        private static final boolean NEEDS_REMOVE = Boolean.getBoolean("IndexCache.force") || Utilities.isUnix() && !Utilities.isMac();
        private static final int MAX_SIZE;

        private DefaultPolicy() {
        }

        @Override
        public boolean shouldEvict(int size, URL key, Evictable value) {
            return NEEDS_REMOVE && size > MAX_SIZE;
        }

        static {
            int value = 400;
            String sizeStr = System.getProperty("IndexCache.size");
            if (sizeStr != null) {
                try {
                    value = Integer.parseInt(sizeStr);
                }
                catch (NumberFormatException nfe) {
                    LOG.warning("Wrong (non integer) cache size: " + sizeStr);
                }
            }
            MAX_SIZE = value;
            LOG.fine("NEEDS_REMOVE: " + NEEDS_REMOVE + " MAX_SIZE: " + MAX_SIZE);
        }
    }
}

