/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.php.editor.PHPLanguage;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.util.Exceptions;

public class ToggleBlockCommentAction
extends BaseAction {
    static final long serialVersionUID = -1L;
    private static final String FORCE_COMMENT = "force-comment";
    private static final String FORCE_UNCOMMENT = "force-uncomment";

    public ToggleBlockCommentAction() {
        super("toggle-comment");
    }

    public ToggleBlockCommentAction(Map<String, ?> attrs) {
        super(null);
        if (attrs != null) {
            String actionName = (String)attrs.get("Name");
            if (actionName == null) {
                throw new IllegalArgumentException("Null Action.NAME attribute for action " + ((Object)((Object)this)).getClass());
            }
            this.putValue("Name", actionName);
        }
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        boolean processedHere = false;
        if (target != null) {
            if (!(target.isEditable() && target.isEnabled() && target.getDocument() instanceof BaseDocument)) {
                target.getToolkit().beep();
                return;
            }
            int offset = Utilities.isSelectionShowing((JTextComponent)target) ? target.getSelectionStart() : target.getCaretPosition();
            final BaseDocument doc = (BaseDocument)target.getDocument();
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
            if (ts != null) {
                ts.move(offset);
                ts.moveNext();
                if (ts.token().id() != PHPTokenId.T_INLINE_HTML) {
                    boolean newLine = false;
                    while (ts.movePrevious() && ts.token().id() != PHPTokenId.PHP_OPENTAG && !newLine) {
                        if (ts.token().id() != PHPTokenId.WHITESPACE || !((Object)ts.token().text()).toString().contains("\n")) continue;
                        newLine = true;
                    }
                    if (!newLine && ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                        processedHere = true;
                        final int changeOffset = ts.offset() + ts.token().length();
                        final boolean lineComment = ts.moveNext() && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT || ts.token().id() == PHPTokenId.WHITESPACE && ts.moveNext() && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT;
                        final int length = lineComment ? ts.offset() + ts.token().length() - changeOffset : 0;
                        doc.runAtomic(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (!lineComment) {
                                        if (ToggleBlockCommentAction.this.forceDirection(true)) {
                                            doc.insertString(changeOffset, " " + PHPLanguage.LINE_COMMENT_PREFIX, null);
                                        }
                                    } else if (ToggleBlockCommentAction.this.forceDirection(false)) {
                                        doc.remove(changeOffset, length);
                                    }
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        });
                    }
                }
            }
        }
        if (!processedHere) {
            org.netbeans.modules.csl.api.ToggleBlockCommentAction action = new org.netbeans.modules.csl.api.ToggleBlockCommentAction();
            if (this.getValue(FORCE_COMMENT) != null) {
                action.putValue(FORCE_COMMENT, this.getValue(FORCE_COMMENT));
            }
            if (this.getValue(FORCE_UNCOMMENT) != null) {
                action.putValue(FORCE_UNCOMMENT, this.getValue(FORCE_UNCOMMENT));
            }
            action.actionPerformed(evt, target);
        }
    }

    private boolean forceDirection(boolean comment) {
        Object force;
        Object fComment = this.getValue(FORCE_COMMENT);
        Object fUncomment = this.getValue(FORCE_UNCOMMENT);
        Object object = force = comment ? fComment : fUncomment;
        if (force instanceof Boolean) {
            return (Boolean)force;
        }
        return fComment == null && fUncomment == null;
    }
}

