/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.Collection;
import java.util.Comparator;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TreeElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.codegen.Property;

public final class MethodProperty
extends Property {
    private final MethodElement method;
    private final TreeElement<TypeElement> enclosingType;

    public MethodProperty(MethodElement method, TreeElement<TypeElement> enclosingType) {
        super(MethodProperty.formatName(method), method.getPhpModifiers().toFlags());
        this.method = method;
        this.enclosingType = enclosingType;
        boolean typeIsAbstract = enclosingType.getElement().getPhpModifiers().isAbstract();
        boolean methodIsAbstract = method.isAbstract() || method.getType().isInterface();
        this.setSelected(!typeIsAbstract && methodIsAbstract);
    }

    public static Comparator<MethodProperty> getComparator() {
        return new Comparator<MethodProperty>(){

            @Override
            public int compare(MethodProperty o1, MethodProperty o2) {
                int retval = -Boolean.valueOf(o1.getMethod().isConstructor()).compareTo(o2.getMethod().isConstructor());
                if (retval == 0) {
                    retval = -Boolean.valueOf(o1.isSelected()).compareTo(o2.isSelected());
                }
                if (retval == 0) {
                    retval = Boolean.valueOf(o1.getMethod().isMagic()).compareTo(o2.getMethod().isMagic());
                }
                if (retval == 0) {
                    retval = o1.getMethod().getType().getName().compareTo(o2.getMethod().getType().getName());
                }
                if (retval == 0) {
                    retval = o1.getMethod().getName().compareTo(o2.getMethod().getName());
                }
                return retval;
            }
        };
    }

    private static String formatName(MethodElement method) {
        Collection returnTypes = method.getReturnTypes();
        String nameAndParams = method.asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration);
        String returntypes = method.asString(BaseFunctionElement.PrintAs.ReturnTypes);
        String[] split = nameAndParams.split("\\(");
        if (returnTypes.isEmpty()) {
            return String.format("<html><b>%s</b>(%s</html>", split[0], split[1]);
        }
        return String.format("<html><b>%s</b>(%s : %s</html>", split[0], split[1], returntypes);
    }

    public MethodElement getMethod() {
        return this.method;
    }

    public TreeElement<TypeElement> getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public PhpElementKind getKind() {
        return PhpElementKind.METHOD;
    }
}

