/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.ClassConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.LazyBuild;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.util.Union2;

class ClassScopeImpl
extends TypeScopeImpl
implements ClassScope,
VariableNameFactory {
    private Union2<String, List<ClassScopeImpl>> superClass;
    private Collection<QualifiedName> possibleFQSuperClassNames;

    @Override
    void addElement(ModelElementImpl element) {
        assert (element instanceof TypeScope || element instanceof VariableName || element instanceof MethodScope || element instanceof FieldElement || element instanceof ClassConstantElement) : element.getPhpElementKind();
        if (element instanceof TypeScope) {
            Scope inScope = this.getInScope();
            if (inScope instanceof ScopeImpl) {
                ((ScopeImpl)inScope).addElement(element);
            }
        } else {
            super.addElement(element);
        }
    }

    ClassScopeImpl(Scope inScope, ClassDeclarationInfo nodeInfo) {
        super(inScope, nodeInfo);
        Expression superId = nodeInfo.getSuperClass();
        Object superName = null;
        if (superId != null) {
            QualifiedName superClassName = QualifiedName.create(superId);
            this.possibleFQSuperClassNames = VariousUtils.getPossibleFQN(superClassName, nodeInfo.getSuperClass().getStartOffset(), (NamespaceScope)inScope);
            this.superClass = Union2.createFirst((Object)superClassName.toString());
        } else {
            this.possibleFQSuperClassNames = Collections.emptyList();
            this.superClass = Union2.createFirst(null);
        }
    }

    ClassScopeImpl(IndexScope inScope, ClassElement indexedClass) {
        super((Scope)inScope, indexedClass);
        QualifiedName superClassName = indexedClass.getSuperClassName();
        this.superClass = Union2.createFirst((Object)(superClassName != null ? superClassName.toString() : null));
        this.possibleFQSuperClassNames = indexedClass.getPossibleFQSuperClassNames();
    }

    @Override
    public Collection<QualifiedName> getPossibleFQSuperClassNames() {
        return this.possibleFQSuperClassNames;
    }

    @Override
    @NonNull
    public Collection<? extends ClassScope> getSuperClasses() {
        List retval = null;
        if (this.superClass.hasSecond() && this.superClass.second() != null) {
            return (Collection)this.superClass.second();
        }
        assert (this.superClass.hasFirst());
        String superClasName = (String)this.superClass.first();
        if (this.possibleFQSuperClassNames != null && this.possibleFQSuperClassNames.size() > 0) {
            retval = new ArrayList();
            for (QualifiedName qualifiedName : this.possibleFQSuperClassNames) {
                retval.addAll(IndexScopeImpl.getClasses(qualifiedName, this));
            }
        }
        if (retval == null && superClasName != null) {
            return IndexScopeImpl.getClasses(QualifiedName.create(superClasName), this);
        }
        return retval != null ? retval : Collections.emptyList();
    }

    @Override
    public String toString() {
        Collection implementedInterfaces;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        Collection<? extends ClassScope> extendedClasses = this.getSuperClasses();
        ClassScope extClass = ModelUtils.getFirst(extendedClasses);
        if (extClass != null) {
            sb.append(" extends ").append(extClass.getName());
        }
        if ((implementedInterfaces = this.getSuperInterfaceScopes()).size() > 0) {
            sb.append(" implements ");
            for (InterfaceScope interfaceScope : implementedInterfaces) {
                sb.append(interfaceScope.getName()).append(" ");
            }
        }
        return sb.toString();
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        StringBuilder retval = new StringBuilder();
        switch (as) {
            case NameAndSuperTypes: {
                retval.append(this.getName());
            }
            case SuperTypes: {
                Set<QualifiedName> superIfaces;
                QualifiedName superClassName = this.getSuperClassName();
                if (superClassName != null) {
                    retval.append(" extends  ");
                    retval.append(superClassName.getName());
                }
                if (!(superIfaces = this.getSuperInterfaces()).isEmpty()) {
                    retval.append(" implements ");
                }
                StringBuilder ifacesBuffer = new StringBuilder();
                for (QualifiedName qualifiedName : superIfaces) {
                    if (ifacesBuffer.length() > 0) {
                        ifacesBuffer.append(", ");
                    }
                    ifacesBuffer.append(qualifiedName.getName());
                }
                retval.append((CharSequence)ifacesBuffer);
            }
        }
        return retval.toString();
    }

    @Override
    public Collection<? extends FieldElement> getDeclaredFields() {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScopeImpl = ModelUtils.getIndexScope(this);
            return indexScopeImpl.findFields((ClassScope)this, new int[0]);
        }
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.FIELD);
            }
        });
    }

    @Override
    public Collection<? extends MethodScope> getInheritedMethods() {
        HashSet<MethodScopeImpl> allMethods = new HashSet<MethodScopeImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        HashSet<? extends ClassScope> superClasses = new HashSet<ClassScope>(this.getSuperClasses());
        for (ClassScope classScope : superClasses) {
            Set<MethodElement> indexedFunctions = ElementFilter.forPrivateModifiers(false).filter(index.getAllMethods(classScope));
            for (MethodElement classMember : indexedFunctions) {
                MethodElement indexedFunction = classMember;
                TypeElement type = indexedFunction.getType();
                if (type.isInterface()) {
                    allMethods.add(new MethodScopeImpl((Scope)new InterfaceScopeImpl(indexScope, (InterfaceElement)type), indexedFunction));
                    continue;
                }
                allMethods.add(new MethodScopeImpl((Scope)new ClassScopeImpl(indexScope, (ClassElement)type), indexedFunction));
            }
        }
        HashSet interfaceScopes = new HashSet(this.getSuperInterfaceScopes());
        for (InterfaceScope iface : interfaceScopes) {
            Set<MethodElement> indexedFunctions = ElementFilter.forPrivateModifiers(false).filter(index.getAllMethods(iface));
            for (MethodElement classMember : indexedFunctions) {
                MethodElement indexedFunction = classMember;
                TypeElement type = indexedFunction.getType();
                if (type.isInterface()) {
                    allMethods.add(new MethodScopeImpl((Scope)new InterfaceScopeImpl(indexScope, (InterfaceElement)type), indexedFunction));
                    continue;
                }
                allMethods.add(new MethodScopeImpl((Scope)new ClassScopeImpl(indexScope, (ClassElement)type), indexedFunction));
            }
        }
        return allMethods;
    }

    @Override
    public Collection<? extends FieldElement> getInheritedFields() {
        HashSet<FieldElementImpl> allFields = new HashSet<FieldElementImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        HashSet<? extends ClassScope> superClasses = new HashSet<ClassScope>(this.getSuperClasses());
        for (ClassScope classScope : superClasses) {
            Set<org.netbeans.modules.php.editor.api.elements.FieldElement> indexedFields = ElementFilter.forPrivateModifiers(false).filter(index.getAlllFields(classScope));
            for (org.netbeans.modules.php.editor.api.elements.FieldElement field : indexedFields) {
                allFields.add(new FieldElementImpl(classScope, field));
            }
        }
        return allFields;
    }

    @Override
    public final Collection<? extends ClassConstantElement> getInheritedConstants() {
        HashSet<ClassConstantElementImpl> allConstants = new HashSet<ClassConstantElementImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        HashSet<? extends ClassScope> superClasses = new HashSet<ClassScope>(this.getSuperClasses());
        for (ClassScope classScope : superClasses) {
            Set<TypeConstantElement> indexedConstants = index.getAllTypeConstants(classScope);
            Iterator<TypeConstantElement> i$ = indexedConstants.iterator();
            while (i$.hasNext()) {
                TypeConstantElement classMember;
                TypeConstantElement constant = classMember = i$.next();
                allConstants.add(new ClassConstantElementImpl((Scope)classScope, constant));
            }
        }
        HashSet interfaceScopes = new HashSet();
        interfaceScopes.addAll(this.getSuperInterfaceScopes());
        for (InterfaceScope iface : interfaceScopes) {
            Set<TypeConstantElement> indexedConstants = index.getInheritedTypeConstants(iface);
            Iterator i$ = indexedConstants.iterator();
            while (i$.hasNext()) {
                TypeConstantElement classMember;
                TypeConstantElement constant = classMember = (TypeConstantElement)i$.next();
                allConstants.add(new ClassConstantElementImpl((Scope)iface, constant));
            }
        }
        return allConstants;
    }

    @Override
    public Collection<? extends MethodScope> getMethods() {
        HashSet<MethodScope> allMethods = new HashSet<MethodScope>();
        allMethods.addAll(this.getDeclaredMethods());
        allMethods.addAll(this.getInheritedMethods());
        return allMethods;
    }

    @Override
    public String getNormalizedName() {
        return super.getNormalizedName() + (this.getSuperClassName() != null ? this.getSuperClassName() : "");
    }

    @Override
    @NonNull
    public QualifiedName getSuperClassName() {
        List retval = null;
        if (this.superClass != null) {
            ClassScope cls;
            List list = retval = this.superClass.hasSecond() ? (List)this.superClass.second() : null;
            if (retval == null) {
                assert (this.superClass.hasFirst());
                String superClasName = (String)this.superClass.first();
                if (superClasName != null) {
                    return QualifiedName.create(superClasName);
                }
            } else if (retval.size() > 0 && (cls = (ClassScope)ModelUtils.getFirst(retval)) != null) {
                return QualifiedName.create(cls.getName());
            }
        }
        return null;
    }

    @Override
    public String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(";");
        sb.append(this.getName()).append(";");
        sb.append(this.getOffset()).append(";");
        QualifiedName superClassName = this.getSuperClassName();
        if (superClassName != null) {
            sb.append(superClassName.toString());
            sb.append("|");
            boolean first = true;
            for (QualifiedName qualifiedName : this.possibleFQSuperClassNames) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = true;
                }
                sb.append(qualifiedName.toString());
            }
        }
        sb.append(";");
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        sb.append(qualifiedName.toString()).append(";");
        Collection superInterfaceNames = this.getSuperInterfaceNames();
        StringBuilder ifaceSb = new StringBuilder();
        for (String iface : superInterfaceNames) {
            if (ifaceSb.length() > 0) {
                ifaceSb.append(",");
            }
            ifaceSb.append(iface);
        }
        sb.append((CharSequence)ifaceSb);
        sb.append(";");
        sb.append(this.getPhpModifiers().toFlags()).append(";");
        return sb.toString();
    }

    @Override
    public Collection<? extends MethodScope> getDeclaredConstructors() {
        return ModelUtils.filter(this.getDeclaredMethods(), new ModelUtils.ElementFilter<MethodScope>(){

            @Override
            public boolean isAccepted(MethodScope methodScope) {
                return methodScope.isConstructor();
            }
        });
    }

    @Override
    public String getDefaultConstructorIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(";");
        sb.append(this.getName()).append(";");
        sb.append(this.getOffset()).append(";");
        sb.append(";");
        sb.append(";");
        sb.append(1).append(";");
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        sb.append(qualifiedName.toString()).append(";");
        return sb.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof ClassElement) {
            ClassElement indexedClass = (ClassElement)this.indexedElement;
            return indexedClass.getNamespaceName();
        }
        return super.getNamespaceName();
    }

    @Override
    public Collection<? extends String> getSuperClassNames() {
        String supeClsName;
        String string = supeClsName = this.superClass.hasFirst() ? (String)this.superClass.first() : null;
        if (supeClsName != null) {
            return Collections.singletonList(supeClsName);
        }
        List supeClasses = Collections.emptyList();
        if (this.superClass.hasSecond()) {
            supeClasses = (List)this.superClass.second();
        }
        ArrayList<String> retval = new ArrayList<String>();
        for (ClassScopeImpl cls : supeClasses) {
            retval.add(cls.getName());
        }
        return retval;
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                LazyBuild scope;
                if (element instanceof MethodScopeImpl && ((MethodScopeImpl)element).isConstructor() && element instanceof LazyBuild && !(scope = (LazyBuild)((Object)element)).isScanned()) {
                    scope.scan();
                }
                boolean value = element.getPhpElementKind().equals((Object)PhpElementKind.VARIABLE);
                return value;
            }
        });
    }

    @Override
    public VariableNameImpl createElement(Variable node) {
        VariableNameImpl retval = new VariableNameImpl((Scope)this, node, false);
        this.addElement(retval);
        return retval;
    }

    @Override
    public boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }
}

