/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;

public class PhpDocTypeTagInfo
extends ASTNodeInfo<PHPDocNode> {
    private PHPDocTypeTag typeTag;
    private ASTNodeInfo.Kind kind;
    private String typeName;

    private PhpDocTypeTagInfo(PHPDocTypeTag typeTag, PHPDocNode node, String typeName, ASTNodeInfo.Kind kind) {
        super(node);
        this.typeTag = typeTag;
        this.kind = kind;
        this.typeName = typeName;
    }

    public static List<? extends PhpDocTypeTagInfo> create(PHPDocTypeTag typeTag, ASTNodeInfo.Kind kind) {
        ArrayList<PhpDocTypeTagInfo> retval = new ArrayList<PhpDocTypeTagInfo>();
        List<PHPDocTypeNode> types = typeTag.getTypes();
        if (!types.isEmpty()) {
            for (PHPDocTypeNode docNode : types) {
                retval.add(new PhpDocTypeTagInfo(typeTag, docNode, docNode.getValue(), ASTNodeInfo.Kind.CLASS));
            }
        }
        if (!kind.equals((Object)ASTNodeInfo.Kind.CLASS) && typeTag instanceof PHPDocVarTypeTag) {
            PHPDocVarTypeTag varTypeTag = (PHPDocVarTypeTag)typeTag;
            if (types.isEmpty()) {
                retval.add(new PhpDocTypeTagInfo(typeTag, varTypeTag.getVariable(), varTypeTag.getVariable().getValue(), kind));
            } else {
                for (PHPDocTypeNode docNode : types) {
                    retval.add(new PhpDocTypeTagInfo(typeTag, varTypeTag.getVariable(), docNode.getValue(), kind));
                }
            }
        }
        return retval;
    }

    public static List<? extends PhpDocTypeTagInfo> create(PHPDocTypeTag typeTag, Scope scope) {
        ASTNodeInfo.Kind kind = ASTNodeInfo.Kind.CLASS;
        kind = scope instanceof ClassScope ? ASTNodeInfo.Kind.FIELD : ASTNodeInfo.Kind.VARIABLE;
        return PhpDocTypeTagInfo.create(typeTag, kind);
    }

    public PHPDocTypeTag getTypeTag() {
        return this.typeTag;
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return this.kind;
    }

    public String getTypeName() {
        return this.typeName != null ? this.typeName : null;
    }

    @Override
    public String getName() {
        PHPDocNode docNode = (PHPDocNode)this.getOriginalNode();
        String value = docNode.getValue();
        int idx = value.indexOf("::");
        if (idx != -1) {
            value = value.substring(0, idx);
        }
        if (this.getKind().equals((Object)ASTNodeInfo.Kind.CLASS)) {
            QualifiedName qn = QualifiedName.create(value);
            value = qn.toName().toString();
        }
        return value;
    }

    @Override
    public QualifiedName getQualifiedName() {
        if (ASTNodeInfo.Kind.VARIABLE.equals((Object)this.getKind()) || ASTNodeInfo.Kind.FIELD.equals((Object)this.getKind())) {
            QualifiedName.createUnqualifiedName(this.getName());
        }
        return QualifiedName.create(this.getTypeName());
    }

    @Override
    public OffsetRange getRange() {
        PHPDocNode node = (PHPDocNode)this.getOriginalNode();
        if (ASTNodeInfo.Kind.VARIABLE.equals((Object)this.getKind()) || ASTNodeInfo.Kind.FIELD.equals((Object)this.getKind())) {
            return new OffsetRange(node.getStartOffset() + 1, node.getStartOffset() + this.getName().length());
        }
        QualifiedName typeQN = QualifiedName.create(this.typeName);
        QualifiedName namespaceName = typeQN.toNamespaceName(typeQN.getKind().isFullyQualified());
        int nsNameLength = namespaceName.toString().length();
        int startOffset = node.getStartOffset();
        if (nsNameLength > 0) {
            startOffset += nsNameLength;
            if (namespaceName.getSegments().size() > 0) {
                ++startOffset;
            }
        }
        return new OffsetRange(startOffset, startOffset + typeQN.toName().toString().length());
    }

    public PhpModifiers getAccessModifiers() {
        return PhpModifiers.fromBitMask(1);
    }
}

