/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.options;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeCompletionPanel
extends JPanel {
    private static final long serialVersionUID = -24730122182427272L;
    static final String PHP_AUTO_COMPLETION_FULL = "phpAutoCompletionFull";
    static final String PHP_AUTO_COMPLETION_VARIABLES = "phpAutoCompletionVariables";
    static final String PHP_AUTO_COMPLETION_TYPES = "phpAutoCompletionTypes";
    static final String PHP_AUTO_COMPLETION_NAMESPACES = "phpAutoCompletionNamespaces";
    static final String PHP_CODE_COMPLETION_STATIC_METHODS = "phpCodeCompletionStaticMethods";
    static final String PHP_CODE_COMPLETION_NON_STATIC_METHODS = "phpCodeCompletionNonStaticMethods";
    static final String PHP_CODE_COMPLETION_VARIABLES_SCOPE = "phpCodeCompletionVariablesScope";
    static final String PHP_CODE_COMPLETION_TYPE = "phpCodeCompletionType";
    static final String PHP_CODE_COMPLETION_SMART_PARAMETERS_PRE_FILLING = "phpCodeCompletionSmartParametersPreFilling";
    static final boolean PHP_AUTO_COMPLETION_FULL_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_VARIABLES_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_TYPES_DEFAULT = true;
    static final boolean PHP_AUTO_COMPLETION_NAMESPACES_DEFAULT = true;
    static final boolean PHP_CODE_COMPLETION_STATIC_METHODS_DEFAULT = true;
    static final boolean PHP_CODE_COMPLETION_NON_STATIC_METHODS_DEFAULT = false;
    static final boolean PHP_CODE_COMPLETION_SMART_PARAMETERS_PRE_FILLING_DEFAULT = true;
    private final Preferences preferences;
    private final ItemListener defaultCheckBoxListener = new DefaultCheckBoxListener();
    private final ItemListener defaultRadioButtonListener = new DefaultRadioButtonListener();
    private JRadioButton allVariablesRadioButton;
    private ButtonGroup autoCompletionButtonGroup;
    private JRadioButton autoCompletionCustomizeRadioButton;
    private JRadioButton autoCompletionFullRadioButton;
    private JCheckBox autoCompletionNamespacesCheckBox;
    private JCheckBox autoCompletionTypesCheckBox;
    private JCheckBox autoCompletionVariablesCheckBox;
    private JCheckBox codeCompletionNonStaticMethodsCheckBox;
    private JCheckBox codeCompletionSmartParametersPreFillingCheckBox;
    private JCheckBox codeCompletionStaticMethodsCheckBox;
    private ButtonGroup codeCompletionTypeButtonGroup;
    private JLabel codeCompletionTypeLabel;
    private ButtonGroup codeCompletionVariablesScopeButtonGroup;
    private JLabel codeCompletionVariablesScopeLabel;
    private JRadioButton currentFileVariablesRadioButton;
    private JLabel enableAutocompletionLabel;
    private JLabel fullyQualifiedInfoLabel;
    private JRadioButton fullyQualifiedRadioButton;
    private JLabel methodCodeCompletionLabel;
    private JLabel smartInfoLabel;
    private JRadioButton smartRadioButton;
    private JLabel unqualifiedInfoLabel;
    private JRadioButton unqualifiedRadioButton;

    public CodeCompletionPanel(Preferences preferences) {
        assert (preferences != null);
        this.preferences = preferences;
        this.initComponents();
        this.initAutoCompletion();
        this.initCodeCompletionForMethods();
        this.initCodeCompletionForVariables();
        this.initCodeCompletionType();
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return new PreferencesCustomizer.Factory(){

            public PreferencesCustomizer create(Preferences preferences) {
                return new CodeCompletionPreferencesCustomizer(preferences);
            }
        };
    }

    private void initAutoCompletion() {
        this.autoCompletionFullRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CodeCompletionPanel.this.setAutoCompletionState(false);
                }
            }
        });
        this.autoCompletionCustomizeRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CodeCompletionPanel.this.setAutoCompletionState(true);
                }
            }
        });
        boolean autoCompletionFull = this.preferences.getBoolean(PHP_AUTO_COMPLETION_FULL, true);
        if (autoCompletionFull) {
            this.autoCompletionFullRadioButton.setSelected(true);
        } else {
            this.autoCompletionCustomizeRadioButton.setSelected(true);
        }
        this.autoCompletionFullRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.autoCompletionCustomizeRadioButton.addItemListener(this.defaultRadioButtonListener);
        boolean autoCompletionVariables = this.preferences.getBoolean(PHP_AUTO_COMPLETION_VARIABLES, true);
        this.autoCompletionVariablesCheckBox.setSelected(autoCompletionVariables);
        this.autoCompletionVariablesCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean autoCompletionTypes = this.preferences.getBoolean(PHP_AUTO_COMPLETION_TYPES, true);
        this.autoCompletionTypesCheckBox.setSelected(autoCompletionTypes);
        this.autoCompletionTypesCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean autoCompletionNamespaces = this.preferences.getBoolean(PHP_AUTO_COMPLETION_NAMESPACES, true);
        this.autoCompletionNamespacesCheckBox.setSelected(autoCompletionNamespaces);
        this.autoCompletionNamespacesCheckBox.addItemListener(this.defaultCheckBoxListener);
    }

    private void initCodeCompletionForMethods() {
        boolean codeCompletionStaticMethods = this.preferences.getBoolean(PHP_CODE_COMPLETION_STATIC_METHODS, true);
        this.codeCompletionStaticMethodsCheckBox.setSelected(codeCompletionStaticMethods);
        this.codeCompletionStaticMethodsCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean codeCompletionNonStaticMethods = this.preferences.getBoolean(PHP_CODE_COMPLETION_NON_STATIC_METHODS, false);
        this.codeCompletionNonStaticMethodsCheckBox.setSelected(codeCompletionNonStaticMethods);
        this.codeCompletionNonStaticMethodsCheckBox.addItemListener(this.defaultCheckBoxListener);
        boolean codeCompletionSmartParametersPreFilling = this.preferences.getBoolean(PHP_CODE_COMPLETION_SMART_PARAMETERS_PRE_FILLING, true);
        this.codeCompletionSmartParametersPreFillingCheckBox.setSelected(codeCompletionSmartParametersPreFilling);
        this.codeCompletionSmartParametersPreFillingCheckBox.addItemListener(this.defaultCheckBoxListener);
    }

    private void initCodeCompletionForVariables() {
        VariablesScope variablesScope = VariablesScope.resolve(this.preferences.get(PHP_CODE_COMPLETION_VARIABLES_SCOPE, null));
        switch (variablesScope) {
            case ALL: {
                this.allVariablesRadioButton.setSelected(true);
                break;
            }
            case CURRENT_FILE: {
                this.currentFileVariablesRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown variables scope: " + (Object)((Object)variablesScope));
            }
        }
        this.allVariablesRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.currentFileVariablesRadioButton.addItemListener(this.defaultRadioButtonListener);
    }

    private void initCodeCompletionType() {
        CodeCompletionType type = CodeCompletionType.resolve(this.preferences.get(PHP_CODE_COMPLETION_TYPE, null));
        switch (type) {
            case SMART: {
                this.smartRadioButton.setSelected(true);
                break;
            }
            case FULLY_QUALIFIED: {
                this.fullyQualifiedRadioButton.setSelected(true);
                break;
            }
            case UNQUALIFIED: {
                this.unqualifiedRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown code completion type: " + (Object)((Object)type));
            }
        }
        this.smartRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.fullyQualifiedRadioButton.addItemListener(this.defaultRadioButtonListener);
        this.unqualifiedRadioButton.addItemListener(this.defaultRadioButtonListener);
    }

    void validateData() {
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_FULL, this.autoCompletionFullRadioButton.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_VARIABLES, this.autoCompletionVariablesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_TYPES, this.autoCompletionTypesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_AUTO_COMPLETION_NAMESPACES, this.autoCompletionNamespacesCheckBox.isSelected());
        this.preferences.putBoolean(PHP_CODE_COMPLETION_STATIC_METHODS, this.codeCompletionStaticMethodsCheckBox.isSelected());
        this.preferences.putBoolean(PHP_CODE_COMPLETION_NON_STATIC_METHODS, this.codeCompletionNonStaticMethodsCheckBox.isSelected());
        this.preferences.putBoolean(PHP_CODE_COMPLETION_SMART_PARAMETERS_PRE_FILLING, this.codeCompletionSmartParametersPreFillingCheckBox.isSelected());
        VariablesScope variablesScope = null;
        if (this.allVariablesRadioButton.isSelected()) {
            variablesScope = VariablesScope.ALL;
        } else if (this.currentFileVariablesRadioButton.isSelected()) {
            variablesScope = VariablesScope.CURRENT_FILE;
        }
        assert (variablesScope != null);
        this.preferences.put(PHP_CODE_COMPLETION_VARIABLES_SCOPE, variablesScope.name());
        CodeCompletionType type = null;
        if (this.smartRadioButton.isSelected()) {
            type = CodeCompletionType.SMART;
        } else if (this.fullyQualifiedRadioButton.isSelected()) {
            type = CodeCompletionType.FULLY_QUALIFIED;
        } else if (this.unqualifiedRadioButton.isSelected()) {
            type = CodeCompletionType.UNQUALIFIED;
        }
        assert (type != null);
        this.preferences.put(PHP_CODE_COMPLETION_TYPE, type.name());
    }

    void setAutoCompletionState(boolean enabled) {
        this.autoCompletionVariablesCheckBox.setEnabled(enabled);
        this.autoCompletionTypesCheckBox.setEnabled(enabled);
        this.autoCompletionNamespacesCheckBox.setEnabled(enabled);
    }

    private void initComponents() {
        this.codeCompletionTypeButtonGroup = new ButtonGroup();
        this.codeCompletionVariablesScopeButtonGroup = new ButtonGroup();
        this.autoCompletionButtonGroup = new ButtonGroup();
        this.enableAutocompletionLabel = new JLabel();
        this.autoCompletionFullRadioButton = new JRadioButton();
        this.autoCompletionCustomizeRadioButton = new JRadioButton();
        this.autoCompletionVariablesCheckBox = new JCheckBox();
        this.autoCompletionTypesCheckBox = new JCheckBox();
        this.autoCompletionNamespacesCheckBox = new JCheckBox();
        this.methodCodeCompletionLabel = new JLabel();
        this.codeCompletionStaticMethodsCheckBox = new JCheckBox();
        this.codeCompletionNonStaticMethodsCheckBox = new JCheckBox();
        this.codeCompletionVariablesScopeLabel = new JLabel();
        this.allVariablesRadioButton = new JRadioButton();
        this.currentFileVariablesRadioButton = new JRadioButton();
        this.codeCompletionTypeLabel = new JLabel();
        this.smartRadioButton = new JRadioButton();
        this.smartInfoLabel = new JLabel();
        this.fullyQualifiedRadioButton = new JRadioButton();
        this.fullyQualifiedInfoLabel = new JLabel();
        this.unqualifiedRadioButton = new JRadioButton();
        this.unqualifiedInfoLabel = new JLabel();
        this.codeCompletionSmartParametersPreFillingCheckBox = new JCheckBox();
        this.setFocusTraversalPolicy(null);
        this.enableAutocompletionLabel.setLabelFor(this.autoCompletionFullRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.enableAutocompletionLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.enableAutocompletionLabel.text"));
        this.autoCompletionButtonGroup.add(this.autoCompletionFullRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionFullRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionFullRadioButton.text"));
        this.autoCompletionButtonGroup.add(this.autoCompletionCustomizeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionCustomizeRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCustomizeRadioButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionVariablesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionVariablesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionTypesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTypesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionNamespacesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionNamespacesCheckBox.text"));
        this.methodCodeCompletionLabel.setLabelFor(this.codeCompletionStaticMethodsCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.methodCodeCompletionLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.methodCodeCompletionLabel.text"));
        this.codeCompletionStaticMethodsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.codeCompletionStaticMethodsCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionStaticMethodsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.codeCompletionNonStaticMethodsCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionNonStaticMethodsCheckBox.text"));
        this.codeCompletionVariablesScopeLabel.setLabelFor(this.allVariablesRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.codeCompletionVariablesScopeLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionVariablesScopeLabel.text"));
        this.codeCompletionVariablesScopeButtonGroup.add(this.allVariablesRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.allVariablesRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.allVariablesRadioButton.text"));
        this.codeCompletionVariablesScopeButtonGroup.add(this.currentFileVariablesRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.currentFileVariablesRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.currentFileVariablesRadioButton.text"));
        this.codeCompletionTypeLabel.setLabelFor(this.smartRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.codeCompletionTypeLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionTypeLabel.text"));
        this.codeCompletionTypeButtonGroup.add(this.smartRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.smartRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartRadioButton.text"));
        this.smartInfoLabel.setLabelFor(this.smartRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.smartInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartInfoLabel.text"));
        this.codeCompletionTypeButtonGroup.add(this.fullyQualifiedRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.fullyQualifiedRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedRadioButton.text"));
        this.fullyQualifiedInfoLabel.setLabelFor(this.fullyQualifiedRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.fullyQualifiedInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedInfoLabel.text"));
        this.codeCompletionTypeButtonGroup.add(this.unqualifiedRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.unqualifiedRadioButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedRadioButton.text"));
        this.unqualifiedInfoLabel.setLabelFor(this.unqualifiedRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.unqualifiedInfoLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedInfoLabel.text"));
        this.codeCompletionSmartParametersPreFillingCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.codeCompletionSmartParametersPreFillingCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionSmartParametersPreFillingCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoCompletionCustomizeRadioButton).addComponent(this.autoCompletionFullRadioButton).addComponent(this.methodCodeCompletionLabel).addComponent(this.codeCompletionNonStaticMethodsCheckBox).addComponent(this.codeCompletionStaticMethodsCheckBox).addComponent(this.enableAutocompletionLabel).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoCompletionTypesCheckBox).addComponent(this.autoCompletionVariablesCheckBox).addComponent(this.autoCompletionNamespacesCheckBox))).addComponent(this.currentFileVariablesRadioButton).addComponent(this.allVariablesRadioButton).addComponent(this.codeCompletionTypeLabel).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.smartInfoLabel)).addComponent(this.smartRadioButton).addComponent(this.fullyQualifiedRadioButton).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.fullyQualifiedInfoLabel)).addComponent(this.unqualifiedRadioButton).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.unqualifiedInfoLabel)).addComponent(this.codeCompletionVariablesScopeLabel).addComponent(this.codeCompletionSmartParametersPreFillingCheckBox)).addContainerGap(109, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.enableAutocompletionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionFullRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionCustomizeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionVariablesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionTypesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionNamespacesCheckBox).addGap(18, 18, 18).addComponent(this.methodCodeCompletionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeCompletionStaticMethodsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeCompletionNonStaticMethodsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.codeCompletionSmartParametersPreFillingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.codeCompletionVariablesScopeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allVariablesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentFileVariablesRadioButton).addGap(18, 18, 18).addComponent(this.codeCompletionTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.smartRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.smartInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fullyQualifiedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fullyQualifiedInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unqualifiedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unqualifiedInfoLabel).addGap(42, 42, 42)));
        this.enableAutocompletionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.enableAutocompletionLabel.AccessibleContext.accessibleName"));
        this.enableAutocompletionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.enableAutocompletionLabel.AccessibleContext.accessibleDescription"));
        this.autoCompletionFullRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionFullRadioButton.AccessibleContext.accessibleName"));
        this.autoCompletionFullRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionFullRadioButton.AccessibleContext.accessibleDescription"));
        this.autoCompletionCustomizeRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCustomizeRadioButton.AccessibleContext.accessibleName"));
        this.autoCompletionCustomizeRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionCustomizeRadioButton.AccessibleContext.accessibleDescription"));
        this.autoCompletionVariablesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionVariablesCheckBox.AccessibleContext.accessibleName"));
        this.autoCompletionVariablesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionVariablesCheckBox.AccessibleContext.accessibleDescription"));
        this.autoCompletionTypesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTypesCheckBox.AccessibleContext.accessibleName"));
        this.autoCompletionTypesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTypesCheckBox.AccessibleContext.accessibleDescription"));
        this.autoCompletionNamespacesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionNamespacesCheckBox.AccessibleContext.accessibleName"));
        this.autoCompletionNamespacesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionNamespacesCheckBox.AccessibleContext.accessibleDescription"));
        this.methodCodeCompletionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.methodCodeCompletionLabel.AccessibleContext.accessibleName"));
        this.methodCodeCompletionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.methodCodeCompletionLabel.AccessibleContext.accessibleDescription"));
        this.codeCompletionStaticMethodsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionStaticMethodsCheckBox.AccessibleContext.accessibleName"));
        this.codeCompletionStaticMethodsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionStaticMethodsCheckBox.AccessibleContext.accessibleDescription"));
        this.codeCompletionNonStaticMethodsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionNonStaticMethodsCheckBox.AccessibleContext.accessibleName"));
        this.codeCompletionNonStaticMethodsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionNonStaticMethodsCheckBox.AccessibleContext.accessibleDescription"));
        this.codeCompletionVariablesScopeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionVariablesScopeLabel.AccessibleContext.accessibleName"));
        this.codeCompletionVariablesScopeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionVariablesScopeLabel.AccessibleContext.accessibleDescription"));
        this.allVariablesRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.allVariablesRadioButton.AccessibleContext.accessibleName"));
        this.allVariablesRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.allVariablesRadioButton.AccessibleContext.accessibleDescription"));
        this.currentFileVariablesRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.currentFileVariablesRadioButton.AccessibleContext.accessibleName"));
        this.currentFileVariablesRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.currentFileVariablesRadioButton.AccessibleContext.accessibleDescription"));
        this.codeCompletionTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionTypeLabel.AccessibleContext.accessibleName"));
        this.codeCompletionTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.codeCompletionTypeLabel.AccessibleContext.accessibleDescription"));
        this.smartRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartRadioButton.AccessibleContext.accessibleName"));
        this.smartRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartRadioButton.AccessibleContext.accessibleDescription"));
        this.smartInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.smartInfoLabel.AccessibleContext.accessibleDescription"));
        this.fullyQualifiedRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedRadioButton.AccessibleContext.accessibleName"));
        this.fullyQualifiedRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedRadioButton.AccessibleContext.accessibleDescription"));
        this.fullyQualifiedInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedInfoLabel.AccessibleContext.accessibleName"));
        this.fullyQualifiedInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.fullyQualifiedInfoLabel.AccessibleContext.accessibleDescription"));
        this.unqualifiedRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedRadioButton.AccessibleContext.accessibleName"));
        this.unqualifiedRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedRadioButton.AccessibleContext.accessibleDescription"));
        this.unqualifiedInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.unqualifiedInfoLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.AccessibleContext.accessibleDescription"));
    }

    static final class CodeCompletionPreferencesCustomizer
    implements PreferencesCustomizer {
        private final Preferences preferences;

        private CodeCompletionPreferencesCustomizer(Preferences preferences) {
            this.preferences = preferences;
        }

        public String getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getDisplayName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(CodeCompletionPanel.class);
        }

        public JComponent getComponent() {
            return new CodeCompletionPanel(this.preferences);
        }
    }

    private final class DefaultCheckBoxListener
    implements ItemListener {
        private DefaultCheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CodeCompletionPanel.this.validateData();
        }
    }

    private final class DefaultRadioButtonListener
    implements ItemListener {
        private DefaultRadioButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                CodeCompletionPanel.this.validateData();
            }
        }
    }

    public static enum VariablesScope {
        ALL,
        CURRENT_FILE;


        public static VariablesScope resolve(String value) {
            if (value != null) {
                try {
                    return VariablesScope.valueOf(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return ALL;
        }
    }

    public static enum CodeCompletionType {
        SMART,
        FULLY_QUALIFIED,
        UNQUALIFIED;


        public static CodeCompletionType resolve(String value) {
            if (value != null) {
                try {
                    return CodeCompletionType.valueOf(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return SMART;
        }
    }
}

