/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class Assignment
extends Expression {
    private VariableBase leftHandSide;
    private Type operator;
    private Expression rightHandSide;

    public Assignment(int start, int end, VariableBase leftHandSide, Type operator, Expression rightHandSide) {
        super(start, end);
        if (leftHandSide == null || rightHandSide == null) {
            throw new IllegalArgumentException();
        }
        this.leftHandSide = leftHandSide;
        this.operator = operator;
        this.rightHandSide = rightHandSide;
    }

    public Type getOperator() {
        return this.operator;
    }

    public VariableBase getLeftHandSide() {
        return this.leftHandSide;
    }

    public Expression getRightHandSide() {
        return this.rightHandSide;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public static enum Type {
        EQUAL("="),
        PLUS_EQUAL("+="),
        MINUS_EQUAL("-="),
        MUL_EQUAL("*="),
        DIV_EQUAL("/="),
        CONCAT_EQUAL(".="),
        MOD_EQUAL("%="),
        AND_EQUAL("&="),
        OR_EQUAL("|="),
        XOR_EQUAL("^="),
        SL_EQUAL("<<="),
        SR_EQUAL(">>=");

        private String operator;

        private Type(String operator) {
            this.operator = operator;
        }

        public String toString() {
            return this.operator;
        }
    }
}

