/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class PHPDocTypeTag
extends PHPDocTag {
    public static final List<String> ORDINAL_TYPES = Arrays.asList("NULL", "INT", "INTEGER", "BOOL", "STRING");
    private final List<PHPDocTypeNode> types;
    protected String documentation;

    public PHPDocTypeTag(int start, int end, PHPDocTag.Type kind, String value, List<PHPDocTypeNode> types) {
        super(start, end, kind, value);
        this.types = types;
        this.documentation = null;
    }

    public List<PHPDocTypeNode> getTypes() {
        return this.types;
    }

    @Override
    public String getDocumentation() {
        if (this.documentation == null && this.types.size() > 0) {
            PHPDocTypeNode lastType = this.types.get(0);
            for (PHPDocTypeNode node : this.types) {
                if (lastType.getEndOffset() >= node.getEndOffset()) continue;
                lastType = node;
            }
            int index = this.getValue().indexOf(lastType.getValue());
            this.documentation = this.getValue().substring(index + lastType.getValue().length()).trim();
        }
        return this.documentation;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

