/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class AbstractClassInstantiationHint
extends AbstractRule {
    private static final String HINT_ID = "Abstract.Class.Instantiation.Hint";

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.getIndex());
        phpParseResult.getProgram().accept(checkVisitor);
        hints.addAll(checkVisitor.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.AbstractClassInstantiationHintDesc();
    }

    public String getDisplayName() {
        return Bundle.AbstractClassInstantiationHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final ElementQuery.Index index;
        private final List<Hint> hints = new LinkedList<Hint>();

        private CheckVisitor(FileObject fileObject, ElementQuery.Index index) {
            this.fileObject = fileObject;
            this.index = index;
        }

        public List<Hint> getHints() {
            return this.hints;
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            ClassElement classElement;
            ASTNodeInfo<ClassInstanceCreation> info = ASTNodeInfo.create(node);
            Set<ClassElement> classes = this.index.getClasses(NameKind.exact(info.getQualifiedName()));
            if (!classes.isEmpty() && (classElement = ModelUtils.getFirst(classes)).isAbstract()) {
                OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
                this.hints.add(new Hint((Rule)AbstractClassInstantiationHint.this, Bundle.AbstractClassInstantiationDesc(classElement.getFullyQualifiedName().toString()), this.fileObject, offsetRange, null, 500));
            }
        }
    }
}

