/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ModifiersCheckHint
extends AbstractRule {
    private static final String HINT_ID = "Modifiers.Check.Hint";
    private List<Hint> hints;
    private FileObject fileObject;
    private BaseDocument doc;
    private boolean currectClassHasAbstractMethod = false;

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        this.hints = hints;
        this.doc = context.doc;
        FileScope fileScope = context.fileScope;
        this.fileObject = context.parserResult.getSnapshot().getSource().getFileObject();
        Collection<? extends ClassScope> declaredClasses = ModelUtils.getDeclaredClasses(fileScope);
        for (ClassScope classScope : declaredClasses) {
            this.processClassScope(classScope);
        }
        Collection<? extends InterfaceScope> declaredInterfaces = ModelUtils.getDeclaredInterfaces(fileScope);
        for (InterfaceScope interfaceScope : declaredInterfaces) {
            this.processInterfaceScope(interfaceScope);
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.ModifiersCheckHintDesc();
    }

    public String getDisplayName() {
        return Bundle.ModifiersCheckHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    private void processClassScope(ClassScope classScope) {
        Collection<? extends FieldElement> declaredFields = classScope.getDeclaredFields();
        for (FieldElement fieldElement : declaredFields) {
            this.processFieldElement(fieldElement);
        }
        Collection<? extends MethodScope> declaredMethods = classScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            this.processMethodScope(methodScope);
        }
        if (this.currectClassHasAbstractMethod) {
            this.processPossibleAbstractClass(classScope);
        }
        this.currectClassHasAbstractMethod = false;
    }

    private void processFieldElement(FieldElement fieldElement) {
        PhpModifiers phpModifiers = fieldElement.getPhpModifiers();
        List<HintFix> fixes = null;
        String invalidModifier = null;
        if (phpModifiers.isAbstract()) {
            invalidModifier = "abstract";
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, fieldElement.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidField(fieldElement.getName(), invalidModifier), fieldElement.getNameRange(), fixes));
        } else if (phpModifiers.isFinal()) {
            invalidModifier = "final";
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, fieldElement.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidField(fieldElement.getName(), invalidModifier), fieldElement.getNameRange(), fixes));
        }
    }

    private void processMethodScope(MethodScope methodScope) {
        PhpModifiers phpModifiers = methodScope.getPhpModifiers();
        LinkedList<HintFix> fixes = null;
        if (phpModifiers.isAbstract() && phpModifiers.isFinal()) {
            fixes = new LinkedList<RemoveModifierFix>();
            fixes.add(new RemoveModifierFix(this.doc, "abstract", methodScope.getOffset()));
            fixes.add(new RemoveModifierFix(this.doc, "final", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.AbstractFinalMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && methodScope.getBlockRange() != null) {
            fixes = Collections.singletonList(new RemoveBodyFix(this.doc, methodScope));
            this.hints.add(new SimpleHint(Bundle.AbstractWithBlockMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && phpModifiers.isPrivate()) {
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "private", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.AbstractPrivateMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        }
        if (phpModifiers.isAbstract()) {
            this.currectClassHasAbstractMethod = true;
        }
    }

    private void processInterfaceScope(InterfaceScope interfaceScope) {
        Collection<? extends MethodScope> declaredMethods = interfaceScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            this.processInterfaceMethodScope(methodScope);
        }
    }

    private void processInterfaceMethodScope(MethodScope methodScope) {
        PhpModifiers phpModifiers = methodScope.getPhpModifiers();
        List<HintFix> fixes = null;
        String invalidModifier = null;
        if (phpModifiers.isPrivate()) {
            invalidModifier = "private";
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isProtected()) {
            invalidModifier = "protected";
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isFinal()) {
            invalidModifier = "final";
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (methodScope.getBlockRange() != null) {
            fixes = Collections.singletonList(new RemoveBodyFix(this.doc, methodScope));
            this.hints.add(new SimpleHint(Bundle.IfaceMethodWithBlock(methodScope.getName()), methodScope.getNameRange(), fixes));
        }
    }

    private void processPossibleAbstractClass(ClassScope classScope) {
        List<HintFix> fixes = null;
        if (!classScope.isAbstract()) {
            fixes = Collections.singletonList(new AddModifierFix(this.doc, "abstract", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.PossibleAbstractClass(classScope.getName()), classScope.getNameRange(), fixes));
        }
        if (classScope.isFinal()) {
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "final", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.FinalPossibleAbstractClass(classScope.getName()), classScope.getNameRange(), fixes));
        }
    }

    private static int getStartOffset(BaseDocument doc, int elementOffset) {
        int retval = 0;
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, elementOffset);
        if (ts != null) {
            ts.move(elementOffset);
            TokenId lastTokenId = null;
            while (ts.movePrevious()) {
                Token t = ts.token();
                if (t.id() != PHPTokenId.PHP_PUBLIC && t.id() != PHPTokenId.PHP_PROTECTED && t.id() != PHPTokenId.PHP_PRIVATE && t.id() != PHPTokenId.PHP_STATIC && t.id() != PHPTokenId.PHP_FINAL && t.id() != PHPTokenId.PHP_ABSTRACT && t.id() != PHPTokenId.PHP_FUNCTION && t.id() != PHPTokenId.WHITESPACE && t.id() != PHPTokenId.PHP_CLASS) {
                    ts.moveNext();
                    if (lastTokenId == PHPTokenId.WHITESPACE) {
                        ts.moveNext();
                    }
                    retval = ts.offset();
                    break;
                }
                lastTokenId = t.id();
            }
        }
        return retval;
    }

    private class AddModifierFix
    extends AbstractHintFix {
        private final String modifier;
        private final int elementOffset;

        public AddModifierFix(BaseDocument doc, String modifier, int elementOffset) {
            super(doc);
            this.modifier = modifier;
            this.elementOffset = elementOffset;
        }

        public String getDescription() {
            return Bundle.AddModifierFixDesc(this.modifier);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            int startOffset = ModifiersCheckHint.getStartOffset(this.doc, this.elementOffset);
            int length = this.elementOffset - startOffset;
            String replaceText = this.modifier + " " + this.doc.getText(startOffset, length);
            edits.replace(startOffset, length, replaceText, true, 0);
            edits.apply();
        }
    }

    private class RemoveModifierFix
    extends AbstractHintFix {
        private final String modifier;
        private final int elementOffset;

        public RemoveModifierFix(BaseDocument doc, String modifier, int elementOffset) {
            super(doc);
            this.modifier = modifier;
            this.elementOffset = elementOffset;
        }

        public String getDescription() {
            return Bundle.RemoveModifierFixDesc(this.modifier);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            int startOffset = ModifiersCheckHint.getStartOffset(this.doc, this.elementOffset);
            int length = this.elementOffset - startOffset;
            String replaceText = this.doc.getText(startOffset, length).replace(this.modifier, "").replaceAll("^\\s+", "");
            edits.replace(startOffset, length, replaceText, true, 0);
            edits.apply();
        }
    }

    private class RemoveBodyFix
    extends AbstractHintFix {
        private final MethodScope methodScope;

        public RemoveBodyFix(BaseDocument doc, MethodScope methodScope) {
            super(doc);
            this.methodScope = methodScope;
        }

        public String getDescription() {
            return Bundle.RemoveBodyFixDesc(this.methodScope.getName());
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.replace(this.methodScope.getBlockRange().getStart(), this.methodScope.getBlockRange().getLength(), ";", true, 0);
            edits.apply();
        }
    }

    private abstract class AbstractHintFix
    implements HintFix {
        protected final BaseDocument doc;

        public AbstractHintFix(BaseDocument doc) {
            this.doc = doc;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private class SimpleHint
    extends Hint {
        public SimpleHint(String description, OffsetRange range, List<HintFix> fixes) {
            super((Rule)ModifiersCheckHint.this, description, ModifiersCheckHint.this.fileObject, range, fixes, 500);
        }

        public SimpleHint(String description, OffsetRange range) {
            this(description, range, null);
        }
    }
}

