/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ContinueStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ListVariable;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocStaticAccessType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class UninitializedVariableHint
extends AbstractRule {
    private static final String HINT_ID = "Uninitialized.Variable.Hint";
    private static final List<String> UNCHECKED_VARIABLES = new LinkedList<String>();

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        CheckVisitor checkVisitor = new CheckVisitor(fileObject);
        phpParseResult.getProgram().accept(checkVisitor);
        hints.addAll(checkVisitor.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.UninitializedVariableHintDesc();
    }

    public String getDisplayName() {
        return Bundle.UninitializedVariableHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    static {
        UNCHECKED_VARIABLES.add("this");
        UNCHECKED_VARIABLES.add("GLOBALS");
        UNCHECKED_VARIABLES.add("_SERVER");
        UNCHECKED_VARIABLES.add("_GET");
        UNCHECKED_VARIABLES.add("_POST");
        UNCHECKED_VARIABLES.add("_FILES");
        UNCHECKED_VARIABLES.add("_COOKIE");
        UNCHECKED_VARIABLES.add("_SESSION");
        UNCHECKED_VARIABLES.add("_REQUEST");
        UNCHECKED_VARIABLES.add("_ENV");
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final Stack<ASTNode> parentNodes = new Stack();
        private final Map<ASTNode, List<Variable>> initializedVariablesAll = new HashMap<ASTNode, List<Variable>>();
        private final Map<ASTNode, List<Variable>> uninitializedVariablesAll = new HashMap<ASTNode, List<Variable>>();
        private final List<Hint> hints = new LinkedList<Hint>();

        private CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        private Collection<? extends Hint> getHints() {
            for (ASTNode scopeNode : this.uninitializedVariablesAll.keySet()) {
                this.createHints(this.getUninitializedVariables(scopeNode));
            }
            return this.hints;
        }

        private void createHints(List<Variable> uninitializedVariables) {
            for (Variable variable : uninitializedVariables) {
                int start = variable.getStartOffset() + 1;
                int end = variable.getEndOffset();
                OffsetRange offsetRange = new OffsetRange(start, end);
                this.hints.add(new Hint((Rule)UninitializedVariableHint.this, Bundle.UninitializedVariableVariableHintCustom(this.getVariableName(variable)), this.fileObject, offsetRange, null, 500));
            }
        }

        @Override
        public void visit(Program node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(FunctionDeclaration node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(Assignment node) {
            VariableBase leftHandSide = node.getLeftHandSide();
            this.initializeVariableBase(leftHandSide);
        }

        @Override
        public void visit(CatchClause node) {
            this.initializeVariable(node.getVariable());
            this.scan(node.getClassName());
            this.scan(node.getBody());
        }

        @Override
        public void visit(DoStatement node) {
            this.scan(node.getBody());
            this.scan(node.getCondition());
        }

        @Override
        public void visit(ForEachStatement node) {
            this.scan(node.getExpression());
            this.initializeExpression(node.getKey());
            this.initializeExpression(node.getValue());
        }

        @Override
        public void visit(FormalParameter node) {
            Expression expression = node.getParameterName();
            if (expression instanceof Reference) {
                Reference reference = (Reference)expression;
                expression = reference.getExpression();
            }
            this.initializeExpression(expression);
        }

        @Override
        public void visit(GlobalStatement node) {
            for (Variable variable : node.getVariables()) {
                this.initializeVariable(variable);
            }
        }

        @Override
        public void visit(Variable node) {
            if (this.isProcessableVariable(node)) {
                this.addUninitializedVariable(node);
            }
        }

        @Override
        public void visit(ConstantDeclaration node) {
        }

        @Override
        public void visit(ContinueStatement node) {
        }

        @Override
        public void visit(FieldsDeclaration node) {
        }

        @Override
        public void visit(GotoLabel node) {
        }

        @Override
        public void visit(GotoStatement node) {
        }

        @Override
        public void visit(InterfaceDeclaration node) {
        }

        @Override
        public void visit(PHPDocBlock node) {
        }

        @Override
        public void visit(PHPDocTypeTag node) {
        }

        @Override
        public void visit(PHPDocMethodTag node) {
        }

        @Override
        public void visit(PHPDocVarTypeTag node) {
        }

        @Override
        public void visit(PHPDocStaticAccessType node) {
        }

        @Override
        public void visit(PHPVarComment node) {
        }

        @Override
        public void visit(SingleFieldDeclaration node) {
        }

        @Override
        public void visit(StaticFieldAccess node) {
        }

        @Override
        public void visit(UseStatement node) {
        }

        @Override
        public void visit(UseStatementPart node) {
        }

        private boolean isProcessableVariable(Variable node) {
            Identifier identifier = this.getIdentifier(node);
            return identifier != null && !UNCHECKED_VARIABLES.contains(identifier.getName()) && !this.isInitialized(node) && !this.isUninitialized(node);
        }

        private void initializeVariable(Variable variable) {
            if (!this.isInitialized(variable) && !this.isUninitialized(variable)) {
                this.addInitializedVariable(variable);
            }
        }

        private boolean isInitialized(Variable node) {
            return this.contains(this.getInitializedVariables(this.parentNodes.peek()), node);
        }

        private boolean isUninitialized(Variable node) {
            return this.contains(this.getUninitializedVariables(this.parentNodes.peek()), node);
        }

        private boolean contains(List<Variable> scopeVariables, Variable node) {
            boolean retval = false;
            String currentVariableName = this.getVariableName(node);
            for (Variable variable : scopeVariables) {
                if (!currentVariableName.equals(this.getVariableName(variable))) continue;
                retval = true;
                break;
            }
            return retval;
        }

        private String getVariableName(Variable variable) {
            String retval = "";
            Identifier identifier = this.getIdentifier(variable);
            if (identifier != null) {
                retval = identifier.getName();
            }
            return retval;
        }

        private void initializeExpression(Expression expression) {
            if (expression instanceof Variable) {
                this.initializeVariable((Variable)expression);
            }
        }

        private void initializeVariableBase(VariableBase variableBase) {
            if (variableBase instanceof Variable) {
                this.initializeVariable((Variable)variableBase);
            } else if (variableBase instanceof ListVariable) {
                this.initializeListVariable((ListVariable)variableBase);
            } else {
                super.visit(variableBase);
            }
        }

        public void initializeListVariable(ListVariable node) {
            List<VariableBase> variables = node.getVariables();
            for (VariableBase variableBase : variables) {
                this.initializeVariableBase(variableBase);
            }
        }

        private void addInitializedVariable(Variable node) {
            List<Variable> scopeVariables = this.getInitializedVariables(this.parentNodes.peek());
            scopeVariables.add(node);
        }

        private void addUninitializedVariable(Variable node) {
            List<Variable> scopeVariables = this.getUninitializedVariables(this.parentNodes.peek());
            scopeVariables.add(node);
        }

        private List<Variable> getInitializedVariables(ASTNode parent) {
            List<Variable> scopeVariables = this.initializedVariablesAll.get(parent);
            if (scopeVariables == null) {
                scopeVariables = new LinkedList<Variable>();
                this.initializedVariablesAll.put(parent, scopeVariables);
            }
            return scopeVariables;
        }

        private List<Variable> getUninitializedVariables(ASTNode parent) {
            List<Variable> scopeVariables = this.uninitializedVariablesAll.get(parent);
            if (scopeVariables == null) {
                scopeVariables = new LinkedList<Variable>();
                this.uninitializedVariablesAll.put(parent, scopeVariables);
            }
            return scopeVariables;
        }

        @CheckForNull
        private Identifier getIdentifier(Variable variable) {
            Identifier retval = null;
            if (variable != null && variable.isDollared() && variable.getName() instanceof Identifier) {
                retval = (Identifier)variable.getName();
            }
            return retval;
        }
    }
}

