/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.CastExpression;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.CloneExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ContinueStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DeclareStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.EchoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocStaticAccessType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.PostfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.PrefixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ThrowStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UnaryOperation;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.PHPRuleWithPreferences;
import org.netbeans.modules.php.editor.verification.UnusedVariableCustomizer;
import org.openide.filesystems.FileObject;

public class UnusedVariableHint
extends AbstractRule
implements PHPRuleWithPreferences {
    private static final String HINT_ID = "Unused.Variable.Hint";
    private static final String CHECK_UNUSED_FORMAL_PARAMETERS = "php.verification.check.unused.formal.parameters";
    private static final List<String> UNCHECKED_VARIABLES = new LinkedList<String>();
    private Preferences preferences;

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        CheckVisitor checkVisitor = new CheckVisitor(fileObject);
        phpParseResult.getProgram().accept(checkVisitor);
        hints.addAll(checkVisitor.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.UnusedVariableHintDesc();
    }

    public String getDisplayName() {
        return Bundle.UnusedVariableHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return new UnusedVariableCustomizer(preferences, this);
    }

    public void setCheckUnusedFormalParameters(Preferences preferences, boolean isEnabled) {
        preferences.putBoolean(CHECK_UNUSED_FORMAL_PARAMETERS, isEnabled);
    }

    public boolean checkUnusedFormalParameters(Preferences preferences) {
        return preferences.getBoolean(CHECK_UNUSED_FORMAL_PARAMETERS, true);
    }

    static {
        UNCHECKED_VARIABLES.add("this");
        UNCHECKED_VARIABLES.add("GLOBALS");
        UNCHECKED_VARIABLES.add("_SERVER");
        UNCHECKED_VARIABLES.add("_GET");
        UNCHECKED_VARIABLES.add("_POST");
        UNCHECKED_VARIABLES.add("_FILES");
        UNCHECKED_VARIABLES.add("_COOKIE");
        UNCHECKED_VARIABLES.add("_SESSION");
        UNCHECKED_VARIABLES.add("_REQUEST");
        UNCHECKED_VARIABLES.add("_ENV");
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final Stack<ASTNode> parentNodes = new Stack();
        private final Map<ASTNode, List<Variable>> unusedVariables = new HashMap<ASTNode, List<Variable>>();
        private final Map<ASTNode, List<Variable>> usedVariables = new HashMap<ASTNode, List<Variable>>();
        private final FileObject fileObject;
        private boolean forceVariableAsUsed;
        private boolean forceVariableAsUnused;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public List<Hint> getHints() {
            LinkedList<Hint> hints = new LinkedList<Hint>();
            for (ASTNode scopeNode : this.unusedVariables.keySet()) {
                List<Variable> scopeVariables = this.unusedVariables.get(scopeNode);
                for (Variable variable : scopeVariables) {
                    int start = variable.getStartOffset() + 1;
                    int end = variable.getEndOffset();
                    OffsetRange offsetRange = new OffsetRange(start, end);
                    hints.add(new Hint((Rule)UnusedVariableHint.this, Bundle.UnusedVariableHintCustom(this.getIdentifier(variable).getName()), this.fileObject, offsetRange, null, 500));
                }
            }
            return hints;
        }

        @CheckForNull
        private Identifier getIdentifier(Variable variable) {
            Identifier retval = null;
            if (variable != null && variable.isDollared() && variable.getName() instanceof Identifier) {
                retval = (Identifier)variable.getName();
            }
            return retval;
        }

        private List<Variable> getUsedScopeVariables(ASTNode parentNode) {
            List<Variable> usedScopeVariables = this.usedVariables.get(parentNode);
            if (usedScopeVariables == null) {
                usedScopeVariables = new LinkedList<Variable>();
                this.usedVariables.put(parentNode, usedScopeVariables);
            }
            return usedScopeVariables;
        }

        private List<Variable> getUnusedScopeVariables(ASTNode parentNode) {
            List<Variable> unusedScopeVariables = this.unusedVariables.get(parentNode);
            if (unusedScopeVariables == null) {
                unusedScopeVariables = new LinkedList<Variable>();
                this.unusedVariables.put(parentNode, unusedScopeVariables);
            }
            return unusedScopeVariables;
        }

        @CheckForNull
        private Variable getUnusedVariable(String currentVarName, List<Variable> unusedScopeVariables) {
            Variable retval = null;
            for (Variable variable : unusedScopeVariables) {
                String varName = this.getIdentifier(variable).getName();
                if (!currentVarName.equals(varName)) continue;
                retval = variable;
                break;
            }
            return retval;
        }

        private boolean isVariableUsed(String currentVarName, List<Variable> usedScopeVariables) {
            boolean retval = false;
            for (Variable variable : usedScopeVariables) {
                String varName = this.getIdentifier(variable).getName();
                if (!currentVarName.equals(varName)) continue;
                retval = true;
                break;
            }
            return retval;
        }

        private void forceVariableAsUnused(Variable node, List<Variable> unusedScopeVariables) {
            String currentVarName = this.getIdentifier(node).getName();
            Variable unusedVariable = this.getUnusedVariable(currentVarName, unusedScopeVariables);
            if (unusedVariable != null) {
                unusedScopeVariables.remove(unusedVariable);
            }
            unusedScopeVariables.add(node);
        }

        private void forceVariableAsUsed(Variable node, List<Variable> usedScopeVariables, List<Variable> unusedScopeVariables) {
            String currentVarName = this.getIdentifier(node).getName();
            if (this.isVariableUsed(currentVarName, usedScopeVariables)) {
                return;
            }
            usedScopeVariables.add(node);
            Variable unusedVariable = this.getUnusedVariable(currentVarName, unusedScopeVariables);
            if (unusedVariable != null) {
                unusedScopeVariables.remove(unusedVariable);
            }
        }

        @Override
        public void visit(Variable node) {
            Identifier identifier = this.getIdentifier(node);
            if (identifier != null && !UNCHECKED_VARIABLES.contains(identifier.getName())) {
                ASTNode parentNode = this.parentNodes.peek();
                String currentVarName = this.getIdentifier(node).getName();
                List<Variable> usedScopeVariables = this.getUsedScopeVariables(parentNode);
                List<Variable> unusedScopeVariables = this.getUnusedScopeVariables(parentNode);
                if (this.forceVariableAsUnused) {
                    this.forceVariableAsUnused(node, unusedScopeVariables);
                    return;
                }
                if (this.forceVariableAsUsed) {
                    this.forceVariableAsUsed(node, usedScopeVariables, unusedScopeVariables);
                    return;
                }
                if (this.isVariableUsed(currentVarName, usedScopeVariables)) {
                    return;
                }
                Variable unusedVariable = this.getUnusedVariable(currentVarName, unusedScopeVariables);
                if (unusedVariable != null) {
                    unusedScopeVariables.remove(unusedVariable);
                    usedScopeVariables.add(node);
                    return;
                }
                unusedScopeVariables.add(node);
            }
        }

        @Override
        public void visit(Program node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (node.getBody() != null) {
                this.parentNodes.push(node);
                super.visit(node);
                this.parentNodes.pop();
            }
        }

        @Override
        public void visit(EchoStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpressions());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ExpressionStatement node) {
            if (node.getExpression() instanceof Variable) {
                this.forceVariableAsUnused = true;
                this.scan(node.getExpression());
                this.forceVariableAsUnused = false;
            } else {
                this.scan(node.getExpression());
            }
        }

        @Override
        public void visit(Include node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(FunctionInvocation node) {
            this.forceVariableAsUsed = true;
            super.visit(node);
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(MethodInvocation node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getDispatcher());
            this.forceVariableAsUsed = false;
            this.scan(node.getMethod());
        }

        @Override
        public void visit(IfStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.forceVariableAsUsed = false;
            this.scan(node.getTrueStatement());
            this.scan(node.getFalseStatement());
        }

        @Override
        public void visit(InstanceOfExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(PostfixExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getVariable());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(PrefixExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getVariable());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ReflectionVariable node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getName());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(CloneExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(CastExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(Assignment node) {
            this.scan(node.getLeftHandSide());
            this.forceVariableAsUsed = true;
            this.scan(node.getRightHandSide());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ConditionalExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.scan(node.getIfTrue());
            this.scan(node.getIfFalse());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ReturnStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(SwitchStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(ThrowStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(UnaryOperation node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ClassDeclaration node) {
            this.scan(node.getBody());
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getClassName());
            this.scan(node.ctorParams());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(DoStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(DeclareStatement node) {
            this.scan(node.getBody());
        }

        @Override
        public void visit(CatchClause node) {
            this.scan(node.getVariable());
            this.scan(node.getBody());
        }

        @Override
        public void visit(FormalParameter node) {
            if (UnusedVariableHint.this.checkUnusedFormalParameters(UnusedVariableHint.this.preferences)) {
                this.scan(node.getParameterName());
            } else {
                this.forceVariableAsUsed = true;
                this.scan(node.getParameterName());
                this.forceVariableAsUsed = false;
            }
        }

        @Override
        public void visit(ForEachStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
            this.scan(node.getKey());
            this.scan(node.getValue());
            this.scan(node.getStatement());
        }

        @Override
        public void visit(ForStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getInitializers());
            this.scan(node.getConditions());
            this.scan(node.getUpdaters());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getClassName());
            this.forceVariableAsUsed = false;
            this.scan(node.getMethod());
        }

        @Override
        public void visit(SwitchCase node) {
            this.scan(node.getActions());
        }

        @Override
        public void visit(WhileStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            this.forceVariableAsUsed = false;
            this.scan(node.getFormalParameters());
            if (UnusedVariableHint.this.checkUnusedFormalParameters(UnusedVariableHint.this.preferences)) {
                this.scan(node.getLexicalVariables());
            } else {
                this.forceVariableAsUsed = true;
                this.scan(node.getLexicalVariables());
                this.forceVariableAsUsed = false;
            }
            this.scan(node.getBody());
        }

        @Override
        public void visit(StaticFieldAccess node) {
            this.forceVariableAsUsed = true;
            super.visit(node);
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(InterfaceDeclaration node) {
        }

        @Override
        public void visit(FieldsDeclaration node) {
        }

        @Override
        public void visit(PHPDocBlock node) {
        }

        @Override
        public void visit(PHPDocTypeTag node) {
        }

        @Override
        public void visit(PHPDocMethodTag node) {
        }

        @Override
        public void visit(PHPDocVarTypeTag node) {
        }

        @Override
        public void visit(PHPDocStaticAccessType node) {
        }

        @Override
        public void visit(PHPVarComment node) {
        }

        @Override
        public void visit(ConstantDeclaration node) {
        }

        @Override
        public void visit(ContinueStatement node) {
        }

        @Override
        public void visit(SingleFieldDeclaration node) {
        }

        @Override
        public void visit(UseStatement node) {
        }

        @Override
        public void visit(UseStatementPart node) {
        }

        @Override
        public void visit(GotoLabel node) {
        }

        @Override
        public void visit(GotoStatement node) {
        }
    }
}

