/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.flow;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.flow.FlowPresenter;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.model.AccessController;
import org.netbeans.modules.vmd.api.model.AccessControllerFactory;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;

public class FlowAccessController
implements AccessController {
    private DesignDocument document;
    private FlowScene scene;
    private HashSet<FlowPresenter> dirtyPresenters = new HashSet();
    private volatile long eventID = 0L;

    public FlowAccessController(DesignDocument document) {
        this.document = document;
        this.scene = new FlowScene(document);
    }

    public void writeAccess(Runnable runnable) {
        runnable.run();
    }

    public void notifyEventFiring(DesignEvent event) {
    }

    public void notifyEventFired(DesignEvent event) {
        if (this.eventID < event.getEventID()) {
            this.eventID = event.getEventID();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FlowAccessController.this.document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        FlowAccessController.this.scene.setCurrentEventIDForPreferredNodeLocationProcessing(FlowAccessController.this.eventID);
                        FlowAccessController.this.resolveDirty();
                        FlowAccessController.this.scene.setCurrentEventIDForPreferredNodeLocationProcessing(null);
                        if (!"flow".equals(FlowAccessController.this.document.getSelectionSourceID())) {
                            HashSet<? extends FlowDescriptor> objects = new HashSet<FlowDescriptor>();
                            for (DesignComponent component : FlowAccessController.this.document.getSelectedComponents()) {
                                for (FlowPresenter presenter : component.getPresenters(FlowPresenter.class)) {
                                    objects.addAll(presenter.getFlowDescriptors());
                                }
                            }
                            FlowAccessController.this.scene.setSelectedObjects(objects);
                        }
                        FlowAccessController.this.scene.validate();
                    }
                });
            }
        });
    }

    public void notifyComponentsCreated(Collection<DesignComponent> createdComponents) {
    }

    public FlowScene getScene() {
        return this.scene;
    }

    public JComponent getCreateView() {
        JComponent view = this.scene.getView();
        if (view == null) {
            view = this.scene.createView();
        }
        return view;
    }

    public JComponent createSatelliteView() {
        return this.scene.createSatelliteView();
    }

    public void addDirtyPresenter(FlowPresenter presenter) {
        this.dirtyPresenters.add(presenter);
    }

    private void resolveDirty() {
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.updateDescriptors();
        }
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.resolveRemoveBadge();
        }
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.resolveRemoveEdge();
        }
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.resolveRemovePin();
        }
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.resolveRemoveNode();
        }
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.resolveAddNode();
        }
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.resolveAddPin();
        }
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.resolveAddEdge();
        }
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.resolveAddBadge();
        }
        for (FlowPresenter presenter : this.dirtyPresenters) {
            presenter.resolveUpdate();
        }
        this.dirtyPresenters.clear();
        this.scene.resolveOrderInNodeDescriptors();
    }

    public static class Factory
    implements AccessControllerFactory {
        public AccessController createAccessController(DesignDocument document) {
            return new FlowAccessController(document);
        }
    }
}

