/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.eecommon.api.FindJSPServletHelper;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.Hk2OptionalFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.j2ee.deployment.plugins.spi.FindJSPServlet;

class FindJSPServletImpl
implements FindJSPServlet {
    private final String domainDir;
    private final String domain;
    private final GlassfishModule commonSupport;

    public FindJSPServletImpl(Hk2DeploymentManager dm, Hk2OptionalFactory aThis) {
        this.commonSupport = dm.getCommonServerSupport();
        this.domainDir = (String)this.commonSupport.getInstanceProperties().get("domainsfolder");
        this.domain = (String)this.commonSupport.getInstanceProperties().get("domainname");
    }

    public File getServletTempDirectory(final String moduleContextPath) {
        String remappedMCP;
        block10: {
            File retVal = new File(this.domainDir, "/" + this.domain + "/generated/jsp/" + moduleContextPath);
            if (retVal.exists()) {
                return retVal;
            }
            File t = new File(this.domainDir, "/" + this.domain + "/generated/jsp/");
            File[] subdirs = t.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            });
            if (null != subdirs) {
                final ArrayList candidates = new ArrayList();
                for (File z : subdirs) {
                    z.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory() && f.getAbsolutePath().endsWith(moduleContextPath + "_war")) {
                                candidates.add(f);
                                return true;
                            }
                            return false;
                        }
                    });
                }
                if (candidates.size() == 1) {
                    return (File)candidates.get(0);
                }
                if (candidates.size() > 1) {
                    Logger.getLogger("glassfish-javaee").log(Level.INFO, "multiple candidates (" + candidates.size() + ") for " + moduleContextPath);
                }
            }
            remappedMCP = moduleContextPath;
            ServerCommand.GetPropertyCommand gpc = new ServerCommand.GetPropertyCommand("applications.application.*.context-root");
            Future result = this.commonSupport.execute((ServerCommand)gpc);
            try {
                if (result.get(60L, TimeUnit.SECONDS) != GlassfishModule.OperationState.COMPLETED) break block10;
                Map map = gpc.getData();
                for (Map.Entry e : map.entrySet()) {
                    if (!moduleContextPath.equals(e.getValue())) continue;
                    remappedMCP = ((String)e.getKey()).replace("applications.application.", "").replace(".context-root", "");
                    break;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            catch (TimeoutException ex) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        return new File(this.domainDir, "/" + this.domain + "/generated/jsp/" + remappedMCP);
    }

    public String getServletResourcePath(String moduleContextPath, String jspResourcePath) {
        return FindJSPServletHelper.getServletResourcePath((String)moduleContextPath, (String)jspResourcePath);
    }

    public String getServletEncoding(String moduleContextPath, String jspResourcePath) {
        return FindJSPServletHelper.getServletEncoding((String)moduleContextPath, (String)jspResourcePath);
    }
}

