/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.javaee.AntDeploymentProviderImpl;
import org.netbeans.modules.glassfish.javaee.FindJSPServletImpl;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentFactory;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.Hk2MessageDestinationManager;
import org.netbeans.modules.glassfish.javaee.Hk2ServerInstanceDescriptor;
import org.netbeans.modules.glassfish.javaee.Hk2StartServer;
import org.netbeans.modules.glassfish.javaee.JDBCDriverDeployerImpl;
import org.netbeans.modules.glassfish.javaee.JavaEEServerModule;
import org.netbeans.modules.glassfish.javaee.db.Hk2DatasourceManager;
import org.netbeans.modules.glassfish.javaee.ide.FastDeploy;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.plugins.spi.AntDeploymentProvider;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.deployment.plugins.spi.FindJSPServlet;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerInstanceDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;

public class Hk2OptionalFactory
extends OptionalDeploymentManagerFactory {
    private final DeploymentFactory df;
    private final ServerUtilities commonUtilities;
    private final boolean hasWizard;

    protected Hk2OptionalFactory(DeploymentFactory df, ServerUtilities su, boolean hasWizard) {
        this.df = df;
        this.commonUtilities = su;
        this.hasWizard = hasWizard;
    }

    public static Hk2OptionalFactory createPrelude() {
        ServerUtilities t = ServerUtilities.getPreludeUtilities();
        return null == t ? null : new Hk2OptionalFactory(Hk2DeploymentFactory.createPrelude(), t, false);
    }

    public static Hk2OptionalFactory createEe6() {
        ServerUtilities t = ServerUtilities.getEe6Utilities();
        return null == t ? null : new Hk2OptionalFactory(Hk2DeploymentFactory.createEe6(), t, true);
    }

    public StartServer getStartServer(DeploymentManager dm) {
        return new Hk2StartServer(dm);
    }

    public IncrementalDeployment getIncrementalDeployment(DeploymentManager dm) {
        Hk2DeploymentManager hk2dm;
        FastDeploy result = null;
        if (dm instanceof Hk2DeploymentManager && (hk2dm = (Hk2DeploymentManager)dm).isLocal()) {
            result = new FastDeploy(hk2dm);
        }
        return result;
    }

    public FindJSPServlet getFindJSPServlet(DeploymentManager dm) {
        assert (dm instanceof Hk2DeploymentManager) : "dm isn't an hk2dm";
        FindJSPServletImpl retVal = null;
        try {
            Hk2DeploymentManager hk2dm = (Hk2DeploymentManager)dm;
            if (!hk2dm.getCommonServerSupport().isRemote()) {
                retVal = new FindJSPServletImpl(hk2dm, this);
            }
        }
        catch (ClassCastException cce) {
            Logger.getLogger("glassfish-javaee").log(Level.FINER, "caller passed invalid param", cce);
        }
        return retVal;
    }

    public boolean isCommonUIRequired() {
        return false;
    }

    public WizardDescriptor.InstantiatingIterator getAddInstanceIterator() {
        return this.hasWizard ? new J2eeInstantiatingIterator(this.commonUtilities) : null;
    }

    public DatasourceManager getDatasourceManager(DeploymentManager dm) {
        return dm instanceof Hk2DeploymentManager ? new Hk2DatasourceManager((Hk2DeploymentManager)dm) : null;
    }

    public JDBCDriverDeployer getJDBCDriverDeployer(DeploymentManager dm) {
        assert (dm instanceof Hk2DeploymentManager) : "dm isn't an hk2dm";
        JDBCDriverDeployerImpl retVal = null;
        try {
            retVal = new JDBCDriverDeployerImpl((Hk2DeploymentManager)dm, this);
        }
        catch (ClassCastException cce) {
            Logger.getLogger("glassfish-javaee").log(Level.FINER, "caller passed invalid param", cce);
        }
        return retVal;
    }

    public MessageDestinationDeployment getMessageDestinationDeployment(DeploymentManager dm) {
        return dm instanceof Hk2DeploymentManager ? new Hk2MessageDestinationManager((Hk2DeploymentManager)dm) : null;
    }

    public AntDeploymentProvider getAntDeploymentProvider(DeploymentManager dm) {
        assert (dm instanceof Hk2DeploymentManager) : "dm isn't an hk2dm";
        AntDeploymentProviderImpl retVal = null;
        try {
            retVal = new AntDeploymentProviderImpl((Hk2DeploymentManager)dm, this);
        }
        catch (ClassCastException cce) {
            Logger.getLogger("glassfish-javaee").log(Level.FINER, "caller passed invalid param", cce);
        }
        return retVal;
    }

    public ServerInstanceDescriptor getServerInstanceDescriptor(DeploymentManager dm) {
        Hk2ServerInstanceDescriptor result = null;
        if (dm instanceof Hk2DeploymentManager) {
            result = new Hk2ServerInstanceDescriptor((Hk2DeploymentManager)dm);
        } else {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Invalid deployment manager: {0}", dm);
        }
        return result;
    }

    private static class J2eeInstantiatingIterator
    implements WizardDescriptor.InstantiatingIterator {
        private final WizardDescriptor.InstantiatingIterator delegate;
        private ServerUtilities su;

        public J2eeInstantiatingIterator(ServerUtilities su) {
            this.delegate = su.getAddInstanceIterator();
            this.su = su;
        }

        public void removeChangeListener(ChangeListener l) {
            this.delegate.removeChangeListener(l);
        }

        public void previousPanel() {
            this.delegate.previousPanel();
        }

        public void nextPanel() {
            this.delegate.nextPanel();
        }

        public String name() {
            return this.delegate.name();
        }

        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public WizardDescriptor.Panel current() {
            return this.delegate.current();
        }

        public void addChangeListener(ChangeListener l) {
            this.delegate.addChangeListener(l);
        }

        public void uninitialize(WizardDescriptor wizard) {
            this.delegate.uninitialize(wizard);
        }

        public Set instantiate() throws IOException {
            Set set = this.delegate.instantiate();
            if (!set.isEmpty()) {
                Object obj = set.iterator().next();
                if (obj instanceof ServerInstance) {
                    ServerInstance instance = (ServerInstance)obj;
                    Lookup lookup = this.su.getLookupFor(instance);
                    if (lookup != null) {
                        JavaEEServerModule module = (JavaEEServerModule)lookup.lookup(JavaEEServerModule.class);
                        if (module != null) {
                            return Collections.singleton(module.getInstanceProperties());
                        }
                        Logger.getLogger("glassfish-javaee").log(Level.WARNING, "No JavaEE facade found for {0}", instance.getDisplayName());
                    } else {
                        Logger.getLogger("glassfish-javaee").log(Level.WARNING, "No lookup found for {0}", instance.getDisplayName());
                    }
                } else {
                    Logger.getLogger("glassfish-javaee").log(Level.WARNING, "AddServerWizard iterator must return a set of ServerInstance objects.");
                }
            }
            return Collections.EMPTY_SET;
        }

        public void initialize(WizardDescriptor wizard) {
            this.delegate.initialize(wizard);
        }
    }
}

