/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.mobility.e2e.mapping.ServerJavonTemplate;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.output.OutputLogger;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class Util {
    private Util() {
    }

    public static SourceGroup getPreselectedGroup(SourceGroup[] groups, String preselectedFolder) {
        if (preselectedFolder != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (!groups[i].getName().equals(preselectedFolder)) continue;
                return groups[i];
            }
        }
        return groups.length >= 0 ? groups[0] : null;
    }

    public static Project openProject() {
        return Util.openProject(null);
    }

    public static Project openProject(String projectFolder) {
        Project project;
        block4: {
            int option;
            File folder;
            project = null;
            if (projectFolder != null && (folder = new File(projectFolder)).exists() && folder.isDirectory()) {
                ProjectChooser.setProjectsFolder((File)folder);
            }
            JFileChooser chooser = ProjectChooser.projectChooser();
            NotifyDescriptor.Message message1 = new NotifyDescriptor.Message((Object)NbBundle.getMessage(Util.class, (String)"MSG_notProjectDir"), 2);
            NotifyDescriptor.Message message2 = new NotifyDescriptor.Message((Object)NbBundle.getMessage(Util.class, (String)"ERR_NoWebProject"), 2);
            while ((option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                File projectDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
                project = Util.fileToProject(projectDir);
                if (project == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message1);
                    continue;
                }
                if (!Util.isWebProject(project)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message2);
                    continue;
                }
                break block4;
            }
            return null;
        }
        OpenProjects.getDefault().open(new Project[]{project}, true);
        return project;
    }

    public static boolean isWebProject(Project p) {
        if (p == null) {
            return false;
        }
        WebModuleProvider provider = (WebModuleProvider)p.getLookup().lookup(WebModuleProvider.class);
        return provider != null;
    }

    public static Project fileToProject(File projectDir) {
        try {
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)projectDir));
            if (fo != null) {
                return ProjectManager.getDefault().findProject(fo);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Project getServerProject(Configuration configuration) {
        Project result = null;
        OpenProjects openProject = OpenProjects.getDefault();
        Project[] openedProjects = openProject.getOpenProjects();
        String serverProjectName = configuration.getServerConfigutation().getProjectName();
        for (Project p : openedProjects) {
            ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
            String webProjectName = pi.getName();
            if (!serverProjectName.equals(webProjectName)) continue;
            result = p;
            break;
        }
        return result;
    }

    public static void addServletToWebProject(Project project, JavonMapping mapping) {
        try {
            boolean servlet = false;
            String servletName = mapping.getServerMapping().getClassName();
            String packageName = mapping.getServerMapping().getPackageName();
            String servletClassFQN = packageName.length() != 0 ? packageName + '.' + servletName : servletName;
            WebModuleProvider provider = (WebModuleProvider)project.getLookup().lookup(WebModuleProvider.class);
            WebModule wm = provider.findWebModule(project.getProjectDirectory());
            FileObject ddFO = wm.getDeploymentDescriptor();
            if (ddFO == null) {
                ddFO = Util.createWebXml(wm);
            }
            if (ddFO == null) {
                throw new IllegalStateException(NbBundle.getMessage(Util.class, (String)"ERR_NoDeploymentDescriptor"));
            }
            WebApp webApp = DDProvider.getDefault().getDDRootCopy(ddFO);
            Servlet[] servlets = webApp.getServlet();
            for (int i = 0; i < servlets.length; ++i) {
                if (!servlets[i].getServletClass().equals(servletClassFQN)) continue;
                servlet = true;
            }
            if (!servlet) {
                servletName = Util.findFreeName(servletName, webApp);
                OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_AddServlet"), servletName, FileUtil.toFile((FileObject)project.getProjectDirectory())));
                Servlet newServlet = (Servlet)webApp.createBean("Servlet");
                newServlet.setServletName(servletName);
                newServlet.setServletClass(servletClassFQN);
                newServlet.setDescription(NbBundle.getMessage(Util.class, (String)"TXT_servletElementDescription"));
                newServlet.setDisplayName("Javon service for  " + servletClassFQN);
                webApp.addServlet(newServlet);
                ServletMapping newServletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                newServletMapping.setServletName(servletName);
                newServletMapping.setUrlPattern("/servlet/" + servletClassFQN);
                webApp.addServletMapping(newServletMapping);
                webApp.write(ddFO);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static FileObject createWebXml(WebModule wm) throws IOException {
        FileObject docBase;
        FileObject ddFO = null;
        FileObject webInf = wm.getWebInf();
        if (webInf == null && (docBase = wm.getDocumentBase()) != null) {
            webInf = docBase.createFolder("WEB-INF");
        }
        if (webInf != null) {
            ddFO = DDHelper.createWebXml((Profile)wm.getJ2eeProfile(), (FileObject)webInf);
        }
        return ddFO;
    }

    private static String findFreeName(String servletName, WebApp webApp) {
        int nameIndex = 0;
        Servlet[] servlets = webApp.getServlet();
        for (int i = 0; i < servlets.length && servlets[i].getServletName().equals(servletName); ++i) {
            servletName = servletName + ++nameIndex;
        }
        ServletMapping[] servletsMapping = webApp.getServletMapping();
        for (int i = 0; i < servletsMapping.length && servletsMapping[i].getServletName().equals(servletName); ++i) {
            servletName = servletName + ++nameIndex;
        }
        return servletName;
    }

    public static String getServerURL(Project p, Configuration configuration) {
        InstanceProperties ip;
        String port = "8080";
        J2eeModuleProvider provider = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (ip = provider.getInstanceProperties()) != null) {
            port = ip.getProperty("httpportnumber") != null ? ip.getProperty("httpportnumber") : "8080";
        }
        return "http://localhost:" + port + "/" + configuration.getServerConfigutation().getProjectName() + "/servlet/" + configuration.getServerConfigutation().getClassDescriptor().getType();
    }

    public static boolean isSuitableProjectConfiguration(Project project) {
        if (!(project instanceof J2MEProject)) {
            return false;
        }
        String profile = Util.evaluateProjectProperty((J2MEProject)project, "platform.profile");
        return "MIDP-2.0".equals(profile);
    }

    private static String evaluateProjectProperty(J2MEProject project, String property) {
        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        ProjectConfigurationsHelper confs = project.getConfigurationHelper();
        String activeConfiguration = confs.getActiveConfiguration() != confs.getDefaultConfiguration() ? confs.getActiveConfiguration().getDisplayName() : null;
        return Util.evaluateProperty(ep, property, activeConfiguration);
    }

    private static String evaluateProperty(EditableProperties ep, String propertyName, String configuration) {
        if (configuration == null) {
            return ep.getProperty(propertyName);
        }
        String value = ep.getProperty("configs." + configuration + "." + propertyName);
        return value != null ? value : Util.evaluateProperty(ep, propertyName, null);
    }

    public static String getServerLocation(Project project) {
        return "localhost";
    }

    public static String getServerPort(Project project) {
        InstanceProperties ip;
        String port = "8080";
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (ip = provider.getInstanceProperties()) != null) {
            port = ip.getProperty("httpportnumber") != null ? ip.getProperty("httpportnumber") : "8080";
        }
        return port;
    }

    public static boolean registerDataBindingLibrary(Project p) {
        Library[] libraries;
        ProjectClassPathExtender pcpe = (ProjectClassPathExtender)p.getLookup().lookup(ProjectClassPathExtender.class);
        for (Library library : libraries = LibraryManager.getDefault().getLibraries()) {
            if (!library.getName().equals("DataBindingME")) continue;
            try {
                pcpe.addLibrary(library);
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        return false;
    }
}

