/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.JDialog;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.java.navigation.JavaHierarchyPanel;
import org.netbeans.modules.java.navigation.ResizablePopup;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class JavaHierarchy {
    private static final Logger LOG = Logger.getLogger(JavaHierarchy.class.getName());

    public static void show(FileObject fileObject) {
        JavaSource javaSource;
        if (fileObject != null && (javaSource = JavaSource.forFileObject((FileObject)fileObject)) != null) {
            final AtomicReference handles = new AtomicReference();
            AtomicBoolean cancel = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                List topLevels = compilationController.getTopLevelElements();
                                Element[] elements = topLevels.toArray(new Element[topLevels.size()]);
                                handles.set(JavaHierarchy.getHandles(elements));
                            }
                        }, true);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }, (String)NbBundle.getMessage(JavaHierarchy.class, (String)"TITLE_Hierarchy", (Object)fileObject.getName()), (AtomicBoolean)cancel, (boolean)false);
            if (!cancel.get() && handles.get() != null) {
                JavaHierarchy.show(fileObject, (ElementHandle[])handles.get());
            }
        }
    }

    public static void show(FileObject fileObject, ElementHandle[] elements) {
        LOG.log(Level.FINE, "Showing hierarchy for: {0}", fileObject == null ? null : FileUtil.getFileDisplayName((FileObject)fileObject));
        if (fileObject != null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchy.class, (String)"LBL_WaitNode"));
            JDialog dialog = ResizablePopup.getDialog(fileObject);
            StringBuilder membersOf = new StringBuilder();
            if (elements != null && elements.length > 0) {
                int start = elements[0].getKind() == ElementKind.PACKAGE && elements.length > 1 ? 1 : 0;
                boolean first = true;
                for (int i = start; i < elements.length; ++i) {
                    if (!first) {
                        membersOf.append(", ");
                    } else {
                        first = false;
                    }
                    membersOf.append(SourceUtils.getJVMSignature((ElementHandle)elements[i])[0]);
                }
            }
            String title = NbBundle.getMessage(JavaHierarchy.class, (String)"TITLE_Hierarchy", (Object)membersOf);
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHierarchy.class, (String)"ACSD_JavaHierarchyDialog", (Object)membersOf));
            dialog.setTitle(title);
            dialog.setContentPane(new JavaHierarchyPanel(fileObject, elements));
            dialog.setVisible(true);
            LOG.log(Level.FINE, "Opened hierarchy for: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
        }
    }

    @CheckForNull
    public static final ElementHandle[] getHandles(@NullAllowed Element[] elements) {
        if (elements == null) {
            return null;
        }
        ElementHandle[] res = new ElementHandle[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            res[i] = ElementHandle.create((Element)elements[i]);
        }
        return res;
    }
}

