/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.Utils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class JavaHierarchyModel
extends DefaultTreeModel {
    private static final Logger LOG = Logger.getLogger(JavaHierarchyModel.class.getName());
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    static ElementHandle[] EMPTY_ELEMENTHANDLES_ARRAY = new ElementHandle[0];
    private FileObject fileObject;
    private ElementHandle[] elementHandles;
    private Collection<? extends SourceGroup> sgCache;

    public JavaHierarchyModel(FileObject fileObject, ElementHandle[] elements) {
        super(null);
        this.fileObject = fileObject;
        this.elementHandles = elements == null ? EMPTY_ELEMENTHANDLES_ARRAY : elements;
    }

    public void update() {
        this.update(this.elementHandles);
    }

    private void update(final ElementHandle[] elementHandles) {
        if (elementHandles == null && elementHandles.length == 0) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ArrayList<Element> elementsList = new ArrayList<Element>(elementHandles.length);
                        for (ElementHandle elementHandle : elementHandles) {
                            Element element = elementHandle.resolve((CompilationInfo)compilationController);
                            if (element != null) {
                                elementsList.add(element);
                                continue;
                            }
                            LOG.warning(elementHandle.toString() + " cannot be resolved using: " + compilationController.getClasspathInfo());
                        }
                        Element[] elements = elementsList.toArray(EMPTY_ELEMENTS_ARRAY);
                        JavaHierarchyModel.this.update(elements, (CompilationInfo)compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private void update(Element[] elements, CompilationInfo compilationInfo) {
        if (elements == null && elements.length == 0) {
            return;
        }
        DefaultMutableTreeNode _root = new DefaultMutableTreeNode();
        for (Element element : elements) {
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.ENUM && element.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            if (JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy()) {
                _root.add(new TypeTreeNode(this.fileObject, (TypeElement)element, compilationInfo, null));
                continue;
            }
            Types types = compilationInfo.getTypes();
            TypeElement typeElement = (TypeElement)element;
            ArrayList<TypeElement> superClasses = new ArrayList<TypeElement>();
            superClasses.add(typeElement);
            TypeElement superClass = (TypeElement)types.asElement(typeElement.getSuperclass());
            while (superClass != null) {
                superClasses.add(0, superClass);
                superClass = (TypeElement)types.asElement(superClass.getSuperclass());
            }
            DefaultMutableTreeNode parent = _root;
            for (TypeElement superTypeElement : superClasses) {
                FileObject _fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)superTypeElement), (ClasspathInfo)compilationInfo.getClasspathInfo());
                SimpleTypeTreeNode child = new SimpleTypeTreeNode(_fileObject, superTypeElement, compilationInfo, null, typeElement != superTypeElement || typeElement.getQualifiedName().contentEquals(Object.class.getName()));
                parent.insert(child, 0);
                parent = child;
            }
            JavaMembersAndHierarchyOptions.setSubTypeHierarchyDepth(superClasses.size() + 2);
        }
        this.setRoot(_root);
    }

    void fireTreeNodesChanged() {
        super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    void fireTreeStructureChanged() {
        super.fireTreeStructureChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    private Collection<? extends SourceGroup> getSourceGroups() {
        if (this.sgCache == null) {
            ArrayList<? extends SourceGroup> result = new ArrayList<SourceGroup>();
            Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
            if (openProjects == null) {
                return null;
            }
            for (Project project : openProjects) {
                Sources sources = ProjectUtils.getSources((Project)project);
                SourceGroup[] sourceGroups = sources.getSourceGroups("java");
                assert (sourceGroups != null);
                for (SourceGroup sourceGroup : sourceGroups) {
                    result.add((SourceGroup)sourceGroup);
                }
            }
            this.sgCache = result;
        }
        return this.sgCache;
    }

    private static String handleAsResourceName(ElementHandle<TypeElement> handle) {
        return handle.getBinaryName().replace('.', '/') + ".class";
    }

    private class SimpleTypeTreeNode
    extends AbstractHierarchyTreeNode {
        private boolean inSuperClassRole;

        SimpleTypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, AbstractHierarchyTreeNode owner) {
            this(fileObject, typeElement, compilationInfo, owner, false);
        }

        SimpleTypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, AbstractHierarchyTreeNode owner, boolean inSuperClassRole) {
            super(fileObject, typeElement, compilationInfo, owner, inSuperClassRole);
            this.inSuperClassRole = inSuperClassRole;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            if (this.inSuperClassRole) {
                return;
            }
            TypeElement typeElement = (TypeElement)element;
            if (typeElement.getQualifiedName().toString().equals(Object.class.getName())) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchyModel.class, (String)"MSG_WontShowSubTypesOfObject", (Object)Object.class.getName()));
                return;
            }
            LinkedHashSet<ElementHandle> processedImplementorElementHandles = new LinkedHashSet<ElementHandle>();
            ElementHandle typeElementHandle = ElementHandle.create((Element)typeElement);
            final int[] index = new int[]{0};
            Collection sourceGroups = JavaHierarchyModel.this.getSourceGroups();
            if (sourceGroups == null) {
                return;
            }
            for (SourceGroup sourceGroup : sourceGroups) {
                ClassIndex classIndex;
                ClasspathInfo classpathInfo;
                FileObject rootFileObject = sourceGroup.getRootFolder();
                if (rootFileObject == null) continue;
                ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{rootFileObject});
                ClassPath bootClassPath = ClassPath.getClassPath((FileObject)rootFileObject, (String)"classpath/boot");
                ClassPath compileClassPath = ClassPath.getClassPath((FileObject)rootFileObject, (String)"classpath/compile");
                if (classPath == null || (classpathInfo = ClasspathInfo.create((ClassPath)bootClassPath, (ClassPath)compileClassPath, (ClassPath)classPath)) == null || (classIndex = classpathInfo.getClassIndex()) == null) continue;
                Set implementors = classIndex.getElements(typeElementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
                for (ElementHandle implementorElementHandle : implementors) {
                    JavaSource javaSource;
                    if (processedImplementorElementHandles.contains(implementorElementHandle)) continue;
                    processedImplementorElementHandles.add(implementorElementHandle);
                    final ElementHandle finalImplementorElementHandle = implementorElementHandle;
                    FileObject implementorfileObject = SourceUtils.getFile((ElementHandle)implementorElementHandle, (ClasspathInfo)classpathInfo);
                    if (implementorfileObject == null) {
                        implementorfileObject = bootClassPath.findResource(JavaHierarchyModel.handleAsResourceName((ElementHandle<TypeElement>)implementorElementHandle));
                    }
                    if (implementorfileObject == null) {
                        implementorfileObject = compileClassPath.findResource(JavaHierarchyModel.handleAsResourceName((ElementHandle<TypeElement>)implementorElementHandle));
                    }
                    if (implementorfileObject == null || (javaSource = JavaSource.forFileObject((FileObject)implementorfileObject)) == null) continue;
                    try {
                        final FileObject implementorfileObjectFin = implementorfileObject;
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                Element implementor = finalImplementorElementHandle.resolve((CompilationInfo)compilationController);
                                if (implementor instanceof TypeElement && ((TypeElement)implementor).getNestingKind() != NestingKind.ANONYMOUS) {
                                    int n = index[0];
                                    index[0] = n + 1;
                                    SimpleTypeTreeNode.this.insert(new SimpleTypeTreeNode(implementorfileObjectFin, (TypeElement)implementor, (CompilationInfo)compilationController, (AbstractHierarchyTreeNode)SimpleTypeTreeNode.this), n);
                                }
                            }
                        }, true);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
        }
    }

    private class TypeTreeNode
    extends AbstractHierarchyTreeNode {
        private boolean inSuperClassRole;

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, AbstractHierarchyTreeNode owner) {
            this(fileObject, typeElement, compilationInfo, owner, false);
        }

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, AbstractHierarchyTreeNode owner, boolean inSuperClassRole) {
            super(fileObject, typeElement, compilationInfo, owner);
            this.inSuperClassRole = inSuperClassRole;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            this.loadChildren(element, compilationInfo, 0);
        }

        protected int loadChildren(Element element, CompilationInfo compilationInfo, int index) {
            TypeElement typeElement;
            Types types = compilationInfo.getTypes();
            TypeElement superClass = (TypeElement)types.asElement((typeElement = (TypeElement)element).getSuperclass());
            if (superClass != null && !superClass.getQualifiedName().toString().equals(Object.class.getName()) && !this.hasCycle(superClass)) {
                this.insert(new TypeTreeNode(this.getFileObject(), superClass, compilationInfo, (AbstractHierarchyTreeNode)this, true), index++);
            }
            List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                TypeElement interfaceElement = (TypeElement)types.asElement(typeMirror);
                if (interfaceElement == null || this.hasCycle(interfaceElement)) continue;
                this.insert(new TypeTreeNode(this.getFileObject(), interfaceElement, compilationInfo, (AbstractHierarchyTreeNode)this, true), index++);
            }
            if (JavaMembersAndHierarchyOptions.isShowInner() && !this.inSuperClassRole) {
                for (Element element2 : typeElement.getEnclosedElements()) {
                    TypeTreeNode node = null;
                    if (element2.getKind() != ElementKind.CLASS && element2.getKind() != ElementKind.INTERFACE && element2.getKind() != ElementKind.ENUM && element2.getKind() != ElementKind.ANNOTATION_TYPE) continue;
                    node = new TypeTreeNode(this.getFileObject(), (TypeElement)element2, compilationInfo, (AbstractHierarchyTreeNode)this, true);
                    if (this.hasCycle((TypeElement)element2)) continue;
                    this.insert(node, index++);
                }
            }
            return index;
        }

        private boolean hasCycle(TypeElement type) {
            String binName = ElementUtilities.getBinaryName((TypeElement)type);
            for (AbstractHierarchyTreeNode node = this; node != null; node = node.getOwningTreeNode()) {
                if (!(node instanceof TypeTreeNode) || !binName.equals(node.getElementHandle().getBinaryName())) continue;
                return true;
            }
            return false;
        }
    }

    private abstract class AbstractHierarchyTreeNode
    extends DefaultMutableTreeNode
    implements JavaElement {
        private FileObject fileObject;
        private ElementHandle<? extends Element> elementHandle;
        private ElementKind elementKind;
        private Set<Modifier> modifiers;
        private String name = "";
        private String label = "";
        private String FQNlabel = "";
        private String tooltip = null;
        private Icon icon = null;
        private ElementJavadoc javaDoc = null;
        private final ClasspathInfo cpInfo;
        private boolean loaded = false;
        private AbstractHierarchyTreeNode owner;

        AbstractHierarchyTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo, AbstractHierarchyTreeNode owner) {
            this(fileObject, element, compilationInfo, owner, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractHierarchyTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo, AbstractHierarchyTreeNode owner, boolean lazyLoadChildren) {
            this.fileObject = fileObject;
            this.elementHandle = ElementHandle.create((Element)element);
            this.elementKind = element.getKind();
            this.modifiers = element.getModifiers();
            this.cpInfo = compilationInfo.getClasspathInfo();
            this.owner = owner;
            this.setName(element.getSimpleName().toString());
            this.setIcon(ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers()));
            this.setLabel(Utils.format(element));
            this.setFQNLabel(Utils.format(element, false, true));
            this.setToolTip(Utils.format(element, true, JavaMembersAndHierarchyOptions.isShowFQN()));
            if (!lazyLoadChildren) {
                try {
                    this.loadChildren(element, compilationInfo);
                }
                finally {
                    this.loaded = true;
                }
            }
        }

        public AbstractHierarchyTreeNode getOwningTreeNode() {
            return this.owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getChildCount() {
            if (!this.loaded) {
                try {
                    this.loadChildren();
                }
                finally {
                    this.loaded = true;
                }
            }
            return super.getChildCount();
        }

        @Override
        public FileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public ElementKind getElementKind() {
            return this.elementKind;
        }

        protected void setName(String name) {
            this.name = name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        protected void setLabel(String label) {
            this.label = label;
        }

        @Override
        public String getFQNLabel() {
            return this.FQNlabel;
        }

        protected void setFQNLabel(String FQNlabel) {
            this.FQNlabel = FQNlabel;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        protected void setToolTip(String tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }

        protected void setElementHandle(ElementHandle<? extends Element> elementHandle) {
            this.elementHandle = elementHandle;
        }

        @Override
        public ElementJavadoc getJavaDoc() {
            if (this.javaDoc == null) {
                if (this.fileObject == null) {
                    return null;
                }
                JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
                if (javaSource != null) {
                    try {
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                Element element = AbstractHierarchyTreeNode.this.elementHandle.resolve((CompilationInfo)compilationController);
                                AbstractHierarchyTreeNode.this.setJavaDoc(ElementJavadoc.create((CompilationInfo)compilationController, (Element)element));
                            }
                        }, true);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
            return this.javaDoc;
        }

        protected void setJavaDoc(ElementJavadoc javaDoc) {
            this.javaDoc = javaDoc;
        }

        @Override
        public ElementHandle getElementHandle() {
            return this.elementHandle;
        }

        @Override
        public void gotoElement() {
            this.openElementHandle();
        }

        protected void loadChildren() {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Element element = AbstractHierarchyTreeNode.this.elementHandle.resolve((CompilationInfo)compilationController);
                            if (!(element instanceof TypeElement) || !((TypeElement)element).getQualifiedName().toString().equals(Object.class.getName())) {
                                AbstractHierarchyTreeNode.this.loadChildren(element, (CompilationInfo)compilationController);
                            }
                        }
                    }, true);
                    return;
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }

        protected abstract void loadChildren(Element var1, CompilationInfo var2);

        @Override
        public String toString() {
            return JavaMembersAndHierarchyOptions.isShowFQN() ? this.getFQNLabel() : this.getLabel();
        }

        protected void openElementHandle() {
            if (this.fileObject == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchyModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
                return;
            }
            if (this.elementHandle == null) {
                return;
            }
            if (!ElementOpen.open((ClasspathInfo)this.cpInfo, this.elementHandle)) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchyModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
            }
        }
    }
}

