/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.modules.java.navigation.CaretListeningFactory;
import org.netbeans.modules.java.navigation.DocumentationScrollPane;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class JavadocTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(JavadocTopComponent.class.getName());
    private static JavadocTopComponent instance;
    public static final String ICON_PATH = "org/netbeans/modules/java/navigation/resources/javadoc_action.png";
    private static final String PREFERRED_ID = "JavadocTopComponent";
    private DocumentationScrollPane documentationPane;

    private JavadocTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(JavadocTopComponent.class, (String)"CTL_JavadocTopComponent"));
        this.setToolTipText(NbBundle.getMessage(JavadocTopComponent.class, (String)"HINT_JavadocTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.documentationPane = new DocumentationScrollPane(false);
        this.add(this.documentationPane, "Center");
    }

    void setJavadoc(ElementJavadoc doc) {
        this.documentationPane.setData(doc);
    }

    public static boolean shouldUpdate() {
        if (instance == null) {
            LOGGER.fine("shouldUpdate -> false (no instance)");
            return false;
        }
        boolean isShowing = instance.isShowing();
        LOGGER.log(Level.FINE, "shouldUpdate -> {0}", isShowing);
        return isShowing;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized JavadocTopComponent getDefault() {
        if (instance == null) {
            instance = new JavadocTopComponent();
        }
        return instance;
    }

    public static synchronized JavadocTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            LOGGER.log(Level.WARNING, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return JavadocTopComponent.getDefault();
        }
        if (win instanceof JavadocTopComponent) {
            return (JavadocTopComponent)win;
        }
        LOGGER.log(Level.FINE, "There seem to be multiple components with the 'JavadocTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return JavadocTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected void componentActivated() {
        super.componentActivated();
        this.documentationPane.getViewport().getView().requestFocusInWindow();
    }

    public void componentOpened() {
        this.documentationPane.getViewport().getView().requestFocusInWindow();
    }

    protected void componentShowing() {
        super.componentShowing();
        CaretListeningFactory.runAgain();
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return JavadocTopComponent.getDefault();
        }
    }
}

