/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.Group;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.platform.URLResolver;
import org.w3c.dom.DOMException;

public class Anchor
extends Group {
    protected String href = "";
    protected String target = "";

    public Anchor(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "a";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Anchor(doc);
    }

    public String getHref() {
        String uriBase = this.getURIBase();
        String docBase = this.ownerDocument.getURIBase();
        if (uriBase != null && uriBase.equals(docBase) && this.href != null && this.href.length() > 0 && this.href.charAt(0) == '#') {
            uriBase = null;
        }
        try {
            if (uriBase != null) {
                return URLResolver.resolve(uriBase, this.href);
            }
            return this.href;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public void setHref(String href) {
        if (href == null) {
            throw new IllegalArgumentException();
        }
        if (href.equals(this.href)) {
            return;
        }
        this.modifyingNode();
        this.href = href;
        this.modifiedNode();
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (target.equals(this.target)) {
            return;
        }
        this.modifyingNode();
        this.target = target;
        this.modifiedNode();
    }

    boolean supportsTrait(String traitName) {
        if ("target" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    boolean supportsTraitNS(String namespaceURI, String traitName) {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == traitName) {
            return true;
        }
        return super.supportsTraitNS(namespaceURI, traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("target" == name) {
            return this.getTarget();
        }
        return super.getTraitImpl(name);
    }

    String getTraitNSImpl(String namespaceURI, String name) throws DOMException {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
            String res = this.getHref();
            if (res == null) {
                res = this.href;
            }
            return res;
        }
        return super.getTraitNSImpl(namespaceURI, name);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("target" == name) {
            if (value == null) {
                throw this.illegalTraitValue(name, value);
            }
            this.setTarget(value);
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setTraitNSImpl(String namespaceURI, String name, String value) throws DOMException {
        try {
            if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
                this.setHref(value);
            } else {
                super.setTraitNSImpl(namespaceURI, name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new DOMException(15, iae.getMessage());
        }
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("target" == traitName) {
            return new StringTraitAnim(this, "#!null/ns@!", traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    TraitAnim createTraitAnimNSImpl(String traitNamespace, String traitName) {
        if (traitNamespace == "http://www.w3.org/1999/xlink" && traitName == "href") {
            return new StringTraitAnim(this, traitNamespace, traitName);
        }
        return super.createTraitAnimNSImpl(traitNamespace, traitName);
    }

    public String toString() {
        return "Anchor[href=(" + this.href + ") absolute href=(" + this.getHref() + ")]";
    }
}

