/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.HeapDumpWatch;
import org.netbeans.modules.profiler.actions.RerunAction;
import org.netbeans.modules.profiler.nbimpl.ProfilerControlPanel2Support;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.actions.CallableSystemAction;

public class NetBeansProfiler
extends org.netbeans.modules.profiler.NetBeansProfiler {
    private ProfilerControlPanel2Support actionSupport;

    public void runTarget(FileObject buildScriptFO, String target, Properties props) {
        this.getActionSupport().setAll(buildScriptFO, target, props);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((RerunAction)RerunAction.get(RerunAction.class)).updateAction();
            }
        });
        NetBeansProfiler.doRunTarget(buildScriptFO, target, props);
    }

    public static ExecutorTask doRunTarget(FileObject buildScript, String target, Properties props) {
        try {
            String oomeenabled = props.getProperty("profiler.info.oomeprotection");
            if (oomeenabled != null && oomeenabled.equals("yes")) {
                HeapDumpWatch.getDefault().monitor(props.getProperty("profiler.info.oomeprotection.dumppath"));
            }
            return ActionUtils.runTarget((FileObject)buildScript, (String[])new String[]{target}, (Properties)props);
        }
        catch (IOException e) {
            Profiler.getDefault().notifyException(8, (Exception)e);
            return null;
        }
    }

    public String getLibsDir() {
        File dir = InstalledFileLocator.getDefault().locate("lib/jfluid-server.jar", "org.netbeans.lib.profiler", false);
        if (dir == null) {
            return null;
        }
        return dir.getParentFile().getPath();
    }

    public boolean rerunAvailable() {
        int state = this.getProfilingState();
        return state == 1 || state == 16 ? this.getActionSupport().isActionAvailable() : false;
    }

    public boolean modifyAvailable() {
        return this.getProfilingMode() == 0 || this.getActionSupport().isActionAvailable();
    }

    public void rerunLastProfiling() {
        String target = this.getActionSupport().getTarget();
        if (target != null) {
            NetBeansProfiler.doRunTarget(this.getActionSupport().getScript(), target, this.getActionSupport().getProperties());
        }
    }

    public boolean attachToApp(ProfilingSettings profilingSettings, AttachSettings attachSettings) {
        this.getActionSupport().nullAll();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((RerunAction)CallableSystemAction.get(RerunAction.class)).updateAction();
            }
        });
        return super.attachToApp(profilingSettings, attachSettings);
    }

    public void modifyCurrentProfiling(ProfilingSettings profilingSettings) {
        Properties properties = this.getActionSupport().getProperties();
        if (properties != null) {
            profilingSettings.store((Map)properties);
        }
        super.modifyCurrentProfiling(profilingSettings);
    }

    Properties getCurrentProfilingProperties() {
        return this.getActionSupport().getProperties();
    }

    protected void cleanupAfterProfiling() {
        this.stopLoadGenerator();
        super.cleanupAfterProfiling();
    }

    private void stopLoadGenerator() {
        String scriptPath;
        LoadGenPlugin plugin;
        Properties profilingProperties = this.getCurrentProfilingProperties();
        if (profilingProperties != null && (plugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class)) != null && (scriptPath = profilingProperties.getProperty("profiler.loadgen.path")) != null) {
            plugin.stop(scriptPath);
        }
    }

    private synchronized ProfilerControlPanel2Support getActionSupport() {
        if (this.actionSupport == null) {
            this.actionSupport = new ProfilerControlPanel2Support();
        }
        return this.actionSupport;
    }
}

